/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.usermanager.jcr;

import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaGroupManagerRoutingService;
import org.jahia.services.usermanager.JahiaPrincipal;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerRoutingService;
import org.jahia.services.usermanager.jcr.JCRGroupManagerProvider;
import org.jahia.services.usermanager.jcr.JCRPrincipal;
import org.jahia.services.usermanager.jcr.JCRUser;
import org.jahia.services.usermanager.jcr.JCRUserManagerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRGroup
extends JahiaGroup
implements JCRPrincipal {
    private static final long serialVersionUID = 1825041318839222308L;
    public static final String J_HIDDEN = "j:hidden";
    public static final String J_EXTERNAL = "j:external";
    public static final String J_EXTERNAL_SOURCE = "j:externalSource";
    public static final String J_DISPLAYABLE_NAME = "j:displayableName";
    private static final String PROVIDER_NAME = "jcr";
    private static transient Logger logger = LoggerFactory.getLogger(JCRGroup.class);
    private String nodeUuid;
    private boolean external;
    private Properties properties = null;

    public JCRGroup(Node nodeWrapper, int siteID) {
        this(nodeWrapper, siteID, false);
    }

    public JCRGroup(Node nodeWrapper, int siteID, boolean isExternal) {
        this.mSiteID = siteID;
        try {
            this.nodeUuid = nodeWrapper.getIdentifier();
            this.mGroupname = nodeWrapper.getName();
            this.mGroupKey = this.mGroupname + ":" + siteID;
            this.hidden = nodeWrapper.getProperty(J_HIDDEN).getBoolean();
            this.initMembersMap(nodeWrapper);
        }
        catch (RepositoryException e) {
            logger.error("Error while accessing repository", (Throwable)e);
        }
        this.external = isExternal;
    }

    @Override
    public Properties getProperties() {
        if (this.properties == null) {
            try {
                JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
                this.properties = new Properties();
                JCRGroupNode jcrGroupNode = (JCRGroupNode)this.getNode(session);
                PropertyIterator iterator = jcrGroupNode.getProperties();
                while (iterator.hasNext()) {
                    Property property = iterator.nextProperty();
                    if (property.isMultiple()) continue;
                    this.properties.put(property.getName(), property.getString());
                }
            }
            catch (RepositoryException e) {
                logger.error("Error while retrieving group properties", (Throwable)e);
            }
        } else {
            return this.properties;
        }
        return null;
    }

    @Override
    public String getProperty(String key) {
        if (this.properties != null) {
            return (String)this.properties.get(key);
        }
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            return this.getNode(session).getProperty(key).getString();
        }
        catch (PathNotFoundException pnfe) {
            return null;
        }
        catch (RepositoryException e) {
            logger.error("Error while retrieving group property " + key, (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean removeProperty(final String key) {
        try {
            return JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRNodeWrapper node = JCRGroup.this.getNode(session);
                    Property property = node.getProperty(key);
                    if (property != null) {
                        if (JCRGroup.this.properties != null) {
                            JCRGroup.this.properties.remove(key);
                        }
                        property.remove();
                        session.save();
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (RepositoryException e) {
            logger.warn("Error while removing property " + key, (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean setProperty(String key, String value) {
        try {
            if (J_EXTERNAL.equals(key)) {
                this.external = Boolean.valueOf(value);
            }
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            JCRNodeWrapper node = this.getNode(session);
            node.setProperty(key, value);
            session.save();
            if (this.properties != null) {
                this.properties.put(key, value);
            }
            return Boolean.TRUE;
        }
        catch (RepositoryException e) {
            logger.warn("Error while setting property " + key + " with value " + value, (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean addMember(final Principal principal) {
        if (null == principal || this.equals(principal)) {
            return false;
        }
        try {
            boolean memberAdded = JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    if (JCRGroup.this.isMember(principal)) {
                        return false;
                    }
                    JCRPrincipal jcrUser = null;
                    String name = principal.getName();
                    if (principal instanceof JCRUser) {
                        jcrUser = (JCRPrincipal)((Object)principal);
                    } else if (principal instanceof JCRGroup) {
                        name = name + "___" + ((JCRGroup)principal).getSiteID();
                        jcrUser = (JCRPrincipal)((Object)principal);
                    } else if (principal instanceof JahiaUser) {
                        JCRTemplate.getInstance().getProvider("/").deployExternalUser((JahiaUser)principal);
                        jcrUser = JCRUserManagerProvider.getInstance().lookupExternalUser((JahiaUser)principal);
                    } else if (principal instanceof JahiaGroup) {
                        JCRTemplate.getInstance().getProvider("/").deployExternalGroup((JahiaGroup)principal);
                        jcrUser = JCRGroupManagerProvider.getInstance().lookupExternalGroup(principal.getName());
                    }
                    if (jcrUser != null) {
                        JCRNodeWrapper node = JCRGroup.this.getNode(session);
                        Node members = node.getNode("j:members");
                        if (!members.hasNode(name)) {
                            Node member = members.addNode(name, "jnt:member");
                            member.setProperty("j:member", jcrUser.getIdentifier());
                            session.save();
                            JCRGroupManagerProvider.getInstance().updateMembershipCache(jcrUser.getIdentifier());
                        }
                        JCRGroup.this.mMembers.add(principal);
                        return true;
                    }
                    return false;
                }
            });
            JCRGroupManagerProvider.getInstance().invalidateCacheRecursively(this);
            return memberAdded;
        }
        catch (RepositoryException e) {
            logger.error("Error while adding group member", (Throwable)e);
            return false;
        }
    }

    @Override
    public int hashCode() {
        return this.nodeUuid.hashCode();
    }

    @Override
    protected Set<Principal> getMembersMap() {
        if (this.mMembers == null) {
            this.initMembers();
        }
        return new HashSet<Principal>(this.mMembers);
    }

    protected void initMembers() {
        if (this.mMembers == null) {
            try {
                JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
                this.initMembersMap(this.getNode(session));
            }
            catch (RepositoryException e) {
                logger.error("Error while retrieving group member map", (Throwable)e);
            }
        }
    }

    private void initMembersMap(Node node) throws RepositoryException {
        if (this.mMembers == null) {
            HashSet<JahiaPrincipal> principals = new HashSet<JahiaPrincipal>();
            Node members = node.getNode("j:members");
            NodeIterator iterator = members.getNodes();
            while (iterator.hasNext()) {
                Node member = (Node)iterator.next();
                if (!member.isNodeType("jnt:member")) continue;
                if (!member.hasProperty("j:member")) {
                    logger.warn("Missing member property for group " + this.mGroupname + "(key=" + this.mGroupKey + "), ignoring group member " + member.getName() + "...");
                    continue;
                }
                Property memberProperty = member.getProperty("j:member");
                Node memberNode = null;
                try {
                    memberNode = memberProperty.getNode();
                }
                catch (ItemNotFoundException infe) {
                    logger.warn("Couldn't find group member " + member.getName() + "(uuid=" + memberProperty.getString() + ") for group " + this.mGroupname + "(key=" + this.mGroupKey + "), ignoring...");
                }
                if (memberNode == null) continue;
                if (memberNode.isNodeType("jnt:user")) {
                    JahiaUser jahiaUser = JahiaUserManagerRoutingService.getInstance().lookupUser(member.getName());
                    if (jahiaUser != null) {
                        principals.add(jahiaUser);
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Member '" + member.getName() + "' cannot be found for group '" + node.getName() + "'");
                    continue;
                }
                if (!memberNode.isNodeType("jnt:group")) continue;
                JahiaGroup g = memberNode.getPath().startsWith("/groups") ? JahiaGroupManagerRoutingService.getInstance().lookupGroup(null, memberNode.getName()) : JahiaGroupManagerRoutingService.getInstance().lookupGroup(((JCRGroupNode)memberNode).getResolveSite().getName(), memberNode.getName());
                if (g != null) {
                    principals.add(g);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Member '" + member.getName() + "' cannot be found for group '" + node.getName() + "'");
            }
            this.mMembers = principals;
            this.preloadedGroups = true;
        }
    }

    @Override
    public boolean removeMember(final Principal principal) {
        try {
            return JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRNodeWrapper group = JCRGroup.this.getNode(session);
                    Node members = group.getNode("j:members");
                    String memberUuid = null;
                    if (principal instanceof JCRPrincipal) {
                        memberUuid = ((JCRPrincipal)((Object)principal)).getIdentifier();
                    } else if (principal instanceof JahiaUser) {
                        JCRUser externalUser = JCRUserManagerProvider.getInstance().lookupExternalUser((JahiaUser)principal);
                        if (externalUser != null) {
                            memberUuid = externalUser.getIdentifier();
                        } else {
                            logger.warn("User node for an external user with the name '" + principal.getName() + " cannot be found. Skip removing user from group " + group.getPath());
                        }
                    } else if (principal instanceof JahiaGroup) {
                        JCRGroup externalGroup = JCRGroupManagerProvider.getInstance().lookupExternalGroup(((JahiaGroup)principal).getGroupname());
                        if (externalGroup != null) {
                            memberUuid = externalGroup.getIdentifier();
                        } else {
                            logger.warn("JCR node for an external group with the name '" + principal.getName() + " cannot be found. Skip removing principal from group " + group.getPath());
                        }
                    } else {
                        logger.warn("Cannot remove membership for principal " + principal + " in group " + group.getPath() + ". Do not know how to handle this principal type.");
                    }
                    return memberUuid != null ? JCRGroup.this.removeMember(session, members, memberUuid) : Boolean.FALSE;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("Error while removing member", (Throwable)e);
            return false;
        }
    }

    private boolean removeMember(JCRSessionWrapper session, Node members, String memberIdentifier) throws RepositoryException {
        if (session.getWorkspace().getQueryManager() != null) {
            String query = "SELECT * FROM [jnt:member] as m where m.[j:member] = '" + memberIdentifier + "' AND ISCHILDNODE(m, '" + members.getPath() + "') ORDER BY localname(m)";
            QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
            QueryResult qr = q.execute();
            NodeIterator nodes = qr.getNodes();
            while (nodes.hasNext()) {
                Node memberNode = nodes.nextNode();
                memberNode.remove();
            }
            session.save();
            this.mMembers = null;
            this.initMembers();
            JCRGroupManagerProvider.getInstance().updateMembershipCache(memberIdentifier);
            JCRGroupManagerProvider.getInstance().invalidateCacheRecursively(this);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder output = new StringBuilder(128);
        output.append("Details of group [").append(this.mGroupname).append("] :\n");
        output.append("  - ID : ").append(this.getIdentifier()).append("\n");
        try {
            output.append("  - properties :");
            if (this.properties != null && !this.properties.isEmpty()) {
                output.append("\n");
                for (Map.Entry<Object, Object> property : this.properties.entrySet()) {
                    output.append("       ").append(property.getKey()).append(" -> [").append(property.getValue()).append("]\n");
                }
            } else {
                output.append(" -no properties-\n");
            }
            output.append("  - members : ");
            if (this.mMembers != null) {
                if (this.mMembers.size() > 0) {
                    for (Principal member : this.mMembers) {
                        output.append(member.getName()).append("/");
                    }
                } else {
                    output.append(" -no members-\n");
                }
            } else {
                output.append(" -preloading of members disabled-\n");
            }
        }
        catch (Exception e) {
            logger.debug("Error while generating toString output for group " + this.mGroupname, (Throwable)e);
        }
        return output.toString();
    }

    @Override
    public String getProviderName() {
        return PROVIDER_NAME;
    }

    @Override
    public JCRNodeWrapper getNode(JCRSessionWrapper session) throws RepositoryException {
        return session.getNodeByIdentifier(this.getIdentifier());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JCRGroup jcrGroup = (JCRGroup)o;
        return this.nodeUuid.equals(jcrGroup.nodeUuid);
    }

    @Override
    public String getIdentifier() {
        return this.nodeUuid;
    }

    public boolean isExternal() {
        return this.external;
    }

    @Override
    public void addMembers(final Collection<Principal> principals) {
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    for (Principal principal : principals) {
                        if (JCRGroup.this.isMember(principal) || null == principal || JCRGroup.this.equals(principal)) continue;
                        JCRPrincipal jcrUser = null;
                        String name = principal.getName();
                        if (principal instanceof JCRUser) {
                            jcrUser = (JCRPrincipal)((Object)principal);
                        } else if (principal instanceof JCRGroup) {
                            name = name + "___" + ((JCRGroup)principal).getSiteID();
                            jcrUser = (JCRPrincipal)((Object)principal);
                        } else if (principal instanceof JahiaUser) {
                            JCRTemplate.getInstance().getProvider("/").deployExternalUser((JahiaUser)principal);
                            jcrUser = JCRUserManagerProvider.getInstance().lookupExternalUser((JahiaUser)principal);
                        } else if (principal instanceof JahiaGroup) {
                            JCRTemplate.getInstance().getProvider("/").deployExternalGroup((JahiaGroup)principal);
                            jcrUser = JCRGroupManagerProvider.getInstance().lookupExternalGroup(principal.getName());
                        }
                        if (jcrUser == null) continue;
                        JCRNodeWrapper node = JCRGroup.this.getNode(session);
                        Node members = node.getNode("j:members");
                        if (!members.hasNode(name)) {
                            Node member = members.addNode(name, "jnt:member");
                            member.setProperty("j:member", jcrUser.getIdentifier());
                            JCRGroupManagerProvider.getInstance().updateMembershipCache(jcrUser.getIdentifier());
                        }
                        JCRGroup.this.mMembers.add(principal);
                    }
                    session.save();
                    return null;
                }
            });
            JCRGroupManagerProvider.getInstance().invalidateCacheRecursively(this);
        }
        catch (RepositoryException e) {
            logger.error("Error while adding group member", (Throwable)e);
        }
    }
}

