/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.usermanager.jcr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.drools.core.util.StringUtils;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.cache.CacheHelper;
import org.jahia.services.cache.ehcache.EhCacheProvider;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.usermanager.GuestGroup;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaGroupManagerProvider;
import org.jahia.services.usermanager.JahiaGroupManagerRoutingService;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaPrincipal;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerProvider;
import org.jahia.services.usermanager.JahiaUserManagerRoutingService;
import org.jahia.services.usermanager.ProviderEvent;
import org.jahia.services.usermanager.UsersGroup;
import org.jahia.services.usermanager.jcr.JCRGroup;
import org.jahia.services.usermanager.jcr.JCRPrincipal;
import org.jahia.services.usermanager.jcr.JCRUser;
import org.jahia.services.usermanager.jcr.JCRUserManagerProvider;
import org.jahia.services.usermanager.jcr.ProviderClassLoaderAwareCacheEntry;
import org.jahia.utils.ClassLoaderUtils;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;

public class JCRGroupManagerProvider
extends JahiaGroupManagerProvider
implements ApplicationListener<ProviderEvent> {
    private static transient Logger logger = LoggerFactory.getLogger(JCRGroupManagerProvider.class);
    private transient JCRTemplate jcrTemplate;
    private static JCRGroupManagerProvider mGroupManagerProvider = new JCRGroupManagerProvider();
    private JCRUserManagerProvider userManagerProvider;
    private transient JahiaSitesService sitesService;
    private transient Ehcache cache;
    private Ehcache membershipCache;
    private ClassLoader chainedClassLoader;
    private boolean chainedClassLoaderInitialized;
    private EhCacheProvider cacheProvider;
    public static final String JCR_GROUPMEMBERSHIP_CACHE = "JCRGroupMembershipCache";

    public static JCRGroupManagerProvider getInstance() {
        return mGroupManagerProvider;
    }

    public void setJcrTemplate(JCRTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    public void setSitesService(JahiaSitesService sitesService) {
        this.sitesService = sitesService;
    }

    @Override
    public JCRGroup createGroup(final int siteID, final String name, final Properties properties, final boolean hidden) {
        try {
            return this.jcrTemplate.doExecuteWithSystemSession(new JCRCallback<JCRGroup>(){

                @Override
                public JCRGroup doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRNodeWrapper parentNodeWrapper;
                    if (siteID == 0) {
                        parentNodeWrapper = session.getNode("/groups");
                    } else {
                        String siteName = JCRGroupManagerProvider.this.sitesService.getSiteKeyById(siteID);
                        parentNodeWrapper = session.getNode("/sites/" + siteName + "/groups");
                    }
                    JCRNodeWrapper nodeWrapper = parentNodeWrapper.addNode(name, "jnt:group");
                    nodeWrapper.setProperty("j:hidden", hidden);
                    if (properties != null) {
                        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                            if (entry.getValue() instanceof Boolean) {
                                nodeWrapper.setProperty((String)entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            nodeWrapper.setProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    session.save();
                    JCRGroup jcrGroup = new JCRGroup(nodeWrapper, siteID);
                    JCRGroupManagerProvider.this.cachePut(jcrGroup.getGroupKey(), jcrGroup);
                    return jcrGroup;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("Error while creating group", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteGroup(JahiaGroup group) {
        if (group instanceof JCRGroup) {
            JCRGroup jcrGroup = (JCRGroup)group;
            List<String> membership = null;
            try {
                membership = this.getMembership(jcrGroup);
                Boolean aBoolean = this.jcrTemplate.doExecuteWithSystemSession(this.deleteCallback(jcrGroup));
                aBoolean = aBoolean != false && this.jcrTemplate.doExecuteWithSystemSession(null, "live", this.deleteCallback(jcrGroup)) != false;
                boolean bl = aBoolean;
                return bl;
            }
            catch (RepositoryException e) {
                logger.error("Error while deleting group", (Throwable)e);
            }
            finally {
                this.cache.remove((Serializable)((Object)group.getGroupKey()));
                this.membershipCache.removeAll();
                this.invalidateCachesForMembership(membership);
            }
        }
        return false;
    }

    private JCRCallback<Boolean> deleteCallback(final JCRGroup jcrGroup) {
        return new JCRCallback<Boolean>(){

            @Override
            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRNodeWrapper node = null;
                try {
                    node = jcrGroup.getNode(session);
                }
                catch (ItemNotFoundException e) {
                    return true;
                }
                PropertyIterator pi = node.getWeakReferences("j:member");
                while (pi.hasNext()) {
                    JCRPropertyWrapper member = (JCRPropertyWrapper)pi.next();
                    member.getParent().remove();
                }
                node.remove();
                session.save();
                return true;
            }
        };
    }

    @Override
    public List<JahiaSite> getAdminGrantedSites(JahiaUser user) {
        return null;
    }

    @Override
    public JahiaGroup getAdministratorGroup(int siteID) {
        return this.lookupGroup(siteID, siteID == 0 ? "administrators" : "site-administrators");
    }

    @Override
    public List<String> getGroupList() {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            ArrayList<String> groups = new ArrayList<String>();
            if (session.getWorkspace().getQueryManager() != null) {
                String query = "SELECT [j:nodename] FROM [jnt:group] as group WHERE group.[j:external] = 'false' ORDER BY group.[j:nodename]";
                QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
                QueryResult qr = q.execute();
                RowIterator rows = qr.getRows();
                while (rows.hasNext()) {
                    Row groupsFolderNode = rows.nextRow();
                    String groupName = "{jcr}" + groupsFolderNode.getValue("j:nodename").getString();
                    if (groups.contains(groupName)) continue;
                    groups.add(groupName);
                }
            }
            return groups;
        }
        catch (RepositoryException e) {
            logger.error("Error retrieving group list", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    @Override
    public List<String> getGroupList(int siteID) {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            ArrayList<String> groups = new ArrayList<String>();
            if (session.getWorkspace().getQueryManager() != null) {
                StringBuffer query = new StringBuffer("SELECT [j:nodename] FROM [jnt:group] as group WHERE group.[j:external] = 'false'");
                if (siteID <= 0) {
                    query.append(" AND ISCHILDNODE(group, '/groups");
                } else {
                    String siteName = this.sitesService.getSiteKeyById(siteID);
                    query.append(" AND ISCHILDNODE(group, '/sites/").append(siteName).append("/groups')");
                }
                query.append(" ORDER BY group.[j:nodename]");
                QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query.toString(), "JCR-SQL2");
                QueryResult qr = q.execute();
                RowIterator rows = qr.getRows();
                while (rows.hasNext()) {
                    Row groupsFolderNode = rows.nextRow();
                    String groupName = "{jcr}" + groupsFolderNode.getValue("j:nodename").getString() + ":" + siteID;
                    if (groups.contains(groupName)) continue;
                    groups.add(groupName);
                }
            }
            return groups;
        }
        catch (RepositoryException e) {
            logger.error("Error retrieving group list for site " + siteID, (Throwable)e);
            return new ArrayList<String>();
        }
    }

    @Override
    public List<String> getGroupnameList() {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            ArrayList<String> groups = new ArrayList<String>();
            if (session.getWorkspace().getQueryManager() != null) {
                String query = "SELECT [j:nodename] FROM [jnt:group] as group WHERE group.[j:external] = 'false' ORDER BY group.[j:nodename]";
                QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
                QueryResult qr = q.execute();
                RowIterator rows = qr.getRows();
                while (rows.hasNext()) {
                    Row groupsFolderNode = rows.nextRow();
                    String groupName = groupsFolderNode.getValue("j:nodename").getString();
                    if (groups.contains(groupName)) continue;
                    groups.add(groupName);
                }
            }
            return groups;
        }
        catch (RepositoryException e) {
            logger.error("Error retrieving group name list", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    @Override
    public List<String> getGroupnameList(int siteID) {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            ArrayList<String> groups = new ArrayList<String>();
            if (session.getWorkspace().getQueryManager() != null) {
                StringBuilder query = new StringBuilder("SELECT [j:nodename] FROM [jnt:group] as group WHERE group.[j:external] = 'false'");
                if (siteID <= 0) {
                    query.append(" AND ISCHILDNODE(group, '/groups')");
                } else {
                    String siteName = this.sitesService.getSiteKeyById(siteID);
                    query.append(" AND ISCHILDNODE(group, '/sites/" + siteName + "/groups')");
                }
                query.append(" ORDER BY group.[j:nodename]");
                QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query.toString(), "JCR-SQL2");
                QueryResult qr = q.execute();
                RowIterator rows = qr.getRows();
                while (rows.hasNext()) {
                    Row groupsFolderNode = rows.nextRow();
                    String groupName = groupsFolderNode.getValue("j:nodename").getString();
                    if (groups.contains(groupName)) continue;
                    groups.add(groupName);
                }
            }
            return groups;
        }
        catch (RepositoryException e) {
            logger.error("Error retrieving group name list for site " + siteID, (Throwable)e);
            return new ArrayList<String>();
        }
    }

    @Override
    public JahiaGroup getGuestGroup(int siteID) {
        return this.lookupGroup(0, "guest");
    }

    @Override
    public List<String> getUserMembership(JahiaUser user) {
        return this.getMembership(user);
    }

    public List<String> getMembership(JahiaPrincipal principal) {
        JCRGroup extGroup;
        String uuid = null;
        if (principal instanceof JCRPrincipal) {
            uuid = ((JCRPrincipal)((Object)principal)).getIdentifier();
        } else if (principal instanceof JahiaUser) {
            JCRUser extUser = this.userManagerProvider.lookupExternalUser((JahiaUser)principal);
            if (extUser != null) {
                uuid = extUser.getIdentifier();
            }
        } else if (principal instanceof JahiaGroup && (extGroup = this.lookupExternalGroup(((JahiaGroup)principal).getGroupname())) != null) {
            uuid = extGroup.getIdentifier();
        }
        if (uuid != null) {
            try {
                String principalId = uuid;
                Element membershipElement = this.membershipCache.get((Serializable)((Object)uuid));
                List membership = (List)(membershipElement != null ? membershipElement.getObjectValue() : null);
                if (membership != null) {
                    return membership;
                }
                JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
                LinkedHashSet<String> groups = new LinkedHashSet<String>();
                try {
                    this.recurseOnGroups(session, groups, principalId);
                }
                catch (JahiaException e) {
                    logger.warn("Error retrieving membership for user " + principal.getName(), (Throwable)e);
                }
                if (principal instanceof JahiaUser) {
                    if (!principal.getName().equals("guest")) {
                        groups.add("users");
                    }
                    groups.add("guest");
                }
                LinkedList<String> result = new LinkedList<String>(groups);
                this.membershipCache.put(new Element((Object)principalId, result));
                return result;
            }
            catch (RepositoryException e) {
                logger.error("Error retrieving membership for user " + principal.getName() + ", will return empty list", (Throwable)e);
            }
        }
        return new ArrayList<String>();
    }

    private void recurseOnGroups(JCRSessionWrapper session, Set<String> groups, String principalId) throws RepositoryException, JahiaException {
        JCRNodeWrapper node = session.getNodeByUUID(principalId);
        PropertyIterator weakReferences = node.getWeakReferences("j:member");
        while (weakReferences.hasNext()) {
            try {
                Node group;
                Property property = weakReferences.nextProperty();
                if (!property.getPath().contains("j:members") || !(group = property.getParent().getParent().getParent()).isNodeType("jnt:group")) continue;
                int siteID = 0;
                try {
                    Node siteNode = group.getParent().getParent();
                    if (siteNode instanceof JCRSiteNode) {
                        siteID = ((JCRSiteNode)siteNode).getID();
                    }
                }
                catch (NullPointerException e) {
                    siteID = 0;
                }
                if (!groups.add(group.getName() + ":" + siteID)) continue;
                this.recurseOnGroups(session, groups, group.getIdentifier());
            }
            catch (ItemNotFoundException e) {
                logger.warn("Cannot find group for " + node.getPath(), (Throwable)e);
            }
        }
    }

    @Override
    public JahiaGroup getUsersGroup(int siteID) {
        return this.lookupGroup(0, "users");
    }

    @Override
    public boolean groupExists(int siteID, String name) {
        try {
            JCRNodeWrapper groupNode;
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            if (siteID == 0) {
                groupNode = session.getNode("/groups/" + name.trim());
            } else {
                String siteName = this.sitesService.getSiteKeyById(siteID);
                groupNode = session.getNode("/sites/" + siteName + "/groups/" + name.trim());
            }
            return groupNode != null && !groupNode.getProperty("j:external").getBoolean();
        }
        catch (PathNotFoundException e) {
            logger.debug("Error testing existence of group " + name + " for site " + siteID, (Throwable)e);
        }
        catch (RepositoryException e) {
            logger.warn("Error testing existence of group " + name + " for site " + siteID, (Throwable)e);
        }
        return false;
    }

    @Override
    public JahiaGroup lookupGroup(String groupKey) {
        String name;
        int siteID = 0;
        if (groupKey.contains(":")) {
            String[] splittedGroupKey = Patterns.COLON.split(groupKey);
            siteID = Integer.valueOf(splittedGroupKey[1]);
            name = splittedGroupKey[0];
            if ("guest".equals(name) || "users".equals(name)) {
                siteID = 0;
            }
        } else {
            name = groupKey;
        }
        return this.lookupGroup(siteID, name);
    }

    @Override
    public JCRGroup lookupGroup(int siteID, String name) {
        return this.lookupGroup(siteID, name, false);
    }

    public JCRGroup lookupExternalGroup(String name) {
        return this.lookupGroup(0, name, true);
    }

    private JCRGroup lookupGroup(int siteID, String name, boolean allowExternal) {
        try {
            JCRNodeWrapper groupNode;
            String trueGroupKey;
            Element cacheEntry;
            if (name.equals("guest") || name.equals("users")) {
                siteID = 0;
            }
            if ((cacheEntry = this.cache.get((Serializable)((Object)(trueGroupKey = name + ":" + siteID)))) != null) {
                JCRGroup group = (JCRGroup)CacheHelper.getObjectValue(cacheEntry);
                if (group == null) {
                    return null;
                }
                return !allowExternal && group.isExternal() ? null : group;
            }
            int siteID1 = siteID;
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            try {
                if (siteID1 <= 0) {
                    groupNode = session.getNode("/groups/" + name.trim());
                } else {
                    String site = this.sitesService.getSiteKeyById(siteID1);
                    if (StringUtils.isEmpty((CharSequence)site)) {
                        logger.debug("Site {} is not available", (Object)siteID1);
                        return null;
                    }
                    groupNode = session.getNode("/sites/" + site + "/groups/" + name.trim());
                }
            }
            catch (PathNotFoundException e) {
                this.cachePut(trueGroupKey, null);
                return null;
            }
            JCRGroup group = null;
            boolean external = groupNode.getProperty("j:external").getBoolean();
            if (allowExternal || !external) {
                group = this.getGroup(groupNode, name, siteID1, external);
                this.cachePut(trueGroupKey, group);
            }
            return group;
        }
        catch (PathNotFoundException e) {
            logger.debug("Error while retrieving group " + name + " for site " + siteID, (Throwable)e);
        }
        catch (InvalidItemStateException e) {
            logger.debug("Error while retrieving group " + name + " for site " + siteID, (Throwable)e);
        }
        catch (RepositoryException e) {
            logger.warn("Error while retrieving group " + name + " for site " + siteID, (Throwable)e);
        }
        return null;
    }

    private JCRGroup getGroup(Node usersFolderNode, String name, int siteID1, boolean external) {
        JCRGroup group = "guest".equals(name) ? new GuestGroup(usersFolderNode, this.jcrTemplate, siteID1) : ("users".equals(name) ? new UsersGroup(usersFolderNode, this.jcrTemplate, siteID1) : new JCRGroup(usersFolderNode, siteID1, external));
        return group;
    }

    @Override
    public boolean removeUserFromAllGroups(JahiaUser user) {
        try {
            String uuid = null;
            if (user instanceof JCRUser) {
                uuid = ((JCRUser)user).getIdentifier();
            } else {
                JCRUser extUser = this.userManagerProvider.lookupExternalUser(user);
                if (extUser != null) {
                    uuid = extUser.getIdentifier();
                }
            }
            if (uuid != null) {
                final String id = uuid;
                return this.jcrTemplate.doExecuteWithSystemSession(new JCRCallback<Boolean>(){

                    @Override
                    public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        if (session.getWorkspace().getQueryManager() != null) {
                            String query = "SELECT * FROM [jnt:member] as m where m.[j:member] = '" + id + "' ORDER BY m.[j:nodename]";
                            QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
                            QueryResult qr = q.execute();
                            NodeIterator nodes = qr.getNodes();
                            while (nodes.hasNext()) {
                                Node memberNode = nodes.nextNode();
                                memberNode.remove();
                            }
                            session.save();
                            return true;
                        }
                        return false;
                    }
                });
            }
        }
        catch (RepositoryException e) {
            logger.error("Error while removing user from all groups", (Throwable)e);
        }
        return false;
    }

    @Override
    public Set<JahiaGroup> searchGroups(int siteID, Properties searchCriterias) {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            HashSet<JahiaGroup> users = new HashSet<JahiaGroup>();
            if (session.getWorkspace().getQueryManager() != null) {
                Iterator<Map.Entry<Object, Object>> objectIterator;
                StringBuilder query = new StringBuilder("SELECT * FROM [jnt:group] as g WHERE g.[j:external] = 'false'");
                if (siteID <= 0) {
                    query.append(" AND ISCHILDNODE(g, '/groups')");
                } else {
                    String siteName = this.sitesService.getSiteKeyById(siteID);
                    query.append(" AND ISCHILDNODE(g, '/sites/" + siteName + "/groups')");
                }
                if (!(searchCriterias == null || searchCriterias.size() <= 0 || searchCriterias.containsKey("*") && searchCriterias.size() == 1 && searchCriterias.getProperty("*").equals("*") || !(objectIterator = searchCriterias.entrySet().iterator()).hasNext())) {
                    query.append(" AND (");
                    while (objectIterator.hasNext()) {
                        String propertyValue;
                        Map.Entry<Object, Object> entry = objectIterator.next();
                        String propertyKey = (String)entry.getKey();
                        if ("groupname".equals(propertyKey)) {
                            propertyKey = "j:nodename";
                        }
                        propertyValue = "*".equals(propertyValue = (String)entry.getValue()) ? "%" : (propertyValue.contains("*") ? Patterns.STAR.matcher(propertyValue).replaceAll("%") : propertyValue + "%");
                        if ("*".equals(propertyKey)) {
                            query.append("(CONTAINS(g.*,'" + Patterns.PERCENT.matcher(propertyValue).replaceAll("") + "') OR LOWER(g.[j:nodename]) LIKE '").append(propertyValue.toLowerCase()).append("') ");
                        } else {
                            query.append("LOWER(g.[" + Patterns.DOT.matcher(propertyKey).replaceAll("\\\\.") + "])").append(" LIKE '").append(propertyValue.toLowerCase()).append("'");
                        }
                        if (!objectIterator.hasNext()) continue;
                        query.append(" OR ");
                    }
                    query.append(")");
                }
                query.append(" ORDER BY g.[j:nodename]");
                if (logger.isDebugEnabled()) {
                    logger.debug(query.toString());
                }
                QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query.toString(), "JCR-SQL2");
                QueryResult qr = q.execute();
                NodeIterator ni = qr.getNodes();
                while (ni.hasNext()) {
                    Node usersFolderNode = ni.nextNode();
                    users.add(this.getGroup(usersFolderNode, usersFolderNode.getName(), siteID, false));
                }
            }
            return users;
        }
        catch (RepositoryException e) {
            logger.error("Error while searching groups", (Throwable)e);
            return new HashSet<JahiaGroup>();
        }
    }

    @Override
    public void updateCache(JahiaGroup jahiaGroup) {
        this.invalidateCacheRecursively(jahiaGroup);
    }

    public void invalidateCacheRecursively(JahiaGroup jahiaGroup) {
        this.cache.remove((Serializable)((Object)jahiaGroup.getGroupKey()));
        this.invalidateCachesForMembership(this.getMembership(jahiaGroup));
    }

    protected void invalidateCachesForMembership(List<String> membership) {
        if (membership == null || membership.isEmpty()) {
            return;
        }
        JahiaGroupManagerService groupService = ServicesRegistry.getInstance().getJahiaGroupManagerService();
        for (String key : membership) {
            this.cache.remove((Serializable)((Object)key));
            JahiaGroup grp = groupService.lookupGroup(key);
            if (grp == null) continue;
            this.invalidateCachesForMembership(this.getMembership(grp));
        }
    }

    @Override
    public void start() throws JahiaInitializationException {
        this.cache = this.getCacheInternal("JCRGroupCache");
        this.membershipCache = this.getCacheInternal(JCR_GROUPMEMBERSHIP_CACHE);
    }

    private Ehcache getCacheInternal(String cacheName) {
        CacheManager cacheManager;
        Cache cacheInstance = null;
        if (this.cacheProvider != null && (cacheInstance = (cacheManager = this.cacheProvider.getCacheManager()).getCache(cacheName)) == null) {
            cacheManager.addCache(cacheName);
            cacheInstance = cacheManager.getCache(cacheName);
        }
        return cacheInstance;
    }

    @Override
    public void stop() throws JahiaException {
    }

    public void setUserManagerProvider(JCRUserManagerProvider userManagerProvider) {
        this.userManagerProvider = userManagerProvider;
    }

    public void updateMembershipCache(String identifier) {
        this.membershipCache.remove((Serializable)((Object)identifier));
    }

    @Override
    public void flushCache() {
        super.flushCache();
        this.cache.removeAll();
        this.membershipCache.removeAll();
    }

    public void onApplicationEvent(ProviderEvent event) {
        this.chainedClassLoader = null;
        this.chainedClassLoaderInitialized = false;
    }

    ClassLoader getChainedClassloader() {
        if (this.chainedClassLoader != null || this.chainedClassLoaderInitialized) {
            return this.chainedClassLoader;
        }
        List<JahiaUserManagerProvider> userProviders = JahiaUserManagerRoutingService.getInstance().getProviderList();
        List<? extends JahiaGroupManagerProvider> groupProviders = JahiaGroupManagerRoutingService.getInstance().getProviderList();
        if (userProviders.size() > 1 || groupProviders.size() > 1) {
            LinkedHashSet<ClassLoader> loaders = new LinkedHashSet<ClassLoader>();
            for (JahiaUserManagerProvider jahiaUserManagerProvider : userProviders) {
                loaders.add(jahiaUserManagerProvider.getClass().getClassLoader());
            }
            for (JahiaGroupManagerProvider jahiaGroupManagerProvider : groupProviders) {
                loaders.add(jahiaGroupManagerProvider.getClass().getClassLoader());
            }
            this.chainedClassLoader = ClassLoaderUtils.getChainedClassLoader(loaders.toArray(new ClassLoader[0]));
        }
        this.chainedClassLoaderInitialized = true;
        return this.chainedClassLoader;
    }

    private void cachePut(String key, JCRGroup group) {
        this.cache.put(new Element((Serializable)((Object)key), group != null && this.getChainedClassloader() != null ? new ProviderClassLoaderAwareCacheEntry(group) : group));
    }

    public void setCacheProvider(EhCacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }
}

