/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.usermanager.jcr;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.pwdpolicy.JahiaPasswordPolicyService;
import org.jahia.services.pwdpolicy.PasswordHistoryEntry;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.usermanager.UserProperties;
import org.jahia.services.usermanager.UserProperty;
import org.jahia.services.usermanager.jcr.JCRPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRUser
implements JahiaUser,
JCRPrincipal {
    private static final long serialVersionUID = 4032549320399420578L;
    private static transient Logger logger = LoggerFactory.getLogger(JCRUser.class);
    protected static final String ROOT_USER_UUID = "b32d306a-6c74-11de-b3ef-001e4fead50b";
    protected static final String PROVIDER_NAME = "jcr";
    public static final String J_DISPLAYABLE_NAME = "j:displayableName";
    static final String J_PASSWORD = "j:password";
    public static final String J_EXTERNAL = "j:external";
    public static final String J_EXTERNAL_SOURCE = "j:externalSource";
    private final String nodeUuid;
    private final AtomicReference<String> name = new AtomicReference();
    private final AtomicReference<Properties> properties = new AtomicReference();
    private final AtomicReference<UserProperties> userProperties = new AtomicReference();
    private boolean external;
    private final AtomicReference<List<PasswordHistoryEntry>> passwordHistory = new AtomicReference();
    private final AtomicReference<String> path = new AtomicReference<Object>(null);

    public JCRUser(String nodeUuid) {
        this(nodeUuid, false);
    }

    public JCRUser(String nodeUuid, boolean isExternal) {
        this.nodeUuid = nodeUuid;
        this.external = isExternal;
    }

    @Override
    public String getName() {
        if (this.name.get() == null) {
            try {
                JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
                String userName = this.getNode(session).getName();
                this.name.set(userName);
                return userName;
            }
            catch (RepositoryException e) {
                logger.error("Error while retrieving the user's name", (Throwable)e);
                return "";
            }
        }
        return this.name.get();
    }

    @Override
    public JCRNodeWrapper getNode(JCRSessionWrapper session) throws RepositoryException {
        return session.getNodeByIdentifier(this.getIdentifier());
    }

    @Override
    public String getUsername() {
        return this.getName();
    }

    @Override
    public String getUserKey() {
        return "{jcr}" + this.getName();
    }

    @Override
    public Properties getProperties() {
        if (this.properties.get() == null || this.properties.get().isEmpty()) {
            try {
                JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
                Properties properties = new Properties();
                JCRUserNode jcrUserNode = (JCRUserNode)this.getNode(session);
                PropertyIterator iterator = jcrUserNode.getProperties();
                while (iterator.hasNext()) {
                    Property property = iterator.nextProperty();
                    if (!property.getDefinition().isMultiple()) {
                        properties.put(property.getName(), property.getString());
                        continue;
                    }
                    if (property.getType() != 0) continue;
                    Value[] vals = null;
                    try {
                        vals = property.getValues();
                    }
                    catch (ValueFormatException e) {
                        try {
                            vals = new Value[]{property.getValue()};
                        }
                        catch (ValueFormatException e1) {
                            // empty catch block
                        }
                    }
                    if (vals == null || vals.length != 1) continue;
                    properties.put(property.getName(), vals[0].getString());
                }
                this.properties.set(properties);
                return properties;
            }
            catch (RepositoryException e) {
                logger.error("Error while retrieving properties", (Throwable)e);
            }
        }
        return this.properties.get();
    }

    @Override
    public UserProperties getUserProperties() {
        if (this.userProperties.get() == null) {
            UserProperties userProperties = new UserProperties();
            try {
                JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
                JCRUserNode jcrUserNode = (JCRUserNode)this.getNode(session);
                PropertyIterator iterator = jcrUserNode.getProperties();
                while (iterator.hasNext()) {
                    Property property = iterator.nextProperty();
                    if (property instanceof JCRUserNode.JCRUserProperty) {
                        userProperties.setUserProperty(property.getName(), new UserProperty(property.getName(), property.getString(), true));
                        continue;
                    }
                    if (property.getDefinition() == null || property.getDefinition().isMultiple()) continue;
                    userProperties.setUserProperty(property.getName(), new UserProperty(property.getName(), property.getString(), false));
                }
                if (jcrUserNode.getDisplayableName() != null) {
                    userProperties.setUserProperty(J_DISPLAYABLE_NAME, new UserProperty(J_DISPLAYABLE_NAME, jcrUserNode.getDisplayableName(), true));
                }
                this.userProperties.set(userProperties);
            }
            catch (RepositoryException e) {
                logger.error("Error while retrieving user properties", (Throwable)e);
            }
        }
        return this.userProperties.get();
    }

    @Override
    public String getProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    @Override
    public UserProperty getUserProperty(String key) {
        return this.getUserProperties().getUserProperty(key);
    }

    @Override
    public boolean removeProperty(final String key) {
        try {
            return JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRNodeWrapper node = JCRUser.this.getNode(session);
                    Property property = node.getProperty(key);
                    if (property != null) {
                        property.remove();
                        session.save();
                        JCRUser.this.properties.set(null);
                        JCRUser.this.userProperties.set(null);
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (RepositoryException e) {
            logger.warn("Error while removing property", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean setProperty(final String key, final String value) {
        try {
            if (J_EXTERNAL.equals(key)) {
                this.external = Boolean.valueOf(value);
            }
            return JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRNodeWrapper node = JCRUser.this.getNode(session);
                    node.setProperty(key, value);
                    session.save();
                    JCRUser.this.properties.set(null);
                    JCRUser.this.userProperties.set(null);
                    return Boolean.TRUE;
                }
            });
        }
        catch (RepositoryException e) {
            logger.warn("Error while setting user property " + key + " with value " + value + " for user " + this.name.get(), (Throwable)e);
            return false;
        }
    }

    public boolean isPasswordReadOnly() {
        return false;
    }

    @Override
    public boolean setPassword(String password) {
        return this.setProperty(J_PASSWORD, JahiaUserManagerService.encryptPassword(password));
    }

    @Override
    public boolean isMemberOfGroup(int siteID, String name) {
        JahiaGroupManagerService groupService;
        JahiaGroup group;
        if ("guest".equals(name)) {
            return true;
        }
        if ("users".equals(name)) {
            return !"guest".equals(this.getName());
        }
        if (this.isRoot() && JahiaGroupManagerService.POWERFUL_GROUPS.contains(name)) {
            return true;
        }
        ServicesRegistry servicesRegistry = ServicesRegistry.getInstance();
        if (servicesRegistry != null && (group = (groupService = servicesRegistry.getJahiaGroupManagerService()).lookupGroup(siteID, name)) != null) {
            return group.isMember(this);
        }
        return false;
    }

    @Override
    public boolean isAdminMember(int siteID) {
        return this.isRoot() || this.isMemberOfGroup(siteID, siteID == 0 ? "administrators" : "site-administrators");
    }

    @Override
    public boolean isRoot() {
        return this.nodeUuid.equals(ROOT_USER_UUID);
    }

    @Override
    public boolean verifyPassword(String password) {
        return this.getProperty(J_PASSWORD).equals(JahiaUserManagerService.encryptPassword(password));
    }

    @Override
    public String getProviderName() {
        return PROVIDER_NAME;
    }

    @Override
    public String getLocalPath() {
        if (this.path.get() == null) {
            this.path.set(ServicesRegistry.getInstance().getJahiaUserManagerService().getUserSplittingRule().getPathForUsername(this.getUsername()));
        }
        return this.path.get();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JCRUser jcrUser = (JCRUser)o;
        return this.getIdentifier().equals(jcrUser.getIdentifier());
    }

    @Override
    public int hashCode() {
        return this.nodeUuid.hashCode();
    }

    @Override
    public String toString() {
        return "JCRUser{nodeUuid='" + this.nodeUuid + '\'' + "name='" + this.getName() + '\'' + '}';
    }

    @Override
    public String getIdentifier() {
        return this.nodeUuid;
    }

    public boolean isExternal() {
        return this.external;
    }

    public List<PasswordHistoryEntry> getPasswordHistory() {
        if (this.passwordHistory.get() == null) {
            this.passwordHistory.set(JahiaPasswordPolicyService.getInstance().getPasswordHistory(this));
        }
        return this.passwordHistory.get();
    }

    public long getLastPasswordChangeTimestamp() {
        List<PasswordHistoryEntry> pwdHistory = this.getPasswordHistory();
        return pwdHistory.size() > 0 ? pwdHistory.get(0).getModificationDate().getTime() : 0L;
    }

    @Override
    public boolean isAccountLocked() {
        return !this.isRoot() && Boolean.valueOf(this.getProperty("j:accountLocked")) != false;
    }
}

