/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.usermanager.jcr;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.JahiaAfterInitializationService;
import org.jahia.services.cache.Cache;
import org.jahia.services.cache.CacheService;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerProvider;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.usermanager.jcr.JCRGroupManagerProvider;
import org.jahia.services.usermanager.jcr.JCRUser;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;

public class JCRUserManagerProvider
extends JahiaUserManagerProvider
implements ServletContextAware,
JahiaAfterInitializationService {
    private static final String ROOT_PWD_RESET_FILE = "root.pwd";
    private static final String ROOT_PWD_RESET_FILE_PATH = "/WEB-INF/etc/config/root.pwd";
    private static transient Logger logger = LoggerFactory.getLogger(JCRUserManagerProvider.class);
    private transient JCRTemplate jcrTemplate;
    private static JCRUserManagerProvider mUserManagerService;
    private transient CacheService cacheService;
    private transient Cache<String, JCRUser> cache;
    private static transient Map<String, String> mappingOfProperties;
    private ServletContext servletContext;

    public static JCRUserManagerProvider getInstance() {
        if (mUserManagerService == null) {
            mUserManagerService = new JCRUserManagerProvider();
        }
        return mUserManagerService;
    }

    public void setJcrTemplate(JCRTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    @Override
    public JCRUser createUser(final String name, final String password, final Properties properties) {
        try {
            return this.jcrTemplate.doExecuteWithSystemSession(new JCRCallback<JCRUser>(){

                @Override
                public JCRUser doInJCR(JCRSessionWrapper jcrSessionWrapper) throws RepositoryException {
                    JCRNodeWrapper startNode;
                    String[] jcrUsernamePath = Patterns.SLASH.split(StringUtils.substringAfter((String)ServicesRegistry.getInstance().getJahiaUserManagerService().getUserSplittingRule().getPathForUsername(name), (String)"/"));
                    JCRNodeWrapper usersFolderNode = startNode = jcrSessionWrapper.getNode("/" + jcrUsernamePath[0]);
                    int length = jcrUsernamePath.length;
                    for (int i = 1; i < length; ++i) {
                        try {
                            startNode = startNode.getNode(jcrUsernamePath[i]);
                            continue;
                        }
                        catch (PathNotFoundException e) {
                            try {
                                jcrSessionWrapper.checkout(startNode);
                                if (i == length - 1) {
                                    JCRNodeWrapper userNode = startNode.addNode(name, "jnt:user");
                                    if (usersFolderNode.hasProperty("j:usersFolderSkeleton")) {
                                        String skeletons = usersFolderNode.getProperty("j:usersFolderSkeleton").getString();
                                        try {
                                            JCRContentUtils.importSkeletons(skeletons, startNode.getPath() + "/" + jcrUsernamePath[i], jcrSessionWrapper);
                                        }
                                        catch (Exception importEx) {
                                            logger.error("Unable to import data using user skeletons " + skeletons, (Throwable)importEx);
                                            throw new RepositoryException("Could not create user due to some import issues", (Throwable)importEx);
                                        }
                                    }
                                    userNode.grantRoles("u:" + name, Collections.singleton("owner"));
                                    String l_password = !password.startsWith("SHA-1:") ? JahiaUserManagerService.encryptPassword(password) : password.substring(6);
                                    userNode.setProperty("j:password", l_password);
                                    userNode.setProperty("j:external", false);
                                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                                        String key = (String)entry.getKey();
                                        if (mappingOfProperties.containsKey(key)) {
                                            key = (String)mappingOfProperties.get(key);
                                        }
                                        userNode.setProperty(key, (String)entry.getValue());
                                    }
                                    jcrSessionWrapper.save();
                                    return new JCRUser(userNode.getIdentifier());
                                }
                                startNode = startNode.addNode(jcrUsernamePath[i], "jnt:usersFolder");
                                jcrSessionWrapper.save();
                                continue;
                            }
                            catch (RepositoryException e1) {
                                logger.error("Cannot save", (Throwable)e1);
                            }
                        }
                    }
                    return new JCRUser(startNode.getIdentifier());
                }
            });
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteUser(JahiaUser user) {
        if (user instanceof JCRUser) {
            final JCRUser jcrUser = (JCRUser)user;
            String name = jcrUser.getName();
            try {
                JCRCallback<Boolean> deleteCallcback = new JCRCallback<Boolean>(){

                    @Override
                    public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        JCRNodeWrapper node = null;
                        try {
                            node = jcrUser.getNode(session);
                        }
                        catch (ItemNotFoundException e) {
                            return true;
                        }
                        if (node.isNodeType("jmix:systemNode")) {
                            return false;
                        }
                        String query = "SELECT * FROM [jnt:ace] as ace where ace.[j:principal]='u:" + jcrUser.getName() + "'";
                        QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
                        QueryResult qr = q.execute();
                        NodeIterator nodeIterator = qr.getNodes();
                        while (nodeIterator.hasNext()) {
                            Node next = nodeIterator.nextNode();
                            session.checkout(next.getParent());
                            session.checkout(next);
                            next.remove();
                        }
                        PropertyIterator pi = node.getWeakReferences("j:member");
                        while (pi.hasNext()) {
                            JCRPropertyWrapper propertyWrapper = (JCRPropertyWrapper)pi.next();
                            propertyWrapper.getParent().remove();
                        }
                        JCRGroupManagerProvider.getInstance().flushCache();
                        session.checkout(node.getParent());
                        session.checkout(node);
                        node.remove();
                        session.save();
                        return true;
                    }
                };
                this.jcrTemplate.doExecuteWithSystemSession(deleteCallcback);
                this.jcrTemplate.doExecuteWithSystemSession(null, "live", deleteCallcback);
            }
            catch (RepositoryException e) {
                logger.error("Error while deleting user", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                this.updateCache(name);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getNbUsers() {
        return 0;
    }

    @Override
    public List<String> getUserList() {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            ArrayList<String> users = new ArrayList<String>();
            if (session.getWorkspace().getQueryManager() != null) {
                String query = "SELECT * FROM [jnt:user] AS username ORDER BY localname(username)";
                QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
                QueryResult qr = q.execute();
                RowIterator rows = qr.getRows();
                while (rows.hasNext()) {
                    String userName;
                    Row usersFolderNode = rows.nextRow();
                    if (usersFolderNode.getNode() == null || users.contains(userName = "{jcr}" + usersFolderNode.getNode().getName())) continue;
                    users.add(userName);
                }
            }
            return users;
        }
        catch (RepositoryException e) {
            logger.error("Error while retrieving user list", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<String> getUsernameList() {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            TreeSet<String> users = new TreeSet<String>();
            if (session.getWorkspace().getQueryManager() != null) {
                String query = "SELECT [j:nodename] FROM [jnt:user]";
                QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
                QueryResult qr = q.execute();
                RowIterator rows = qr.getRows();
                while (rows.hasNext()) {
                    Row usersFolderNode = rows.nextRow();
                    String userName = usersFolderNode.getValue("j:nodename").getString();
                    users.add(userName);
                }
            }
            return new ArrayList<String>(users);
        }
        catch (RepositoryException e) {
            logger.error("Error while retrieving user name list", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    @Override
    public boolean login(String userKey, String userPassword) {
        return this.lookupUser(userKey).verifyPassword(userPassword);
    }

    @Override
    public JCRUser lookupUserByKey(String userKey) {
        if (!userKey.startsWith("{")) {
            logger.warn("Expected userKey with provider prefix {jcr}, defaulting to looking up by name instead for parameter=[" + userKey + "]... ");
            return this.lookupUser(userKey);
        }
        return this.lookupUser(StringUtils.substringAfter((String)userKey, (String)"}"));
    }

    @Override
    public JCRUser lookupUser(String name) {
        if (StringUtils.isBlank((String)name)) {
            logger.error("Should not be looking for empty name user");
            return null;
        }
        try {
            JCRUser user = this.cache.get(name);
            if (user != null) {
                return user.isExternal() ? null : user;
            }
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            JCRNodeWrapper userNode = session.getNode(ServicesRegistry.getInstance().getJahiaUserManagerService().getUserSplittingRule().getPathForUsername(name));
            if (!userNode.getProperty("j:external").getBoolean()) {
                user = new JCRUser(userNode.getIdentifier());
                this.cache.put(name, user);
                return user;
            }
            return null;
        }
        catch (PathNotFoundException pnfe) {
        }
        catch (RepositoryException e) {
            logger.error("Error while looking up user by name " + name, (Throwable)e);
        }
        return null;
    }

    public JCRUser lookupExternalUser(JahiaUser jahiaUser) {
        try {
            JCRUser user = this.cache.get(jahiaUser.getName());
            if (user != null) {
                return user;
            }
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            JCRNodeWrapper userNode = session.getNode(jahiaUser.getLocalPath());
            if (userNode.getProperty("j:external").getBoolean()) {
                user = new JCRUser(userNode.getIdentifier(), true);
                this.cache.put(jahiaUser.getName(), user);
                return user;
            }
            return null;
        }
        catch (PathNotFoundException pnfe) {
        }
        catch (RepositoryException e) {
            logger.error("Error while looking up external user by name " + jahiaUser.getName(), (Throwable)e);
        }
        return null;
    }

    public JCRUser lookupExternalUser(String username) {
        try {
            JCRUser user = this.cache.get(username);
            if (user != null) {
                return user;
            }
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            JCRNodeWrapper userNode = session.getNode(ServicesRegistry.getInstance().getJahiaUserManagerService().getUserSplittingRule().getPathForUsername(username));
            if (userNode.getProperty("j:external").getBoolean()) {
                user = new JCRUser(userNode.getIdentifier(), true);
                this.cache.put(username, user);
                return user;
            }
            return null;
        }
        catch (PathNotFoundException pnfe) {
        }
        catch (RepositoryException e) {
            logger.error("Error while looking up external user by name " + username, (Throwable)e);
        }
        return null;
    }

    @Override
    public Set<JahiaUser> searchUsers(Properties searchCriterias) {
        return this.searchUsers(searchCriterias, false, null);
    }

    public Set<JahiaUser> searchUsers(Properties searchCriterias, Boolean external, String providerKey) {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            int limit = 0;
            HashSet<JahiaUser> users = new HashSet<JahiaUser>();
            if (session.getWorkspace().getQueryManager() != null) {
                StringBuilder query = new StringBuilder(128);
                if (external != null) {
                    query.append("u.[j:external] = '").append(external).append("'");
                }
                if (providerKey != null) {
                    query.append(query.length() > 0 ? " AND " : "").append(" u.[j:externalSource] = '").append(providerKey).append("'");
                }
                if (searchCriterias != null && searchCriterias.size() > 0) {
                    Iterator<Map.Entry<Object, Object>> objectIterator;
                    Properties filters = (Properties)searchCriterias.clone();
                    String operation = " OR ";
                    if (filters.containsKey("multi_criteria_search_op")) {
                        if (((String)filters.get("multi_criteria_search_op")).trim().toLowerCase().equals("and")) {
                            operation = " AND ";
                        }
                        filters.remove("multi_criteria_search_op");
                    }
                    if (filters.containsKey("countLimit")) {
                        limit = Integer.parseInt((String)filters.get("countLimit"));
                        logger.debug("Limit of results has be set to " + limit);
                        filters.remove("countLimit");
                    }
                    if (!(filters.containsKey("*") && filters.size() == 1 && filters.getProperty("*").equals("*") || !(objectIterator = filters.entrySet().iterator()).hasNext())) {
                        query.append(query.length() > 0 ? " AND " : "").append(" (");
                        while (objectIterator.hasNext()) {
                            String propertyValue;
                            Map.Entry<Object, Object> entry = objectIterator.next();
                            String propertyKey = (String)entry.getKey();
                            if ("username".equals(propertyKey)) {
                                propertyKey = "j:nodename";
                            }
                            propertyValue = "*".equals(propertyValue = (String)entry.getValue()) ? "%" : (propertyValue.contains("*") ? Patterns.STAR.matcher(propertyValue).replaceAll("%") : propertyValue + "%");
                            if ("*".equals(propertyKey)) {
                                query.append("(CONTAINS(u.*,'" + Patterns.PERCENT.matcher(propertyValue).replaceAll("") + "') OR LOWER(u.[j:nodename]) LIKE '").append(propertyValue.toLowerCase()).append("') ");
                            } else {
                                query.append("LOWER(u.[" + Patterns.DOT.matcher(propertyKey).replaceAll("\\\\.") + "])").append(" LIKE '").append(propertyValue.toLowerCase()).append("'");
                            }
                            if (!objectIterator.hasNext()) continue;
                            query.append(operation);
                        }
                        query.append(")");
                    }
                }
                if (query.length() > 0) {
                    query.insert(0, "WHERE ");
                }
                query.insert(0, "SELECT * FROM [jnt:user] as u ");
                query.append(" ORDER BY u.[j:nodename]");
                if (logger.isDebugEnabled()) {
                    logger.debug(query.toString());
                }
                QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query.toString(), "JCR-SQL2");
                if (limit > 0) {
                    q.setLimit(limit);
                }
                QueryResult qr = q.execute();
                NodeIterator ni = qr.getNodes();
                while (ni.hasNext()) {
                    Node usersFolderNode = ni.nextNode();
                    users.add(new JCRUser(usersFolderNode.getIdentifier()));
                }
            }
            return users;
        }
        catch (RepositoryException e) {
            logger.error("Error while searching for users", (Throwable)e);
            return new HashSet<JahiaUser>();
        }
    }

    @Override
    public void updateCache(JahiaUser jahiaUser) {
        this.updateCache(jahiaUser.getName());
    }

    public void updateCache(String name) {
        this.cache.remove(name);
    }

    @Override
    public boolean userExists(String name) {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            if (session.getWorkspace().getQueryManager() != null) {
                String query = "SELECT * FROM [jnt:user] as u WHERE u.[j:nodename] = '" + name + "' AND u.[" + "j:external" + "] = 'false'";
                QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
                QueryResult qr = q.execute();
                NodeIterator ni = qr.getNodes();
                return ni.hasNext();
            }
            return false;
        }
        catch (RepositoryException e) {
            logger.error("Error when testing user existence", (Throwable)e);
            return false;
        }
    }

    @Override
    public void start() throws JahiaInitializationException {
        if (this.cacheService != null) {
            this.cache = this.cacheService.getCache("JCRUserCache", true);
        }
    }

    private void checkRootUserPwd() {
        try {
            String pwd = this.getNewRootUserPwd();
            if (StringUtils.isNotEmpty((String)pwd)) {
                logger.info("Resetting root user password");
                this.lookupRootUser().setPassword(pwd);
                logger.info("New root user password set.");
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    private String getNewRootUserPwd() throws MalformedURLException, IOException {
        String path;
        String pwd = null;
        File pwdFile = null;
        pwdFile = this.servletContext.getResource(ROOT_PWD_RESET_FILE_PATH) != null ? ((path = this.servletContext.getRealPath(ROOT_PWD_RESET_FILE_PATH)) != null ? new File(path) : null) : new File(this.settingsBean.getJahiaVarDiskPath(), ROOT_PWD_RESET_FILE);
        if (pwdFile != null && pwdFile.exists()) {
            pwd = FileUtils.readFileToString((File)pwdFile);
            try {
                pwdFile.delete();
            }
            catch (Exception e) {
                logger.warn("Unable to delete " + pwdFile + " file after resetting root password", (Throwable)e);
            }
        }
        return pwd != null ? StringUtils.chomp(pwd).trim() : null;
    }

    @Override
    public void stop() throws JahiaException {
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public JCRUser lookupRootUser() {
        return new JCRUser("b32d306a-6c74-11de-b3ef-001e4fead50b");
    }

    @Override
    public void initAfterAllServicesAreStarted() throws JahiaInitializationException {
        this.checkRootUserPwd();
    }

    static {
        mappingOfProperties = new HashMap<String, String>(3);
        mappingOfProperties.put("lastname", "j:lastName");
        mappingOfProperties.put("firstname", "j:firstName");
        mappingOfProperties.put("organization", "j:organization");
        mappingOfProperties.put("email", "j:email");
    }
}

