/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.visibility;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.jahia.services.Conditional;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.visibility.VisibilityConditionRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisibilityService {
    public static final String NODE_NAME = "j:conditionalVisibility";
    private static transient Logger logger = LoggerFactory.getLogger(VisibilityService.class);
    private static volatile VisibilityService instance;
    private Map<String, VisibilityConditionRule> conditions = new HashMap<String, VisibilityConditionRule>(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VisibilityService getInstance() {
        if (instance != null) return instance;
        Class<VisibilityService> clazz = VisibilityService.class;
        synchronized (VisibilityService.class) {
            if (instance != null) return instance;
            instance = new VisibilityService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Map<String, VisibilityConditionRule> getConditions() {
        return this.conditions;
    }

    public void setConditions(Map<String, VisibilityConditionRule> conditions) {
        if (conditions != null) {
            for (Map.Entry<String, VisibilityConditionRule> cond : conditions.entrySet()) {
                this.addCondition(cond.getKey(), cond.getValue());
            }
        }
    }

    public void addCondition(String conditionType, VisibilityConditionRule instance) {
        if (instance instanceof Conditional && !((Conditional)((Object)instance)).evaluate()) {
            logger.info("Visibility condition of type {} is considered disabled. Skipping it.", (Object)conditionType);
            return;
        }
        this.conditions.put(conditionType, instance);
    }

    public void removeCondition(String conditionType) {
        if (instance instanceof Conditional && !((Conditional)((Object)instance)).evaluate()) {
            logger.info("Visibility condition of type {} is considered disabled. Skipping it.", (Object)conditionType);
            return;
        }
        this.conditions.remove(conditionType);
    }

    public boolean matchesConditions(JCRNodeWrapper node) {
        if (this.conditions.isEmpty()) {
            return true;
        }
        try {
            if (node.hasNode(NODE_NAME)) {
                node = node.getNode(NODE_NAME);
                boolean forceMatchAllConditions = node.getProperty("j:forceMatchAllConditions").getBoolean();
                List<JCRNodeWrapper> childrenOfType = JCRContentUtils.getChildrenOfType(node, "jnt:condition");
                if (childrenOfType.isEmpty()) {
                    return true;
                }
                if (forceMatchAllConditions) {
                    boolean matches = true;
                    for (JCRNodeWrapper nodeWrapper : childrenOfType) {
                        if (!matches) break;
                        VisibilityConditionRule rule = this.conditions.get(nodeWrapper.getPrimaryNodeTypeName());
                        if (rule == null) continue;
                        matches = rule.matches(nodeWrapper);
                    }
                    return matches;
                }
                for (JCRNodeWrapper nodeWrapper : childrenOfType) {
                    VisibilityConditionRule rule = this.conditions.get(nodeWrapper.getPrimaryNodeTypeName());
                    if (rule == null || !rule.matches(nodeWrapper)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Map<JCRNodeWrapper, Boolean> getConditionMatchesDetails(JCRNodeWrapper node) {
        HashMap<JCRNodeWrapper, Boolean> conditions = new HashMap<JCRNodeWrapper, Boolean>();
        try {
            if (node.hasNode(NODE_NAME)) {
                node = node.getNode(NODE_NAME);
                List<JCRNodeWrapper> childrenOfType = JCRContentUtils.getChildrenOfType(node, "jnt:condition");
                for (JCRNodeWrapper nodeWrapper : childrenOfType) {
                    VisibilityConditionRule rule = this.conditions.get(nodeWrapper.getPrimaryNodeTypeName());
                    if (rule == null) continue;
                    conditions.put(nodeWrapper, rule.matches(nodeWrapper));
                }
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return conditions;
    }
}

