/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm;

import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.workflow.WorkflowObservationManager;
import org.jahia.services.workflow.jbpm.JBPM6WorkflowProvider;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBPMListener
extends DefaultProcessEventListener {
    private static final long serialVersionUID = 665473577321892992L;
    private static final Logger logger = LoggerFactory.getLogger(JBPMListener.class);
    private JBPM6WorkflowProvider provider;
    private WorkflowObservationManager observationManager;

    public JBPMListener(JBPM6WorkflowProvider provider) {
        this.provider = provider;
    }

    public void setObservationManager(WorkflowObservationManager observationManager) {
        this.observationManager = observationManager;
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
        super.afterProcessStarted(event);
        WorkflowProcessInstance workflowProcessInstance = (WorkflowProcessInstance)event.getProcessInstance();
        final List ids = (List)workflowProcessInstance.getVariable("nodeIds");
        String workspace = (String)workflowProcessInstance.getVariable("workspace");
        final long executionId = workflowProcessInstance.getId();
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(null, workspace, null, new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    if (ids != null) {
                        for (String id : ids) {
                            JCRNodeWrapper node = null;
                            ItemNotFoundException previousException = null;
                            try {
                                node = session.getNodeByUUID(id);
                            }
                            catch (ItemNotFoundException e) {
                                previousException = e;
                            }
                            if (previousException != null) {
                                throw previousException;
                            }
                            JBPMListener.this.provider.getWorkflowService().addProcessId(node, JBPMListener.this.provider.getKey(), Long.toString(executionId));
                        }
                    }
                    return true;
                }
            });
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        if (this.observationManager != null) {
            this.observationManager.notifyWorkflowStarted(this.provider.getKey(), Long.toString(executionId));
        }
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        WorkflowProcessInstance workflowProcessInstance = (WorkflowProcessInstance)event.getProcessInstance();
        final List ids = (List)workflowProcessInstance.getVariable("nodeIds");
        String workspace = (String)workflowProcessInstance.getVariable("workspace");
        final long executionId = workflowProcessInstance.getId();
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(null, workspace, null, new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    if (ids != null) {
                        for (String id : ids) {
                            JCRNodeWrapper node = null;
                            ItemNotFoundException previousException = null;
                            try {
                                node = session.getNodeByUUID(id);
                            }
                            catch (ItemNotFoundException e) {
                                previousException = e;
                            }
                            if (node != null) {
                                JBPMListener.this.provider.getWorkflowService().removeProcessId(node, JBPMListener.this.provider.getKey(), Long.toString(executionId));
                                continue;
                            }
                            logger.warn("A workflow process may have been partially ended because this node cannot be found: {}", (Object)previousException.getMessage());
                        }
                    }
                    return true;
                }
            });
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        if (this.observationManager != null) {
            this.observationManager.notifyWorkflowEnded(this.provider.getKey(), Long.toString(executionId));
        }
        super.afterProcessCompleted(event);
    }
}

