/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaPrincipal;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.jcr.JCRUser;
import org.jahia.services.usermanager.jcr.JCRUserManagerProvider;
import org.jahia.services.workflow.Workflow;
import org.jahia.services.workflow.WorkflowService;
import org.jahia.services.workflow.WorkflowTask;
import org.jahia.services.workflow.WorkflowVariable;
import org.jahia.services.workflow.jbpm.JBPM6WorkflowProvider;
import org.jahia.services.workflow.jbpm.NotifyNewTaskJob;
import org.jahia.services.workflow.jbpm.custom.AbstractTaskLifeCycleEventListener;
import org.jahia.utils.Patterns;
import org.jbpm.runtime.manager.impl.task.SynchronizedTaskService;
import org.jbpm.services.task.events.AfterTaskAddedEvent;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;

public class JBPMTaskLifeCycleEventListener
extends AbstractTaskLifeCycleEventListener {
    public void afterTaskReleasedEvent(Task ti) {
    }

    public void afterTaskResumedEvent(Task ti) {
    }

    public void afterTaskSuspendedEvent(Task ti) {
    }

    public void afterTaskForwardedEvent(Task ti) {
    }

    public void afterTaskDelegatedEvent(Task ti) {
    }

    public void afterTaskActivatedEvent(Task ti) {
    }

    public void afterTaskClaimedEvent(Task ti) {
    }

    public void afterTaskSkippedEvent(Task ti) {
    }

    public void afterTaskStartedEvent(Task ti) {
    }

    public void afterTaskStoppedEvent(Task ti) {
    }

    public void afterTaskCompletedEvent(Task ti) {
    }

    public void afterTaskFailedEvent(Task ti) {
    }

    public void afterTaskAddedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskAddedEvent Task task) {
        Map<String, Object> taskInputParameters = this.getTaskInputParameters(task);
        Map<String, Object> taskOutputParameters = this.getTaskOutputParameters(task, taskInputParameters);
        try {
            ArrayList<JahiaPrincipal> principals = new ArrayList<JahiaPrincipal>();
            for (OrganizationalEntity entity : task.getPeopleAssignments().getPotentialOwners()) {
                if (entity instanceof UserImpl) {
                    principals.add(ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUserByKey(entity.getId()));
                    continue;
                }
                if (!(entity instanceof GroupImpl)) continue;
                principals.add(ServicesRegistry.getInstance().getJahiaGroupManagerService().lookupGroup(entity.getId()));
            }
            this.createTask(task, taskInputParameters, taskOutputParameters, principals);
            ((SynchronizedTaskService)this.taskService).addContent(task.getId().longValue(), taskOutputParameters);
            JobDetail jobDetail = BackgroundJob.createJahiaJob("notifyNewTask", NotifyNewTaskJob.class);
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            jobDataMap.put("taskId", Long.toString(task.getId()));
            try {
                ServicesRegistry.getInstance().getSchedulerService().scheduleJobAtEndOfRequest(jobDetail, true);
            }
            catch (SchedulerException e) {
                throw new RuntimeException("error while notifying the task_id " + task.getId(), e);
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Error while setting up task assignees and creating a JCR task", e);
        }
    }

    public void afterTaskExitedEvent(Task ti) {
    }

    protected void createTask(final Task task, final Map<String, Object> taskInputParameters, final Map<String, Object> taskOutputParameters, final List<JahiaPrincipal> candidates) throws RepositoryException {
        JahiaUser user;
        final Workflow workflow = this.workflowProvider.getWorkflow(Long.toString(task.getTaskData().getProcessInstanceId()), null);
        String username = (String)taskInputParameters.get("user");
        if (username == null) {
            username = workflow.getStartUser();
        }
        if ((user = ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUserByKey(username)) != null) {
            String workspace = (String)taskInputParameters.get("workspace");
            if (workspace == null) {
                workspace = (String)workflow.getVariables().get("workspace");
            }
            JCRTemplate.getInstance().doExecuteWithSystemSession(user.getUsername(), workspace, null, new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    String form;
                    JCRUser jcrUser = user instanceof JCRUser ? (JCRUser)user : ((JCRUserManagerProvider)SpringContextSingleton.getBean("JCRUserManagerProvider")).lookupExternalUser(user);
                    JCRNodeWrapper n = jcrUser.getNode(session);
                    JCRNodeWrapper tasks = !n.hasNode("workflowTasks") ? n.addNode("workflowTasks", "jnt:tasks") : n.getNode("workflowTasks");
                    String taskName = ((I18NText)task.getNames().get(0)).getText();
                    JCRNodeWrapper jcrTask = tasks.addNode(JCRContentUtils.findAvailableNodeName(tasks, taskName), "jnt:workflowTask");
                    String definitionKey = JBPM6WorkflowProvider.getDecodedProcessKey(task.getTaskData().getProcessId());
                    jcrTask.setProperty("taskName", taskName);
                    String bundle = workflow.getWorkflowDefinition().getPackageName() + "." + Patterns.SPACE.matcher(definitionKey).replaceAll("");
                    jcrTask.setProperty("taskBundle", bundle);
                    jcrTask.setProperty("taskId", task.getId());
                    jcrTask.setProperty("provider", "jBPM");
                    String uuid = (String)taskInputParameters.get("nodeId");
                    if (uuid == null) {
                        uuid = (String)workflow.getVariables().get("nodeId");
                    }
                    if (uuid != null) {
                        jcrTask.setProperty("targetNode", uuid);
                    }
                    if (task.getTaskData().getExpirationTime() != null) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(task.getTaskData().getExpirationTime());
                        jcrTask.setProperty("dueDate", calendar);
                    }
                    ArrayList<Value> candidatesArray = new ArrayList<Value>();
                    ValueFactory valueFactory = session.getValueFactory();
                    for (JahiaPrincipal principal : candidates) {
                        if (principal instanceof JahiaGroup) {
                            candidatesArray.add(valueFactory.createValue("g:" + ((JahiaGroup)principal).getGroupKey()));
                            continue;
                        }
                        if (!(principal instanceof JahiaUser)) continue;
                        candidatesArray.add(valueFactory.createValue("u:" + principal.getName()));
                    }
                    jcrTask.setProperty("candidates", candidatesArray.toArray(new Value[candidatesArray.size()]));
                    WorkflowTask wfTask = JBPMTaskLifeCycleEventListener.this.workflowProvider.getWorkflowTask(Long.toString(task.getId()), null);
                    Set<String> outcomes = wfTask.getOutcomes();
                    ArrayList<Value> outcomesArray = new ArrayList<Value>();
                    for (String outcome : outcomes) {
                        outcomesArray.add(valueFactory.createValue(outcome));
                    }
                    jcrTask.setProperty("possibleOutcomes", outcomesArray.toArray(new Value[outcomes.size()]));
                    jcrTask.setProperty("state", "active");
                    jcrTask.setProperty("type", "workflow");
                    jcrTask.setProperty("jcr:title", "##resourceBundle(" + Patterns.SPACE.matcher(taskName).replaceAll(".").trim().toLowerCase() + "," + bundle + ")## : " + session.getNodeByIdentifier(uuid).getDisplayableName());
                    if (taskInputParameters.containsKey("jcr:title") && taskInputParameters.get("jcr:title") instanceof WorkflowVariable) {
                        jcrTask.setProperty("description", ((WorkflowVariable)taskInputParameters.get("jcr:title")).getValue());
                    }
                    if ((form = WorkflowService.getInstance().getFormForAction(definitionKey, taskName)) != null && NodeTypeRegistry.getInstance().hasNodeType(form)) {
                        JCRNodeWrapper data = jcrTask.addNode("taskData", form);
                        ExtendedNodeType type = NodeTypeRegistry.getInstance().getNodeType(form);
                        Map<String, ExtendedPropertyDefinition> m = type.getPropertyDefinitionsAsMap();
                        for (String s : m.keySet()) {
                            Object variable = taskInputParameters.get(s);
                            if (variable instanceof WorkflowVariable) {
                                WorkflowVariable workflowVariable = (WorkflowVariable)variable;
                                data.setProperty(s, workflowVariable.getValue(), workflowVariable.getType());
                                continue;
                            }
                            if (!(variable instanceof List)) continue;
                            List list = (List)variable;
                            ArrayList<Value> v = new ArrayList<Value>();
                            for (Object o : list) {
                                if (!(o instanceof WorkflowVariable)) continue;
                                WorkflowVariable workflowVariable = (WorkflowVariable)o;
                                v.add(session.getValueFactory().createValue(workflowVariable.getValue(), workflowVariable.getType()));
                            }
                            data.setProperty(s, v.toArray(new Value[v.size()]));
                        }
                    }
                    session.save();
                    taskOutputParameters.put("task-" + task.getId(), jcrTask.getIdentifier());
                    return null;
                }
            });
        }
    }
}

