/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm.custom;

import java.util.List;
import javax.jcr.RepositoryException;
import org.jahia.ajax.gwt.helper.VersioningHelper;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRVersionService;
import org.jahia.services.workflow.jbpm.custom.AbstractWorkItemHandler;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;

public class AddLabelWorkItemHandler
extends AbstractWorkItemHandler
implements WorkItemHandler {
    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        final List nodeIds = (List)workItem.getParameter("nodeIds");
        String workspace = (String)workItem.getParameter("workspace");
        final String label = (String)workItem.getParameter("label");
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(null, workspace, new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    for (String id : nodeIds) {
                        JCRNodeWrapper node = session.getNodeByIdentifier(id);
                        JCRVersionService.getInstance().addVersionLabel(node, label + "_at_" + VersioningHelper.formatForLabel(System.currentTimeMillis()));
                    }
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        manager.completeWorkItem(workItem.getId(), null);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        manager.abortWorkItem(workItem.getId());
    }
}

