/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.tools.precompile;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jahia.osgi.BundleUtils;
import org.jahia.osgi.FrameworkService;
import org.jahia.utils.StringResponseWrapper;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JspPrecompileServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(JspPrecompileServlet.class);
    private static final long serialVersionUID = 7291760429380775493L;
    private static final String JSP_NAME_PARAM = "jsp_name";
    private static final String COMPILE_TYPE_PARAM = "compile_type";
    private static final String MAGIC_TOMCAT_PARAM = "jsp_precompile=true";

    public void doGet(HttpServletRequest aRequest, HttpServletResponse aResponse) throws ServletException, IOException {
        this.doWork(aRequest, aResponse);
    }

    public void doPost(HttpServletRequest aRequest, HttpServletResponse aResponse) throws ServletException, IOException {
        this.doWork(aRequest, aResponse);
    }

    private void doWork(HttpServletRequest aRequest, HttpServletResponse aResponse) throws ServletException, IOException {
        aRequest.getSession(true);
        String jspName = aRequest.getParameter(JSP_NAME_PARAM);
        String compileType = aRequest.getParameter(COMPILE_TYPE_PARAM);
        if (jspName != null) {
            this.precompileJsps(Arrays.asList(jspName), aRequest, aResponse);
        } else if ("all".equals(compileType)) {
            this.precompileJsps(this.searchForAllJsps(), aRequest, aResponse);
        } else if ("modules".equals(compileType)) {
            this.precompileJsps(this.searchForBundleJsps(), aRequest, aResponse);
        } else if ("module".equals(compileType)) {
            this.precompileJsps(this.searchForBundleJsps(FrameworkService.getBundleContext().getBundle(Long.parseLong(aRequest.getParameter("id")))), aRequest, aResponse);
        } else if ("non-modules".equals(compileType)) {
            this.precompileJsps(this.searchForJsps(""), aRequest, aResponse);
        } else {
            PrintWriter out = aResponse.getWriter();
            List<String> foundJsps = this.searchForAllJsps();
            aResponse.setContentType("text/html;charset=ISO-8859-1");
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
            out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
            out.println("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
            out.println("<head>");
            out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
            out.println("<meta http-equiv=\"expires\" content=\"0\" />");
            out.print("<link rel=\"stylesheet\" href=\"");
            out.print(aResponse.encodeURL(aRequest.getContextPath() + "/tools/tools.css"));
            out.println("\" type=\"text/css\" />");
            out.println("<title>JSP compilation</title>");
            out.println("</head>");
            out.println("<body>");
            out.println("<h1>JSP compilation</h1>");
            out.print("<p>Found <strong>");
            out.print(foundJsps.size());
            out.println("</strong> JSPs</p>");
            out.println("<h2>Pre-compile:</h2>");
            out.println("<ul>");
            out.print("<li><a target=\"_blank\" href=\"");
            long now = System.currentTimeMillis();
            String url = aResponse.encodeURL(aRequest.getContextPath() + aRequest.getServletPath() + "?" + COMPILE_TYPE_PARAM + "=all&timestamp=" + now + "&" + MAGIC_TOMCAT_PARAM);
            out.print(url);
            out.println("\">all</a></li>");
            out.print("<li><a target=\"_blank\" href=\"");
            url = aResponse.encodeURL(aRequest.getContextPath() + aRequest.getServletPath() + "?" + COMPILE_TYPE_PARAM + "=non-modules&timestamp=" + now + "&" + MAGIC_TOMCAT_PARAM);
            out.print(url);
            out.println("\">non-modules</a></li>");
            out.print("<li><a target=\"_blank\" href=\"");
            url = aResponse.encodeURL(aRequest.getContextPath() + aRequest.getServletPath() + "?" + COMPILE_TYPE_PARAM + "=modules&timestamp=" + now + "&" + MAGIC_TOMCAT_PARAM);
            out.print(url);
            out.print("\">all modules</a></li>");
            out.println("</ul>");
            out.println("<h2>Modules:</h2>");
            out.println("<ul>");
            TreeMap<String, Long> moduleBundles = new TreeMap<String, Long>();
            for (Bundle bundle : FrameworkService.getBundleContext().getBundles()) {
                Enumeration en;
                if (!BundleUtils.isJahiaModuleBundle(bundle) || bundle.getState() != 32 || (en = bundle.findEntries("/", "*.jsp", true)) == null || !en.hasMoreElements()) continue;
                moduleBundles.put(bundle.getSymbolicName(), bundle.getBundleId());
            }
            for (Map.Entry entry : moduleBundles.entrySet()) {
                out.print("<li><a target=\"_blank\" href=\"");
                url = aResponse.encodeURL(aRequest.getContextPath() + aRequest.getServletPath() + "?" + COMPILE_TYPE_PARAM + "=module&id=" + entry.getValue() + "&timestamp=" + now + "&" + MAGIC_TOMCAT_PARAM);
                out.print(url);
                out.print("\">" + (String)entry.getKey() + "</a></li>");
            }
            out.println("</ul><br/>");
            out.println("<h2>All JSPs:</h2>");
            this.listFiles(out, aRequest.getContextPath(), aRequest.getServletPath(), foundJsps, aResponse, now);
            out.println("</body>");
            out.println("</html>");
        }
    }

    private List<String> searchForAllJsps() {
        List<String> list = this.searchForJsps("");
        list.addAll(this.searchForBundleJsps());
        return list;
    }

    private List<String> searchForJsps(String attachPath) {
        String webModulePath = this.getServletContext().getRealPath("/");
        File jspsDir = new File(webModulePath + attachPath);
        ArrayList<String> foundJsps = new ArrayList<String>();
        this.searchForJsps(webModulePath, jspsDir, foundJsps);
        return foundJsps;
    }

    private List<String> searchForBundleJsps() {
        ArrayList<String> foundJsps = new ArrayList<String>();
        for (Bundle bundle : FrameworkService.getBundleContext().getBundles()) {
            if (!BundleUtils.isJahiaModuleBundle(bundle) || bundle.getState() != 32) continue;
            foundJsps.addAll(this.searchForBundleJsps(bundle));
        }
        return foundJsps;
    }

    private List<String> searchForBundleJsps(Bundle bundle) {
        ArrayList<String> foundJsps = new ArrayList<String>();
        Enumeration en = bundle.findEntries("/", "*.jsp", true);
        if (en != null) {
            while (en.hasMoreElements()) {
                URL url = (URL)en.nextElement();
                foundJsps.add("modules/" + bundle.getSymbolicName() + url.getPath());
            }
        }
        return foundJsps;
    }

    private void searchForJsps(String aWebModulePath, File aDir, List<String> aFoundJsps) {
        File[] files = aDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.searchForJsps(aWebModulePath, files[i], aFoundJsps);
                continue;
            }
            int extIdx = files[i].getName().lastIndexOf(46);
            if (extIdx == -1 || files[i].getName().length() != extIdx + 4 || !files[i].getName().regionMatches(true, extIdx + 1, "jsp", 0, 3)) continue;
            String jspPath = files[i].getPath();
            jspPath = jspPath.substring(aWebModulePath.length());
            jspPath = jspPath.replace('\\', '/');
            aFoundJsps.add(jspPath);
        }
    }

    private void precompileJsps(List<String> foundJsps, HttpServletRequest aRequest, HttpServletResponse aResponse) throws ServletException, IOException {
        System.out.println("Precompile started...");
        ArrayList<String> buggyJsps = new ArrayList<String>();
        int i = 1;
        for (String jspPath : foundJsps) {
            try {
                StringResponseWrapper responseWrapper = new StringResponseWrapper(aResponse);
                this.compile(jspPath, aRequest, (HttpServletResponse)responseWrapper, i);
                System.out.println(" OK.");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                System.out.println(" ERROR.");
                e.printStackTrace();
                buggyJsps.add(jspPath);
            }
            aResponse.resetBuffer();
            ++i;
        }
        System.out.println("Precompile ended!");
        PrintWriter out = aResponse.getWriter();
        aResponse.setContentType("text/html;charset=ISO-8859-1");
        out.print("<html><head><META http-equiv=\"expires\" content=\"0\"><title>JSP precompile result</title></head>\r\n<body>\r\n<b>");
        out.print(foundJsps.size());
        out.print(" JSPs processed.</b><br/>\r\n");
        if (buggyJsps.size() == 0) {
            out.print("No problems found!\r\n");
        } else {
            out.print("Precompile failed for following <strong>" + buggyJsps.size() + "</strong> JSPs:<br/>\r\n");
            this.listFiles(out, aRequest.getContextPath(), aRequest.getServletPath(), buggyJsps, aResponse, System.currentTimeMillis());
        }
        out.println("</body></html>");
    }

    private void compile(String jspPath, HttpServletRequest aRequest, HttpServletResponse aResponse, int i) throws Exception {
        RequestDispatcher rd = aRequest.getRequestDispatcher("/" + jspPath);
        System.out.print("Compiling (" + i + ") " + jspPath + "...");
        rd.include((ServletRequest)aRequest, (ServletResponse)aResponse);
    }

    private void listFiles(PrintWriter anOut, String aContextPath, String aServletPath, List<String> aFoundJsps, HttpServletResponse aResponse, long now) {
        for (String jspPath : aFoundJsps) {
            anOut.print("<a target=\"_blank\" href=\"");
            String url = null;
            url = aContextPath + aServletPath + "?" + JSP_NAME_PARAM + "=" + jspPath + "&" + MAGIC_TOMCAT_PARAM;
            url = url + "&now=" + now;
            anOut.print(aResponse.encodeURL(url));
            anOut.print("\">");
            anOut.print(jspPath);
            anOut.println("</a><br/>");
        }
    }
}

