/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class ClassLoaderUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeWith(ClassLoader cl, Callback<T> callback) {
        Thread current = Thread.currentThread();
        ClassLoader contextCL = current.getContextClassLoader();
        try {
            current.setContextClassLoader(cl);
            T t = callback.execute();
            return t;
        }
        finally {
            current.setContextClassLoader(contextCL);
        }
    }

    public static ClassLoader getChainedClassLoader(ClassLoader ... loaders) {
        return new ChainedClassLoader(loaders);
    }

    private ClassLoaderUtils() {
    }

    private static class ChainedClassLoader
    extends ClassLoader {
        private ClassLoader[] loaders;

        ChainedClassLoader(ClassLoader[] loaders) {
            super(null);
            this.loaders = loaders;
        }

        @Override
        public URL getResource(final String name) {
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(new PrivilegedAction<URL>(){

                    @Override
                    public URL run() {
                        return ChainedClassLoader.this.myGetResource(name);
                    }
                });
            }
            return this.myGetResource(name);
        }

        @Override
        public Class<?> loadClass(final String className) throws ClassNotFoundException {
            if (System.getSecurityManager() != null) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                        @Override
                        public Class<?> run() throws Exception {
                            return ChainedClassLoader.this.myLoadClass(className);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw (ClassNotFoundException)pae.getException();
                }
            }
            return this.myLoadClass(className);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private URL myGetResource(String resource) {
            URL url = null;
            ClassLoader[] classLoaderArray = this.loaders;
            synchronized (this.loaders) {
                for (ClassLoader cl : this.loaders) {
                    url = cl.getResource(resource);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return url;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Class<?> myLoadClass(String name) throws ClassNotFoundException {
            ClassLoader[] classLoaderArray = this.loaders;
            synchronized (this.loaders) {
                for (ClassLoader cl : this.loaders) {
                    try {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return cl.loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                throw new ClassNotFoundException(name);
            }
        }
    }

    public static interface Callback<T> {
        public T execute();
    }
}

