/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.codec.binary.Base64;
import org.jasypt.digest.ByteDigester;
import org.jasypt.digest.PooledByteDigester;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public final class EncryptionUtils {
    private static final Logger logger = LoggerFactory.getLogger(EncryptionUtils.class);

    private static ByteDigester getSHA1DigesterLegacy() {
        return SHA1DigesterHolder.INSTANCE;
    }

    private static StringEncryptor getStringEncryptor() {
        return StringEncryptorHolder.INSTANCE;
    }

    public static String passwordBaseDecrypt(String encrypted) {
        return EncryptionUtils.getStringEncryptor().decrypt(encrypted);
    }

    public static String passwordBaseEncrypt(String source) {
        return EncryptionUtils.getStringEncryptor().encrypt(source);
    }

    public static String sha1DigestLegacy(String source) {
        return new String(Base64.encodeBase64((byte[])EncryptionUtils.getSHA1DigesterLegacy().digest(source.getBytes())));
    }

    private EncryptionUtils() {
    }

    public static void main(String[] args) {
        System.out.println("\nJahia 7.0 Password Encryption Tool");
        System.out.println("Copyright 2002-2014 - Jahia Solutions Group SA http://www.jahia.com - All Rights Reserved\n");
        String password = null;
        if (args.length > 0) {
            password = args[0];
        } else {
            while (password == null || password.length() == 0) {
                System.out.print("Provide a password you would like to encrypt (SHA-1 + Base64): ");
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                try {
                    password = br.readLine();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (password != null && password.length() > 0) {
            System.out.println("Encrypted password for \"" + password + "\" is: " + EncryptionUtils.sha1DigestLegacy(password));
        }
    }

    private static class StringEncryptorHolder {
        static final StandardPBEStringEncryptor INSTANCE = new StandardPBEStringEncryptor();

        private StringEncryptorHolder() {
        }

        static {
            INSTANCE.setPassword(new String(new byte[]{74, 97, 104, 105, 97, 32, 120, 67, 77, 32, 54, 46, 53}));
        }
    }

    private static class SHA1DigesterHolder {
        static final PooledByteDigester INSTANCE = new PooledByteDigester();

        private SHA1DigesterHolder() {
        }

        static {
            INSTANCE.setAlgorithm("SHA-1");
            INSTANCE.setSaltSizeBytes(0);
            INSTANCE.setIterations(1);
            INSTANCE.setPoolSize(4);
        }
    }

    public static class EncryptedPasswordFactoryBean
    extends AbstractFactoryBean<String> {
        private String password;

        protected String createInstance() throws Exception {
            if (this.password == null) {
                return null;
            }
            return EncryptionUtils.passwordBaseDecrypt(this.password);
        }

        public Class<?> getObjectType() {
            return String.class;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

