/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.jahia.utils.Patterns;

public class LanguageCodeConverters {
    public static final Pattern LANGUAGE_PATTERN = Pattern.compile("[a-z]{2}(_[A-Z]{2})?");
    static final String JAVA7_LOCALE_LANGUAGE = "([a-zA-Z]{2,8})";
    static final String JAVA7_LOCALE_COUNTRY = "([a-zA-Z]{2}|[0-9]{3})";
    static final String JAVA7_LOCALE_VARIANT = "(?:_|-)([0-9a-zA-Z\\_\\-\\#]*)";
    public static final String JAVA7_LOCALE_TOSTRING = "([a-zA-Z]{2,8})?_?([a-zA-Z]{2}|[0-9]{3})?(?:(?:_|-)([0-9a-zA-Z\\_\\-\\#]*))?";
    static final Pattern JAVA7_LOCALE_TOSTRING_PATTERN = Pattern.compile("([a-zA-Z]{2,8})?_?([a-zA-Z]{2}|[0-9]{3})?(?:(?:_|-)([0-9a-zA-Z\\_\\-\\#]*))?");
    private static volatile List<Locale> availableBundleLocales;
    private static Map<String, Locale> locales;

    public static boolean isValidLanguageCode(String languageCode) {
        Matcher java7LocaleToStringMatcher = JAVA7_LOCALE_TOSTRING_PATTERN.matcher(languageCode);
        return java7LocaleToStringMatcher.matches();
    }

    public static Locale languageCodeToLocale(String languageCode) {
        if (languageCode == null) {
            return null;
        }
        Locale loc = locales.get(languageCode);
        if (loc != null) {
            return loc;
        }
        String[] codeParts = Patterns.UNDERSCORE.split(languageCode);
        String language = "";
        String country = "";
        StringBuilder variant = new StringBuilder();
        if (codeParts.length > 0 && codeParts[0].length() > 0) {
            language = codeParts[0];
        }
        if (codeParts.length > 1 && codeParts[1].length() > 0) {
            country = codeParts[1];
        }
        if (codeParts.length > 2 && codeParts[2].length() > 0) {
            variant.append(codeParts[2]);
        }
        if (codeParts.length > 3) {
            for (int i = 3; i < codeParts.length; ++i) {
                variant.append("_").append(codeParts[i]);
            }
        }
        loc = LanguageCodeConverters.newLocale(language, country, variant.toString());
        locales.put(languageCode, loc);
        return loc;
    }

    public static Locale getLocaleFromCode(String code) {
        Locale loc;
        if (code == null || code.length() == 0) {
            return Locale.ENGLISH;
        }
        String[] codes = Patterns.UNDERSCORE.split(code);
        if (codes.length == 0) {
            return Locale.ENGLISH;
        }
        if (codes.length == 1) {
            loc = new Locale(codes[0]);
        } else if (codes.length == 2) {
            loc = new Locale(codes[0], codes[1]);
        } else if (codes.length == 3) {
            loc = new Locale(codes[0], codes[1], codes[2]);
        } else {
            return Locale.ENGLISH;
        }
        return loc;
    }

    public static Locale languageTagsToLocale(String languageCode) {
        StringTokenizer codeTokens = new StringTokenizer(languageCode, "-");
        String language = "";
        String country = "";
        String variant = "";
        String primaryTag = "";
        String secondSubTag = "";
        String thirdSubTag = "";
        if (codeTokens.hasMoreTokens()) {
            primaryTag = codeTokens.nextToken();
        }
        if (codeTokens.hasMoreTokens()) {
            secondSubTag = codeTokens.nextToken();
        }
        if (codeTokens.hasMoreTokens()) {
            thirdSubTag = codeTokens.nextToken();
        }
        if (primaryTag.length() != 2) {
            return null;
        }
        language = primaryTag;
        if (secondSubTag.length() == 2) {
            country = secondSubTag;
            variant = thirdSubTag;
        } else {
            variant = secondSubTag;
        }
        return LanguageCodeConverters.newLocale(language, country, variant);
    }

    public static String localeToLanguageTag(Locale locale) {
        StringBuffer result = new StringBuffer();
        if ("".equals(locale.getLanguage())) {
            return null;
        }
        result.append(locale.getLanguage());
        if (!"".equals(locale.getCountry())) {
            result.append("-");
            result.append(locale.getCountry());
        }
        if (!"".equals(locale.getVariant())) {
            result.append("-");
            result.append(locale.getVariant());
        }
        return result.toString();
    }

    private static Locale newLocale(String language, String country, String variant) {
        if ("".equals(variant)) {
            if ("".equals(country)) {
                if ("".equals(language)) {
                    return Locale.ENGLISH;
                }
                return new Locale(language, "");
            }
            return new Locale(language, country);
        }
        return new Locale(language, country, variant);
    }

    public static List<Locale> getSortedLocaleList(Locale currentLocale) {
        ArrayList<Locale> sortedLocaleList = new ArrayList<Locale>(LocaleUtils.availableLocaleList());
        Collections.sort(sortedLocaleList, LanguageCodeConverters.getLocaleDisplayNameComparator(currentLocale));
        return sortedLocaleList;
    }

    public static Locale resolveLocaleForGuest(HttpServletRequest request) {
        Locale resolvedLocale;
        List<Locale> availableBundleLocales = LanguageCodeConverters.getAvailableBundleLocales();
        Enumeration browserLocales = request.getLocales();
        Locale locale = resolvedLocale = availableBundleLocales != null && !availableBundleLocales.isEmpty() ? availableBundleLocales.get(0) : Locale.ENGLISH;
        while (browserLocales != null && browserLocales.hasMoreElements()) {
            Locale candidate = (Locale)browserLocales.nextElement();
            if (candidate == null) continue;
            if (availableBundleLocales.contains(candidate)) {
                resolvedLocale = candidate;
                break;
            }
            if (!StringUtils.isNotEmpty((String)candidate.getCountry()) || !availableBundleLocales.contains(new Locale(candidate.getLanguage()))) continue;
            resolvedLocale = new Locale(candidate.getLanguage());
            break;
        }
        return resolvedLocale;
    }

    public static LocaleDisplayNameComparator getLocaleDisplayNameComparator(Locale locale) {
        return new LocaleDisplayNameComparator(locale);
    }

    public static List<Locale> getAvailableBundleLocales(String resourceBundleName, Locale defaultLocale) {
        LinkedList<Locale> availableBundleLocales = new LinkedList<Locale>();
        if (defaultLocale != null && ResourceBundle.getBundle(resourceBundleName, defaultLocale) != null) {
            availableBundleLocales.add(defaultLocale);
        }
        for (Locale locale : Locale.getAvailableLocales()) {
            ResourceBundle res;
            if (StringUtils.isEmpty((String)locale.getDisplayName()) || (res = ResourceBundle.getBundle(resourceBundleName, locale)) == null || !res.getLocale().equals(locale) || defaultLocale != null && locale.equals(defaultLocale)) continue;
            availableBundleLocales.add(locale);
        }
        return availableBundleLocales;
    }

    public static List<String> localesToLanguageCodes(List<Locale> locales) {
        if (locales == null) {
            return null;
        }
        if (locales.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> languageCodes = new ArrayList<String>(locales.size());
        for (Locale locale : locales) {
            languageCodes.add(locale.toString());
        }
        return languageCodes;
    }

    public static List<Locale> getAvailableBundleLocales() {
        if (availableBundleLocales == null) {
            availableBundleLocales = LanguageCodeConverters.getAvailableBundleLocales("JahiaInternalResources", null);
        }
        return availableBundleLocales;
    }

    public static List<Locale> getAvailableBundleLocalesSorted(Locale currentLocale) {
        TreeMap<String, Locale> sortedLocales = new TreeMap<String, Locale>();
        for (Locale locale : LanguageCodeConverters.getAvailableBundleLocales("JahiaInternalResources", null)) {
            sortedLocales.put(locale.getDisplayName(currentLocale), locale);
        }
        return new LinkedList<Locale>(sortedLocales.values());
    }

    public static List<Locale> getAvailableBundleLocalesSorted() {
        TreeMap<String, Locale> sortedLocales = new TreeMap<String, Locale>();
        for (Locale locale : LanguageCodeConverters.getAvailableBundleLocales("JahiaInternalResources", null)) {
            sortedLocales.put(WordUtils.capitalizeFully((String)locale.getDisplayName(locale)), locale);
        }
        return new LinkedList<Locale>(sortedLocales.values());
    }

    static {
        locales = new ConcurrentHashMap<String, Locale>();
    }

    public static class LocaleDisplayNameComparator
    implements Comparator<Locale> {
        private Collator collator = Collator.getInstance();
        private Locale currentLocale;

        public LocaleDisplayNameComparator(Locale locale) {
            if (locale != null) {
                this.currentLocale = locale;
                this.collator = Collator.getInstance(locale);
            }
        }

        @Override
        public int compare(Locale locale1, Locale locale2) {
            return this.collator.compare(locale1.getDisplayName(this.currentLocale), locale2.getDisplayName(this.currentLocale));
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof LocaleDisplayNameComparator;
        }

        public int hashCode() {
            return 0;
        }
    }
}

