/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

public abstract class LoadAverage
implements Runnable {
    protected double oneMinuteLoad = 0.0;
    protected double fiveMinuteLoad = 0.0;
    protected double fifteenMinuteLoad = 0.0;
    private double calcFreqDouble = 5.0;
    private long calcFreqMillis = 5000L;
    protected Thread loadCalcThread;
    private boolean running = false;

    public abstract double getCount();

    public abstract void tickCallback();

    public LoadAverage(String threadName) {
        this.loadCalcThread = new Thread((Runnable)this, threadName);
        this.loadCalcThread.setDaemon(true);
    }

    public void start() {
        this.running = true;
        this.loadCalcThread.start();
    }

    public void stop() {
        this.running = false;
        this.loadCalcThread.interrupt();
        try {
            this.loadCalcThread.join(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (this.running) {
            double timeInMinutes = 1.0;
            this.oneMinuteLoad = this.oneMinuteLoad * Math.exp(-this.calcFreqDouble / (60.0 * timeInMinutes)) + this.getCount() * (1.0 - Math.exp(-this.calcFreqDouble / (60.0 * timeInMinutes)));
            timeInMinutes = 5.0;
            this.fiveMinuteLoad = this.fiveMinuteLoad * Math.exp(-this.calcFreqDouble / (60.0 * timeInMinutes)) + this.getCount() * (1.0 - Math.exp(-this.calcFreqDouble / (60.0 * timeInMinutes)));
            timeInMinutes = 15.0;
            this.fifteenMinuteLoad = this.fifteenMinuteLoad * Math.exp(-this.calcFreqDouble / (60.0 * timeInMinutes)) + this.getCount() * (1.0 - Math.exp(-this.calcFreqDouble / (60.0 * timeInMinutes)));
            this.tickCallback();
            try {
                Thread.sleep(this.calcFreqMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public double getOneMinuteLoad() {
        return this.oneMinuteLoad;
    }

    public double getFiveMinuteLoad() {
        return this.fiveMinuteLoad;
    }

    public double getFifteenMinuteLoad() {
        return this.fifteenMinuteLoad;
    }
}

