/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.utils.StringOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessHelper {
    private static final Logger logger = LoggerFactory.getLogger(ProcessHelper.class);

    public static int execute(String command) throws JahiaRuntimeException {
        return ProcessHelper.execute(command, null);
    }

    public static int execute(String command, String[] arguments) throws JahiaRuntimeException {
        return ProcessHelper.execute(command, arguments, null);
    }

    public static int execute(String command, String[] arguments, Map<String, Object> parameterSubstitutionMap) throws JahiaRuntimeException {
        return ProcessHelper.execute(command, arguments, parameterSubstitutionMap, null, null, null);
    }

    public static int execute(String command, String[] arguments, Map<String, Object> parameterSubstitutionMap, File workingDir, StringBuilder resultOut, StringBuilder resultErr) throws JahiaRuntimeException {
        return ProcessHelper.execute(command, arguments, parameterSubstitutionMap, workingDir, resultOut, resultErr, true);
    }

    /*
     * Loose catch block
     */
    public static int execute(String command, String[] arguments, Map<String, Object> parameterSubstitutionMap, File workingDir, StringBuilder resultOut, StringBuilder resultErr, boolean redirectOutputs) throws JahiaRuntimeException {
        StringOutputStream err;
        StringOutputStream out;
        int exitValue;
        long timer;
        block22: {
            timer = System.currentTimeMillis();
            CommandLine cmd = new CommandLine(command);
            if (arguments != null && arguments.length > 0) {
                cmd.addArguments(arguments, false);
            }
            if (parameterSubstitutionMap != null && !parameterSubstitutionMap.isEmpty()) {
                cmd.setSubstitutionMap(parameterSubstitutionMap);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Executing command: {}", (Object)cmd.toString());
            } else if (redirectOutputs) {
                logger.info("Executing command: ");
                logger.info(cmd.toString());
            }
            exitValue = 0;
            out = new StringOutputStream(redirectOutputs ? System.out : null);
            err = new StringOutputStream(redirectOutputs ? System.err : null);
            try {
                DefaultExecutor executor = new DefaultExecutor();
                executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)out, (OutputStream)err));
                if (workingDir != null && (workingDir.exists() || workingDir.mkdirs())) {
                    executor.setWorkingDirectory(workingDir);
                }
                exitValue = executor.execute(cmd, System.getenv());
                if (resultErr == null) break block22;
                resultErr.append(err.toString());
            }
            catch (ExecuteException ee) {
                int n;
                block23: {
                    n = ee.getExitValue();
                    if (resultErr == null) break block23;
                    resultErr.append(err.toString());
                }
                if (resultOut != null) {
                    resultOut.append(out.toString());
                }
                if (exitValue > 0) {
                    logger.error("External process finished with error. Cause: {}", (Object)err.toString());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Execution took {} ms and finished with status {} and output {}", new Object[]{System.currentTimeMillis() - timer, exitValue, out.toString()});
                }
                return n;
            }
            catch (Exception e) {
                throw new JahiaRuntimeException(e);
                {
                    catch (Throwable throwable) {
                        if (resultErr != null) {
                            resultErr.append(err.toString());
                        }
                        if (resultOut != null) {
                            resultOut.append(out.toString());
                        }
                        if (exitValue > 0) {
                            logger.error("External process finished with error. Cause: {}", (Object)err.toString());
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("Execution took {} ms and finished with status {} and output {}", new Object[]{System.currentTimeMillis() - timer, exitValue, out.toString()});
                        }
                        throw throwable;
                    }
                }
            }
        }
        if (resultOut != null) {
            resultOut.append(out.toString());
        }
        if (exitValue > 0) {
            logger.error("External process finished with error. Cause: {}", (Object)err.toString());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Execution took {} ms and finished with status {} and output {}", new Object[]{System.currentTimeMillis() - timer, exitValue, out.toString()});
        }
        return exitValue;
    }
}

