/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.utils.LoadAverage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLoadAverage
extends LoadAverage {
    private static transient Logger logger = LoggerFactory.getLogger(RequestLoadAverage.class);
    private static transient RequestLoadAverage instance = null;
    private RequestCountProvider requestCountProvider;

    public RequestLoadAverage(String threadName) {
        super(threadName);
        instance = this;
    }

    public RequestLoadAverage(String threadName, RequestCountProvider requestCountProvider) {
        super(threadName);
        instance = this;
        this.requestCountProvider = requestCountProvider;
    }

    public static RequestLoadAverage getInstance() {
        return instance;
    }

    @Override
    public double getCount() {
        if (this.requestCountProvider != null) {
            return this.requestCountProvider.getRequestCount();
        }
        return JahiaContextLoaderListener.getRequestCount();
    }

    @Override
    public void tickCallback() {
        if (this.oneMinuteLoad > 2.0) {
            logger.info("Jahia Request Load = " + this.oneMinuteLoad + " " + this.fiveMinuteLoad + " " + this.fifteenMinuteLoad);
        }
    }

    public static interface RequestCountProvider {
        public long getRequestCount();
    }
}

