/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptEngineUtils {
    private Map<ClassLoader, Map<String, ScriptEngine>> scriptEngineByExtensionCache;
    private Map<ClassLoader, Map<String, ScriptEngine>> scriptEngineByNameCache;
    private ScriptEngineManager scriptEngineManager = new ScriptEngineManager();

    public static ScriptEngineUtils getInstance() {
        return Holder.INSTANCE;
    }

    private ScriptEngineUtils() {
        this.scriptEngineByExtensionCache = new ConcurrentHashMap<ClassLoader, Map<String, ScriptEngine>>(3);
        this.scriptEngineByNameCache = new ConcurrentHashMap<ClassLoader, Map<String, ScriptEngine>>(3);
        try {
            this.scriptEngineManager.getEngineByExtension("groovy").eval("true");
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
    }

    public ScriptEngine getEngineByName(String name) throws ScriptException {
        ScriptEngine scriptEngine;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Map<String, ScriptEngine> stringScriptEngineMap = this.scriptEngineByNameCache.get(contextClassLoader);
        if (stringScriptEngineMap == null) {
            stringScriptEngineMap = new ConcurrentHashMap<String, ScriptEngine>();
            this.scriptEngineByNameCache.put(contextClassLoader, stringScriptEngineMap);
        }
        if ((scriptEngine = stringScriptEngineMap.get(name)) == null) {
            scriptEngine = this.scriptEngineManager.getEngineByName(name);
            if (scriptEngine == null) {
                throw new ScriptException("Script engine not found for name :" + name);
            }
            this.initEngine(scriptEngine);
            stringScriptEngineMap.put(name, scriptEngine);
        }
        return scriptEngine;
    }

    private void initEngine(ScriptEngine engine) {
        if (engine.getFactory().getNames().contains("velocity")) {
            Properties velocityProperties = new Properties();
            if (System.getProperty("runtime.log.logsystem.log4j.logger") != null) {
                velocityProperties.setProperty("runtime.log.logsystem.log4j.logger", System.getProperty("runtime.log.logsystem.log4j.logger"));
            } else {
                velocityProperties.setProperty("runtime.log.logsystem.log4j.logger", "root");
            }
            engine.getContext().setAttribute("com.sun.script.velocity.properties", velocityProperties, 200);
        }
    }

    public ScriptEngine scriptEngine(String extension) throws ScriptException {
        ScriptEngine scriptEngine;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Map<String, ScriptEngine> stringScriptEngineMap = this.scriptEngineByExtensionCache.get(contextClassLoader);
        if (stringScriptEngineMap == null) {
            stringScriptEngineMap = new ConcurrentHashMap<String, ScriptEngine>();
            this.scriptEngineByExtensionCache.put(contextClassLoader, stringScriptEngineMap);
        }
        if ((scriptEngine = stringScriptEngineMap.get(extension)) == null) {
            scriptEngine = this.scriptEngineManager.getEngineByExtension(extension);
            if (scriptEngine == null) {
                throw new ScriptException("Script engine not found for extension: " + extension);
            }
            this.initEngine(scriptEngine);
            stringScriptEngineMap.put(extension, scriptEngine);
        }
        return scriptEngine;
    }

    private static class Holder {
        static final ScriptEngineUtils INSTANCE = new ScriptEngineUtils();

        private Holder() {
        }
    }
}

