/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.zip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.exceptions.JahiaArchiveFileException;
import org.jahia.exceptions.JahiaException;
import org.jahia.utils.zip.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaArchiveFileHandler {
    private static Logger logger = LoggerFactory.getLogger(JahiaArchiveFileHandler.class);
    private static final String CLASS_NAME = JahiaArchiveFileHandler.class.getName();
    private String m_FilePath;
    private JarFile m_JarFile;
    private String basePath;

    public JahiaArchiveFileHandler(String path) throws IOException {
        this.m_FilePath = path;
        File f = new File(path);
        try {
            this.m_JarFile = new JarFile(f);
        }
        catch (IOException ioe) {
            logger.error("IOException occurred " + f.getAbsolutePath(), (Throwable)ioe);
            throw new IOException(CLASS_NAME + " IOException occurred ");
        }
        catch (NullPointerException e) {
            logger.error("NullPointerException " + f.getAbsolutePath(), (Throwable)e);
            throw new IOException(CLASS_NAME + " NullPointerException occurred ");
        }
        if (this.m_JarFile == null) {
            throw new IOException(CLASS_NAME + " source file is null");
        }
    }

    public JahiaArchiveFileHandler(String path, String basePath) throws IOException {
        this(path);
        this.basePath = basePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzip() throws JahiaException {
        try {
            File f = new File(this.m_FilePath);
            String parentPath = f.getParent() + File.separator;
            String path = null;
            FileInputStream fis = new FileInputStream(this.m_FilePath);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ZipInputStream zis = new ZipInputStream(bis);
            ZipFile zf = new ZipFile(this.m_FilePath);
            ZipEntry ze = null;
            String zeName = null;
            try {
                while ((ze = zis.getNextEntry()) != null) {
                    zeName = ze.getName();
                    path = parentPath + this.genPathFile(zeName);
                    File fo = new File(path);
                    if (ze.isDirectory()) {
                        fo.mkdirs();
                    } else {
                        this.copyStream(zis, new FileOutputStream(fo));
                    }
                    zis.closeEntry();
                }
            }
            finally {
                zf.close();
                fis.close();
                zis.close();
                bis.close();
            }
        }
        catch (IOException ioe) {
            logger.error(" fail unzipping " + ioe.getMessage(), (Throwable)ioe);
            throw new JahiaException("JahiaArchiveFileHandler", "faile processing unzip", 12, 2, ioe);
        }
    }

    public Map<String, String> unzip(String path) throws JahiaException {
        return this.unzip(path, true);
    }

    public Map<String, String> unzip(String path, PathFilter pathFilter) throws JahiaException {
        return this.unzip(path, true, pathFilter, null);
    }

    public Map<String, String> unzip(String path, boolean overwrite) throws JahiaException {
        return this.unzip(path, overwrite, PathFilter.ALL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> unzip(String path, boolean overwrite, PathFilter pathFilter, String pathPrefix) throws JahiaException {
        TreeMap<String, String> unzippedFiles = new TreeMap<String, String>();
        HashMap<File, Long> timestamps = new HashMap<File, Long>();
        pathFilter = pathFilter != null ? pathFilter : PathFilter.ALL;
        try {
            String destPath = null;
            FileInputStream fis = new FileInputStream(this.m_FilePath);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ZipInputStream zis = new ZipInputStream(bis);
            ZipFile zf = new ZipFile(this.m_FilePath);
            ZipEntry ze = null;
            String zeName = null;
            try {
                while ((ze = zis.getNextEntry()) != null) {
                    zeName = ze.getName();
                    String filePath = this.genPathFile(zeName);
                    destPath = path + File.separator + filePath;
                    File fo = new File(destPath);
                    if (pathFilter.accept(pathPrefix != null ? pathPrefix + "/" + zeName : zeName)) {
                        String loggedPath = fo.getAbsolutePath();
                        if (this.basePath != null) {
                            loggedPath = StringUtils.substringAfter((String)loggedPath, (String)this.basePath);
                        }
                        unzippedFiles.put(filePath, loggedPath);
                        long lastModified = ze.getTime();
                        if (lastModified > 0L) {
                            timestamps.put(fo, lastModified);
                        }
                        if (ze.isDirectory()) {
                            fo.mkdirs();
                        } else if (overwrite || !fo.exists()) {
                            File parent = new File(fo.getParent());
                            parent.mkdirs();
                            FileOutputStream fos = new FileOutputStream(fo);
                            this.copyStream(zis, fos);
                        }
                    }
                    zis.closeEntry();
                }
            }
            finally {
                zf.close();
                fis.close();
                zis.close();
                bis.close();
            }
        }
        catch (IOException ioe) {
            logger.error(" fail unzipping " + ioe.getMessage(), (Throwable)ioe);
            throw new JahiaException(CLASS_NAME, "faile processing unzip", 12, 2, ioe);
        }
        for (Map.Entry tst : timestamps.entrySet()) {
            try {
                ((File)tst.getKey()).setLastModified((Long)tst.getValue());
            }
            catch (Exception e) {
                logger.warn("Unable to set last mofified date for file {}. Cause: {}", tst.getKey(), (Object)e.getMessage());
            }
        }
        return unzippedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File extractFile(String entryName) throws IOException, JahiaArchiveFileException {
        File tmpFile = null;
        ZipEntry entry = this.m_JarFile.getEntry(entryName);
        if (entry != null && !entry.isDirectory()) {
            InputStream ins = this.m_JarFile.getInputStream(entry);
            if (ins != null) {
                tmpFile = File.createTempFile("jahia_temp", ".jar", null);
                if (tmpFile == null || !tmpFile.canWrite()) {
                    throw new IOException("extractFile error creating temporary file");
                }
                FileOutputStream outs = new FileOutputStream(tmpFile);
                try {
                    this.copyStream(ins, outs);
                    outs.flush();
                }
                finally {
                    outs.close();
                }
            }
        } else {
            logger.error(entryName + " is null or a directory ");
            throw new JahiaArchiveFileException(30);
        }
        return tmpFile;
    }

    public String extractContent(String entryName) throws IOException, JahiaArchiveFileException {
        if (!this.entryExists(entryName)) {
            throw new JahiaArchiveFileException(30);
        }
        ZipEntry entry = this.m_JarFile.getEntry(entryName);
        StringWriter out = new StringWriter();
        IOUtils.copy((InputStream)this.m_JarFile.getInputStream(entry), (Writer)out);
        return out.getBuffer().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractEntry(String entryName, String destPath) throws JahiaException {
        try {
            ZipEntry entry = this.m_JarFile.getEntry(entryName);
            if (entry == null) {
                StringBuffer strBuf = new StringBuffer(1024);
                strBuf.append(" extractEntry(), cannot find entry ");
                strBuf.append(entryName);
                strBuf.append(" in the jar file ");
                throw new JahiaException(CLASS_NAME, strBuf.toString(), 12, 2);
            }
            File destDir = new File(destPath);
            if (destDir == null || !destDir.isDirectory() || !destDir.canWrite()) {
                logger.error(" cannot access to the destination dir " + destPath);
                throw new JahiaException(CLASS_NAME, " cannot access to the destination dir ", 12, 2);
            }
            String path = null;
            FileInputStream fis = new FileInputStream(this.m_FilePath);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ZipInputStream zis = new ZipInputStream(bis);
            ZipFile zf = new ZipFile(this.m_FilePath);
            ZipEntry ze = null;
            String zeName = null;
            while ((ze = zis.getNextEntry()) != null && !ze.getName().equalsIgnoreCase(entryName)) {
                zis.closeEntry();
            }
            try {
                if (ze != null) {
                    if (ze.isDirectory()) {
                        while (ze != null) {
                            zeName = ze.getName();
                            path = destPath + File.separator + this.genPathFile(zeName);
                            File fo = new File(path);
                            if (ze.isDirectory()) {
                                fo.mkdirs();
                            } else {
                                FileOutputStream outs = new FileOutputStream(fo);
                                this.copyStream(zis, outs);
                            }
                            zis.closeEntry();
                            ze = zis.getNextEntry();
                        }
                    } else {
                        zeName = ze.getName();
                        path = destPath + File.separator + this.genPathFile(zeName);
                        File fo = new File(path);
                        FileOutputStream outs = new FileOutputStream(fo);
                        this.copyStream(zis, outs);
                    }
                }
            }
            finally {
                zf.close();
                fis.close();
                zis.close();
                bis.close();
            }
        }
        catch (IOException ioe) {
            logger.error(" fail unzipping " + ioe.getMessage(), (Throwable)ioe);
            throw new JahiaException(CLASS_NAME, "faile processing unzip", 12, 2, ioe);
        }
    }

    public ZipEntry getEntry(String entryName) {
        return this.m_JarFile.getEntry(entryName);
    }

    public boolean isDirectory(String entryName) {
        return this.m_JarFile.getEntry(entryName) != null && this.m_JarFile.getEntry(entryName).isDirectory();
    }

    public boolean entryExists(String entryName) {
        return this.m_JarFile.getEntry(entryName) != null;
    }

    public void closeArchiveFile() {
        try {
            this.m_JarFile.close();
        }
        catch (IOException e) {
            logger.error("cannot close jar file", (Throwable)e);
        }
    }

    protected String genPathFile(String entryName) {
        StringBuffer sb = new StringBuffer(entryName.length());
        for (int i = 0; i < entryName.length(); ++i) {
            if (entryName.charAt(i) == '/') {
                sb.append(File.separator);
                continue;
            }
            sb.append(entryName.charAt(i));
        }
        return sb.toString();
    }

    protected void copyStream(InputStream ins, OutputStream outs) throws IOException {
        int bufferRead;
        int bufferSize = 1024;
        byte[] writeBuffer = new byte[bufferSize];
        BufferedOutputStream bos = new BufferedOutputStream(outs, bufferSize);
        while ((bufferRead = ins.read(writeBuffer)) != -1) {
            bos.write(writeBuffer, 0, bufferRead);
        }
        bos.flush();
        bos.close();
        outs.flush();
        outs.close();
    }

    public String getPath() {
        return this.m_JarFile.getName();
    }
}

