/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.conversation.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.conversation.Conversation;
import org.springframework.webflow.conversation.ConversationId;
import org.springframework.webflow.conversation.ConversationParameters;
import org.springframework.webflow.conversation.NoSuchConversationException;
import org.springframework.webflow.conversation.impl.ContainedConversation;
import org.springframework.webflow.conversation.impl.ConversationContainer;
import org.springframework.webflow.conversation.impl.ConversationLockFactory;
import org.springframework.webflow.conversation.impl.SimpleConversationId;

class JahiaConversationContainer
extends ConversationContainer {
    private static final long serialVersionUID = 6043504320583152706L;
    private transient Logger logger;
    private int maxConversations;
    private String sessionKey;
    private List<ContainedConversation> conversations;
    private int conversationIdSequence;

    public JahiaConversationContainer(int maxConversations, String sessionKey) {
        super(maxConversations, sessionKey);
        this.maxConversations = maxConversations;
        this.sessionKey = sessionKey;
        this.conversations = new ArrayList<ContainedConversation>();
    }

    String getSessionKey() {
        return this.sessionKey;
    }

    public int size() {
        return this.conversations.size();
    }

    public synchronized Conversation createConversation(ConversationParameters parameters, ConversationLockFactory lockFactory) {
        ContainedConversation conversation = new ContainedConversation((ConversationContainer)this, this.nextId(), lockFactory.createLock());
        conversation.putAttribute((Object)"name", (Object)parameters.getName());
        conversation.putAttribute((Object)"caption", (Object)parameters.getCaption());
        conversation.putAttribute((Object)"description", (Object)parameters.getDescription());
        this.conversations.add(conversation);
        if (this.maxExceeded()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The maximum number of flow executions has been exceeded for the current user. Removing the oldest conversation with id: " + ((Conversation)this.conversations.get(0)).getId());
            }
            ((Conversation)this.conversations.get(0)).end();
        }
        return conversation;
    }

    private ConversationId nextId() {
        return new SimpleConversationId((Serializable)Integer.valueOf(++this.conversationIdSequence));
    }

    public synchronized Conversation getConversation(ConversationId id) throws NoSuchConversationException {
        for (ContainedConversation conversation : this.conversations) {
            if (!conversation.getId().equals(id)) continue;
            this.conversations.remove(conversation);
            this.conversations.add(conversation);
            return conversation;
        }
        throw new NoSuchConversationException(id);
    }

    public synchronized void removeConversation(ConversationId id) {
        Iterator<ContainedConversation> it = this.conversations.iterator();
        while (it.hasNext()) {
            ContainedConversation conversation = it.next();
            if (!conversation.getId().equals(id)) continue;
            it.remove();
            break;
        }
    }

    private boolean maxExceeded() {
        return this.maxConversations > 0 && this.conversations.size() > this.maxConversations;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(JahiaConversationContainer.class);
        }
        return this.logger;
    }
}

