/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.ItemRemoveOperation;
import org.apache.jackrabbit.core.JahiaNodeTypeInstanceHandler;
import org.apache.jackrabbit.core.JahiaVersionManagerImpl;
import org.apache.jackrabbit.core.NodeTypeInstanceHandler;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.XASessionImpl;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.security.JahiaAccessManager;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;

public class JahiaSessionImpl
extends XASessionImpl {
    private NodeTypeInstanceHandler myNtInstanceHandler;
    private Map<String, Object> jahiaAttributes;

    public JahiaSessionImpl(RepositoryContext repositoryContext, AuthContext loginContext, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        super(repositoryContext, loginContext, wspConfig);
        this.init();
    }

    public JahiaSessionImpl(RepositoryContext repositoryContext, Subject subject, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        super(repositoryContext, subject, wspConfig);
        this.init();
    }

    private void init() {
        this.jahiaAttributes = new HashMap<String, Object>();
        WorkspaceImpl ws = (WorkspaceImpl)this.getWorkspace();
        ws.versionMgr = new JahiaVersionManagerImpl(this.context, (UpdatableItemStateManager)ws.stateMgr, (HierarchyManager)ws.hierMgr);
    }

    public JahiaNodeTypeInstanceHandler getNodeTypeInstanceHandler() throws RepositoryException {
        if (this.myNtInstanceHandler == null) {
            this.myNtInstanceHandler = super.getNodeTypeInstanceHandler();
        }
        return (JahiaNodeTypeInstanceHandler)this.myNtInstanceHandler;
    }

    public String getPrefix(String uri) throws NamespaceException {
        try {
            return this.getNamespacePrefix(uri);
        }
        catch (NamespaceException e) {
            return this.repositoryContext.getNamespaceRegistry().getPrefix(uri);
        }
        catch (RepositoryException e) {
            throw new NamespaceException("Namespace not found: " + uri, (Throwable)e);
        }
    }

    public String getURI(String prefix) throws NamespaceException {
        try {
            return this.getNamespaceURI(prefix);
        }
        catch (NamespaceException e) {
            return this.repositoryContext.getNamespaceRegistry().getURI(prefix);
        }
        catch (RepositoryException e) {
            throw new NamespaceException("Namespace not found: " + prefix, (Throwable)e);
        }
    }

    public void setJahiaAttributes(String attributeName, Object attributeValue) {
        this.jahiaAttributes.put(attributeName, attributeValue);
    }

    public void toggleThisSessionAsAliased() {
        this.setJahiaAttributes("isAliasedUser", Boolean.TRUE);
        JahiaAccessManager accessManager = (JahiaAccessManager)this.context.getAccessManager();
        if (this.jahiaAttributes.containsKey("isAliasedUser") && ((Boolean)this.jahiaAttributes.get("isAliasedUser")).booleanValue()) {
            accessManager.setAliased(true);
        }
    }

    public void removeItemForce(Item itemToRemove) throws RepositoryException {
        new ItemRemoveOperation((ItemImpl)itemToRemove, false).perform(this.context);
    }

    public SessionContext getContext() {
        return this.context;
    }
}

