/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.cluster.ChangeLogRecord;
import org.apache.jackrabbit.core.cluster.ClusterException;
import org.apache.jackrabbit.core.cluster.ClusterNode;
import org.apache.jackrabbit.core.cluster.NamespaceRecord;
import org.apache.jackrabbit.core.cluster.NodeLevelLockableJournal;
import org.apache.jackrabbit.core.cluster.NodeTypeRecord;
import org.apache.jackrabbit.core.cluster.Update;
import org.apache.jackrabbit.core.cluster.UpdateEventChannel;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.journal.AbstractJournal;
import org.apache.jackrabbit.core.journal.FileRevision;
import org.apache.jackrabbit.core.journal.Journal;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaClusterNode
extends ClusterNode {
    private static final int NONE = 0;
    private static final int STARTED = 1;
    private static final int STOPPED = 2;
    private static final Logger log = LoggerFactory.getLogger(JahiaClusterNode.class);
    private volatile int status = 0;

    public synchronized void start() throws ClusterException {
        if (this.status == 0) {
            super.start();
            this.status = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        String revisionFile;
        this.status = 2;
        super.stop();
        Journal j = this.getJournal();
        if (j != null && j instanceof AbstractJournal && (revisionFile = ((AbstractJournal)j).getRevision()) != null) {
            try (FileRevision currentFileRevision = null;){
                currentFileRevision = new FileRevision(new File(revisionFile));
                long rev = this.getRevision();
                currentFileRevision.set(rev);
                log.info("Written local revision {} into revision file", (Object)rev);
            }
        }
    }

    public UpdateEventChannel createUpdateChannel(String workspace) {
        return new WorkspaceUpdateChannel(workspace);
    }

    private void unlockNodes(Update update) throws JournalException {
        Journal journal = this.getJournal();
        if (journal instanceof NodeLevelLockableJournal) {
            Set ids = (Set)update.getAttribute("allIds");
            ((NodeLevelLockableJournal)journal).unlockNodes(ids);
        }
    }

    private void lockNodes(Update update) throws JournalException {
        Journal journal = this.getJournal();
        if (journal instanceof NodeLevelLockableJournal) {
            Set ids = (Set)update.getAttribute("allIds");
            ((NodeLevelLockableJournal)journal).lockNodes(ids);
        }
    }

    private void storeNodeIds(Update update) {
        if (this.getJournal() instanceof NodeLevelLockableJournal) {
            HashSet<NodeId> nodeIdList = new HashSet<NodeId>();
            for (ItemState state : update.getChanges().addedStates()) {
                nodeIdList.add(state.getParentId());
            }
            for (ItemState state : update.getChanges().modifiedStates()) {
                if (state.isNode()) {
                    nodeIdList.add((NodeId)state.getId());
                    continue;
                }
                nodeIdList.add(state.getParentId());
            }
            for (ItemState state : update.getChanges().deletedStates()) {
                if (state.isNode()) {
                    nodeIdList.add(state.getParentId());
                    nodeIdList.add((NodeId)state.getId());
                    continue;
                }
                nodeIdList.add(state.getParentId());
            }
            update.setAttribute("allIds", nodeIdList);
        }
    }

    public void process(ChangeLogRecord record) {
        super.process(new ChangeLogRecord((ChangeLog)new ExternalChangeLog(record.getChanges()), record.getEvents(), null, record.getWorkspace(), record.getTimestamp(), record.getUserData()));
    }

    public void process(NamespaceRecord record) {
        NodeTypeRegistry.getInstance().getNamespaces().put(record.getNewPrefix(), record.getUri());
        super.process(record);
    }

    public void process(NodeTypeRecord record) {
        try {
            JCRStoreService.getInstance().reloadNodeTypeRegistry();
        }
        catch (RepositoryException e) {
            String msg = "Unable to register nodetypes : " + e.getMessage();
            log.error(msg);
        }
        super.process(record);
    }

    public void setRevision(long revision) {
        if (!(this.getJournal() instanceof NodeLevelLockableJournal)) {
            super.setRevision(revision);
        }
    }

    public void reallySetRevision(long revision) {
        log.debug("Set revision: {}", (Object)revision);
        super.setRevision(revision);
    }

    public static class ExternalChangeLog
    extends ChangeLog {
        public ExternalChangeLog(ChangeLog changes) {
            for (ItemState state : changes.deletedStates()) {
                this.deleted(state);
            }
            for (ItemState state : changes.modifiedStates()) {
                this.modified(state);
            }
            for (ItemState state : changes.addedStates()) {
                this.added(state);
            }
            for (NodeReferences ref : changes.modifiedRefs()) {
                this.modified(ref);
            }
        }
    }

    private class WorkspaceUpdateChannel
    extends ClusterNode.WorkspaceUpdateChannel
    implements UpdateEventChannel {
        public WorkspaceUpdateChannel(String workspace) {
            super((ClusterNode)JahiaClusterNode.this, workspace);
        }

        public void updateCreated(Update update) throws ClusterException {
            if (JahiaClusterNode.this.status != 1) {
                log.info("not started: update create ignored.");
                return;
            }
            super.updateCreated(update);
            try {
                JahiaClusterNode.this.storeNodeIds(update);
                JahiaClusterNode.this.lockNodes(update);
            }
            catch (JournalException e) {
                throw new ClusterException("Unable to create log entry: " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw new ClusterException("Unexpected error while creating log entry: " + e.getMessage(), (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateCommitted(Update update, String path) {
            if (JahiaClusterNode.this.status != 1) {
                log.info("not started: update commit ignored.");
                return;
            }
            try {
                super.updateCommitted(update, path);
            }
            finally {
                try {
                    JahiaClusterNode.this.unlockNodes(update);
                }
                catch (JournalException e) {
                    log.error("Unable to commit log entry: " + e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    log.error("Unexpected error while committing log entry: " + e.getMessage(), (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateCancelled(Update update) {
            if (JahiaClusterNode.this.status != 1) {
                log.info("not started: update cancel ignored.");
                return;
            }
            try {
                super.updateCancelled(update);
            }
            finally {
                try {
                    JahiaClusterNode.this.unlockNodes(update);
                }
                catch (JournalException e) {
                    log.error("Unable to cancel log entry: " + e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    log.error("Unexpected error while cancelling log entry: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

