/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.nodetype.xml.AdditionalNamespaceResolver;
import org.apache.jackrabbit.core.query.QueryHandlerContext;
import org.apache.jackrabbit.core.query.lucene.AnalyzerCustomizer;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IndexingConfiguration;
import org.apache.jackrabbit.core.query.lucene.IndexingConfigurationImpl;
import org.apache.jackrabbit.core.query.lucene.LanguageCustomizingAnalyzerRegistry;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.conversion.ParsingNameResolver;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JahiaIndexingConfigurationImpl
extends IndexingConfigurationImpl {
    private static final String FACET_EXPRESSION = ":FACET:";
    private static final String SPELLCHECK_EXPRESSION = FieldNames.FULLTEXT + "-";
    private static final Name TRANSLATION_TYPE = NameFactoryImpl.getInstance().create("http://www.jahia.org/jahia/nt/1.0", "translation");
    private static final Logger logger = LoggerFactory.getLogger(JahiaIndexingConfigurationImpl.class);
    public static final String FULL_SPELLCHECK_FIELD_NAME = "0:FULL:SPELLCHECK";
    private ItemStateManager ism;
    private Set<String> includedInSpellchecking = null;
    private final LanguageCustomizingAnalyzerRegistry analyzerRegistry = new LanguageCustomizingAnalyzerRegistry((IndexingConfiguration)this);
    private Set<Name> excludesFromI18NCopy = Collections.emptySet();
    private Set<Name> hierarchicalNodetypes = Collections.emptySet();
    private final Analyzer keywordAnalyzer = new KeywordAnalyzer();

    private static String getTextContent(Node node) {
        StringBuilder content = new StringBuilder();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() != 3) continue;
            content.append(((CharacterData)n).getData());
        }
        return content.toString();
    }

    public Set<Name> getExcludesFromI18NCopy() {
        return this.excludesFromI18NCopy;
    }

    public Set<Name> getHierarchicalNodetypes() {
        return this.hierarchicalNodetypes;
    }

    private Properties getNamespaces(Node node) {
        Properties namespaces = new Properties();
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if (!attribute.getName().startsWith("xmlns:")) continue;
            namespaces.setProperty(attribute.getName().substring(6), attribute.getValue());
        }
        return namespaces;
    }

    public Analyzer getPropertyAnalyzer(String fieldName) {
        Analyzer analyzer = StringUtils.contains((String)fieldName, (String)FACET_EXPRESSION) ? this.keywordAnalyzer : super.getPropertyAnalyzer(StringUtils.startsWith((String)fieldName, (String)SPELLCHECK_EXPRESSION) ? FULL_SPELLCHECK_FIELD_NAME : fieldName);
        return analyzer;
    }

    public void init(Element config, QueryHandlerContext context, NamespaceMappings nsMappings) throws Exception {
        this.ism = context.getItemStateManager();
        Properties customNamespaces = this.getNamespaces(config);
        this.registerCustomNamespaces(context.getNamespaceRegistry(), customNamespaces);
        super.init(config, context, nsMappings);
        AdditionalNamespaceResolver nsResolver = new AdditionalNamespaceResolver(customNamespaces);
        ParsingNameResolver resolver = new ParsingNameResolver(NameFactoryImpl.getInstance(), (NamespaceResolver)nsResolver);
        NodeList indexingConfigs = config.getChildNodes();
        for (int i = 0; i < indexingConfigs.getLength(); ++i) {
            Node configNode = indexingConfigs.item(i);
            String nodeName = configNode.getNodeName();
            if (nodeName.equals("i18ncopy")) {
                this.excludesFromI18NCopy = this.initPropertyCollectionFrom(configNode, "exclude-property", (NameResolver)resolver);
                continue;
            }
            if (nodeName.equals("hierarchical")) {
                this.hierarchicalNodetypes = this.initPropertyCollectionFrom(configNode, "nodetype", (NameResolver)resolver);
                continue;
            }
            if (nodeName.equals("spellchecker")) {
                this.includedInSpellchecking = this.initPropertyCollectionFrom(configNode, "include-property", null);
                continue;
            }
            if (!nodeName.equals("analyzer-registry")) continue;
            this.processAnalyzerRegistryConfiguration(configNode);
        }
    }

    private void processAnalyzerRegistryConfiguration(Node configNode) {
        try {
            NodeList childNodes = configNode.getChildNodes();
            int length = childNodes.getLength();
            for (int j = 0; j < length; ++j) {
                Node child = childNodes.item(j);
                if (1 != child.getNodeType()) continue;
                String lang = child.getNodeName();
                String className = this.getClassAttribute(child);
                if (className == null) continue;
                Analyzer analyzer = null;
                Class<?> analyzerClass = Class.forName(className);
                try {
                    Constructor<?> constructor = analyzerClass.getConstructor(Version.class);
                    analyzer = (Analyzer)constructor.newInstance(Version.LUCENE_30);
                }
                catch (Exception e) {
                    try {
                        analyzer = (Analyzer)analyzerClass.newInstance();
                    }
                    catch (Exception e1) {
                        logger.warn("Couldn't instantiate Analyzer class: " + className + ". It must provide a constructor with a org.apache.lucene.util.Version " + "argument or a no-arg constructor.", (Throwable)e1);
                    }
                }
                if (analyzer == null) continue;
                Boolean useASCIIFoldingFilter = null;
                try {
                    useASCIIFoldingFilter = Boolean.parseBoolean(child.getAttributes().getNamedItem("useASCIIFoldingFilter").getNodeValue().trim());
                }
                catch (Exception e1) {
                    // empty catch block
                }
                NodeList potentialCustomizers = child.getChildNodes();
                int potentialCustomizersNb = potentialCustomizers.getLength();
                for (int customizerIndex = 0; customizerIndex < potentialCustomizersNb; ++customizerIndex) {
                    String customizerClassName;
                    Node customizerNode = potentialCustomizers.item(customizerIndex);
                    if (1 != customizerNode.getNodeType() || (customizerClassName = this.getClassAttribute(customizerNode)) == null) continue;
                    try {
                        Class<?> customizerClass = Class.forName(customizerClassName);
                        AnalyzerCustomizer customizer = (AnalyzerCustomizer)customizerClass.newInstance();
                        NodeList keys = customizerNode.getChildNodes();
                        int keyNb = keys.getLength();
                        HashMap<String, List<String>> props = new HashMap<String, List<String>>(keyNb);
                        for (int keyIndex = 0; keyIndex < keyNb; ++keyIndex) {
                            Node item = keys.item(keyIndex);
                            if (1 != item.getNodeType()) continue;
                            String key = item.getNodeName();
                            String value = JahiaIndexingConfigurationImpl.getTextContent(item).trim();
                            ArrayList<String> values = (ArrayList<String>)props.get(key);
                            if (values == null) {
                                values = new ArrayList<String>();
                                props.put(key, values);
                            }
                            values.add(value);
                        }
                        customizer.initFrom(props);
                        analyzer = customizer.customize(analyzer);
                        break;
                    }
                    catch (Exception e) {
                        logger.warn("Couldn't instantiate AnalyzerCustomizer class: " + customizerClassName, (Throwable)e);
                    }
                }
                this.analyzerRegistry.addAnalyzer(lang, analyzer, useASCIIFoldingFilter);
            }
        }
        catch (Exception e) {
            logger.warn("Couldn't process AnalyzerRegistry configuration", (Throwable)e);
        }
    }

    private String getClassAttribute(Node node) {
        try {
            return node.getAttributes().getNamedItem("class").getNodeValue().trim();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Set initPropertyCollectionFrom(Node configNode, String childNameToAdd, NameResolver resolver) {
        NodeList childNodes = configNode.getChildNodes();
        int length = childNodes.getLength();
        HashSet<String> configurationCollection = new HashSet<String>(length);
        for (int j = 0; j < length; ++j) {
            Node childNode = childNodes.item(j);
            if (!childNode.getNodeName().equals(childNameToAdd)) continue;
            String propertyName = JahiaIndexingConfigurationImpl.getTextContent(childNode);
            try {
                String name = resolver != null ? resolver.getQName(propertyName) : propertyName;
                configurationCollection.add(name);
                continue;
            }
            catch (Exception e) {
                logger.warn("Cannot resolve configured property name : " + propertyName, (Throwable)e);
            }
        }
        return configurationCollection;
    }

    private void registerCustomNamespaces(NamespaceRegistryImpl namespaceRegistry, Properties customNamespaces) {
        for (Object key : customNamespaces.keySet()) {
            String prefix = (String)key;
            try {
                namespaceRegistry.getURI(prefix);
            }
            catch (NamespaceException e) {
                String uri = customNamespaces.getProperty(prefix);
                try {
                    namespaceRegistry.registerNamespace(prefix, uri);
                    logger.info("Registered custom namespace with prefix '{}' and URI '{}'", (Object)prefix, (Object)uri);
                }
                catch (RepositoryException e1) {
                    logger.warn("Unable to register custom namespace with prefix '" + prefix + "' and URI '" + uri + "'");
                }
            }
        }
    }

    public boolean isIndexed(NodeState state, Name propertyName) {
        return super.isIndexed(this.getUntranslatedNode(state), propertyName);
    }

    public float getPropertyBoost(NodeState state, Name propertyName) {
        return super.getPropertyBoost(this.getUntranslatedNode(state), propertyName);
    }

    public float getNodeBoost(NodeState state) {
        return super.getNodeBoost(this.getUntranslatedNode(state));
    }

    public boolean isIncludedInNodeScopeIndex(NodeState state, Name propertyName) {
        return super.isIncludedInNodeScopeIndex(this.getUntranslatedNode(state), propertyName);
    }

    public boolean useInExcerpt(NodeState state, Name propertyName) {
        return super.useInExcerpt(this.getUntranslatedNode(state), propertyName);
    }

    private NodeState getUntranslatedNode(NodeState state) {
        if (TRANSLATION_TYPE.equals(state.getNodeTypeName())) {
            try {
                state = (NodeState)this.ism.getItemState((ItemId)state.getParentId());
            }
            catch (ItemStateException itemStateException) {
                // empty catch block
            }
        }
        return state;
    }

    public boolean shouldPropertyBeSpellchecked(String propertyName) {
        return this.includedInSpellchecking == null || this.includedInSpellchecking.contains(propertyName);
    }

    public LanguageCustomizingAnalyzerRegistry getAnalyzerRegistry() {
        return this.analyzerRegistry;
    }
}

