/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.OnWorkspaceInconsistency;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.QueryHandlerContext;
import org.apache.jackrabbit.core.query.lucene.ConsistencyCheck;
import org.apache.jackrabbit.core.query.lucene.IndexingConfiguration;
import org.apache.jackrabbit.core.query.lucene.JahiaSearchIndex;
import org.apache.jackrabbit.core.query.lucene.MultiIndex;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.RedoLogFactory;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.SpellChecker;
import org.apache.jackrabbit.core.query.lucene.directory.DirectoryManager;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.spi.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Similarity;
import org.apache.tika.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaSecondaryIndex
extends JahiaSearchIndex {
    private static final Logger log = LoggerFactory.getLogger(JahiaSecondaryIndex.class);
    private List<DelayedIndexUpdate> delayedUpdates = Collections.synchronizedList(new LinkedList());
    private JahiaSearchIndex mainIndex;
    private SpellChecker spellChecker;
    private String path;

    public JahiaSecondaryIndex(JahiaSearchIndex mainIndex) {
        this.mainIndex = mainIndex;
    }

    protected void newIndexInit() throws IOException {
        QueryHandlerContext context = this.getContext();
        HashSet<NodeId> excludedIDs = new HashSet<NodeId>();
        if (context.getExcludedNodeId() != null) {
            excludedIDs.add(context.getExcludedNodeId());
        } else if (JahiaSearchIndex.SKIP_VERSION_INDEX) {
            excludedIDs.add(RepositoryImpl.VERSION_STORAGE_NODE_ID);
        }
        long startTime = System.currentTimeMillis();
        this.index = new MultiIndex((SearchIndex)this, excludedIDs);
        if (this.index.numDocs() == 0) {
            Path rootPath = context.getExcludedNodeId() == null ? JCR_SYSTEM_PATH : ROOT_PATH;
            this.index.createInitialIndex(context.getItemStateManager(), context.getRootId(), rootPath);
        }
        log.info("Creation of initial index finished in {} ms", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        log.info("Running consistency check...");
        try {
            ConsistencyCheck check = this.runConsistencyCheck();
            check.repair(true);
        }
        catch (Exception e) {
            log.warn("Failed to run consistency check on index: " + e);
        }
        log.info("Consistency check took {} ms", (Object)(System.currentTimeMillis() - startTime));
        this.initSpellChecker();
    }

    private void initSpellChecker() {
        SpellChecker spCheck = null;
        String spellCheckerClassName = this.getSpellCheckerClass();
        if (spellCheckerClassName != null) {
            try {
                Class<?> clazz = Class.forName(spellCheckerClassName);
                if (SpellChecker.class.isAssignableFrom(clazz)) {
                    spCheck = (SpellChecker)clazz.newInstance();
                    spCheck.init((QueryHandler)this);
                } else {
                    log.warn("Invalid value for spellCheckerClass, {} does not implement SpellChecker interface.", (Object)spellCheckerClassName);
                }
            }
            catch (Exception e) {
                log.warn("Exception initializing spell checker: " + spellCheckerClassName, (Throwable)e);
            }
        }
        this.spellChecker = spCheck;
    }

    void replayDelayedUpdates(JahiaSearchIndex targetIndex) throws RepositoryException, IOException {
        long start = System.currentTimeMillis();
        int count = 0;
        while (!this.delayedUpdates.isEmpty()) {
            DelayedIndexUpdate n = this.delayedUpdates.remove(0);
            ++count;
            targetIndex.updateNodes(n.remove, n.add, false);
        }
        if (count > 0) {
            log.info("Replayed {} delayed updates on index {} in {} ms", new Object[]{count, this.getPath(), System.currentTimeMillis() - start});
        }
    }

    void addDelayedUpdated(Iterator<NodeId> remove, Iterator<NodeState> add) {
        this.delayedUpdates.add(new DelayedIndexUpdate(remove, add));
    }

    public SpellChecker getSpellChecker() {
        return this.spellChecker;
    }

    public IndexingConfiguration getIndexingConfig() {
        return this.mainIndex.getIndexingConfig();
    }

    public NamespaceMappings getNamespaceMappings() {
        return this.mainIndex.getNamespaceMappings();
    }

    public Analyzer getTextAnalyzer() {
        return this.mainIndex.getTextAnalyzer();
    }

    public Similarity getSimilarity() {
        return this.mainIndex.getSimilarity();
    }

    public DirectoryManager getDirectoryManager() {
        try {
            Class<?> clazz = Class.forName(this.getDirectoryManagerClass());
            if (!DirectoryManager.class.isAssignableFrom(clazz)) {
                throw new IOException(this.getDirectoryManagerClass() + " is not a DirectoryManager implementation");
            }
            DirectoryManager df = (DirectoryManager)clazz.newInstance();
            df.init((SearchIndex)this);
            return df;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RedoLogFactory getRedoLogFactory() {
        return this.mainIndex.getRedoLogFactory();
    }

    public boolean getUseCompoundFile() {
        return this.mainIndex.getUseCompoundFile();
    }

    public int getMinMergeDocs() {
        return this.mainIndex.getMinMergeDocs();
    }

    public int getMaxExtractLength() {
        return this.mainIndex.getMaxExtractLength();
    }

    public int getMaxFieldLength() {
        return this.mainIndex.getMaxFieldLength();
    }

    public long getMaxHistoryAge() {
        return this.mainIndex.getMaxHistoryAge();
    }

    public long getMaxVolatileIndexSize() {
        return this.mainIndex.getMaxVolatileIndexSize();
    }

    public int getMergeFactor() {
        return this.mainIndex.getMergeFactor();
    }

    public int getMaxMergeDocs() {
        return this.mainIndex.getMaxMergeDocs();
    }

    public Parser getParser() {
        return this.mainIndex.getParser();
    }

    public String getPath() {
        if (this.path == null) {
            this.path = this.mainIndex.getPath() + ".new." + System.currentTimeMillis();
        }
        return this.path;
    }

    public Path getRelativePath(NodeState nodeState, PropertyState propState) throws RepositoryException, ItemStateException {
        return this.mainIndex.getRelativePath(nodeState, propState);
    }

    public String getSpellCheckerClass() {
        return this.mainIndex.getSpellCheckerClass();
    }

    public boolean getSupportHighlighting() {
        return this.mainIndex.getSupportHighlighting();
    }

    public int getTermInfosIndexDivisor() {
        return this.mainIndex.getTermInfosIndexDivisor();
    }

    public int getVolatileIdleTime() {
        return this.mainIndex.getVolatileIdleTime();
    }

    public String getDirectoryManagerClass() {
        return this.mainIndex.getDirectoryManagerClass();
    }

    public int getCacheSize() {
        return this.mainIndex.getCacheSize();
    }

    public int getBufferSize() {
        return this.mainIndex.getBufferSize();
    }

    public QueryHandlerContext getContext() {
        return this.mainIndex.getContext();
    }

    public OnWorkspaceInconsistency getOnWorkspaceInconsistencyHandler() {
        return OnWorkspaceInconsistency.LOG;
    }

    class DelayedIndexUpdate {
        Iterator<NodeId> remove;
        Iterator<NodeState> add;

        DelayedIndexUpdate(Iterator<NodeId> remove, Iterator<NodeState> add) {
            this.remove = remove;
            this.add = add;
        }
    }
}

