/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jackrabbit.core.query.lucene.AnalyzerRegistry;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IndexingConfiguration;
import org.apache.jackrabbit.core.query.lucene.JahiaNodeIndexer;
import org.apache.lucene.analysis.ASCIIFoldingFilter;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ar.ArabicAnalyzer;
import org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.cn.ChineseAnalyzer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.fa.PersianAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.snowball.SnowballAnalyzer;
import org.apache.lucene.analysis.th.ThaiAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.util.Version;

public class LanguageCustomizingAnalyzerRegistry
implements AnalyzerRegistry<String> {
    private final Map<String, Analyzer> languageToAnalyzer = new ConcurrentHashMap<String, Analyzer>();
    private final IndexingConfiguration configuration;
    private Analyzer defaultAnalyzer;

    public LanguageCustomizingAnalyzerRegistry(IndexingConfiguration configuration) {
        this.configuration = configuration;
        this.languageToAnalyzer.put("ar", new AnalyzerWrapper((Analyzer)new ArabicAnalyzer(Version.LUCENE_30), true));
        this.languageToAnalyzer.put("br", new AnalyzerWrapper((Analyzer)new BrazilianAnalyzer(Version.LUCENE_30), true));
        this.languageToAnalyzer.put("cjk", new AnalyzerWrapper((Analyzer)new CJKAnalyzer(Version.LUCENE_30), true));
        this.languageToAnalyzer.put("cn", new AnalyzerWrapper((Analyzer)new ChineseAnalyzer(), true));
        this.languageToAnalyzer.put("cz", new AnalyzerWrapper((Analyzer)new CzechAnalyzer(Version.LUCENE_30), true));
        this.languageToAnalyzer.put("de", new AnalyzerWrapper((Analyzer)new GermanAnalyzer(Version.LUCENE_30), true));
        this.languageToAnalyzer.put("el", new AnalyzerWrapper((Analyzer)new GreekAnalyzer(Version.LUCENE_30), true));
        this.languageToAnalyzer.put("en", new AnalyzerWrapper((Analyzer)new SnowballAnalyzer(Version.LUCENE_30, "English", StopAnalyzer.ENGLISH_STOP_WORDS_SET), true));
        this.languageToAnalyzer.put("fa", new AnalyzerWrapper((Analyzer)new PersianAnalyzer(Version.LUCENE_30), true));
        this.languageToAnalyzer.put("fr", new AnalyzerWrapper((Analyzer)new FrenchAnalyzer(Version.LUCENE_30), true));
        this.languageToAnalyzer.put("nl", new AnalyzerWrapper((Analyzer)new DutchAnalyzer(Version.LUCENE_30), true));
        this.languageToAnalyzer.put("ru", new AnalyzerWrapper((Analyzer)new RussianAnalyzer(Version.LUCENE_30), true));
        this.languageToAnalyzer.put("th", new AnalyzerWrapper((Analyzer)new ThaiAnalyzer(Version.LUCENE_30), true));
    }

    public Analyzer getAnalyzerFor(Document document) {
        String key = this.getKeyFor(document);
        return this.getAnalyzer(key);
    }

    public String getKeyFor(Document document) {
        Field field;
        if (document != null && (field = document.getField(JahiaNodeIndexer.TRANSLATION_LANGUAGE)) != null) {
            return field.stringValue();
        }
        return null;
    }

    public Analyzer getAnalyzer(String key) {
        if (key != null) {
            Analyzer analyzer = this.languageToAnalyzer.get(key);
            if (analyzer == null) {
                int underscore = key.indexOf(95);
                if (underscore >= 0 && (analyzer = this.languageToAnalyzer.get(key.substring(0, underscore))) != null) {
                    this.languageToAnalyzer.put(key, analyzer);
                    return analyzer;
                }
            } else {
                return analyzer;
            }
        }
        return null;
    }

    public boolean acceptKey(Object key) {
        return key instanceof String;
    }

    void addAnalyzer(String key, Analyzer analyzer, Boolean useASCIIFoldingFilter) {
        this.languageToAnalyzer.put(key, new AnalyzerWrapper(analyzer, useASCIIFoldingFilter));
    }

    public void setDefaultAnalyzer(Analyzer defaultAnalyzer) {
        this.defaultAnalyzer = defaultAnalyzer;
    }

    private class AnalyzerWrapper
    extends Analyzer {
        private final Analyzer wrappee;
        private final boolean useFilter;

        public AnalyzerWrapper(Analyzer wrappee, Boolean useASCIIFoldingFilter) {
            this.wrappee = wrappee;
            this.useFilter = useASCIIFoldingFilter != null && useASCIIFoldingFilter != false;
        }

        public TokenStream tokenStream(String fieldName, Reader reader) {
            return this.getAnalyzer(fieldName).tokenStream(fieldName, reader);
        }

        public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
            return this.getAnalyzer(fieldName).reusableTokenStream(fieldName, reader);
        }

        private Wrapper getAnalyzer(String fieldName) {
            Analyzer analyzer = LanguageCustomizingAnalyzerRegistry.this.configuration.getPropertyAnalyzer(fieldName);
            boolean filter = false;
            if (analyzer == null) {
                if (FieldNames.isFulltextField((String)fieldName)) {
                    analyzer = this.wrappee;
                    filter = this.useFilter;
                } else {
                    analyzer = LanguageCustomizingAnalyzerRegistry.this.defaultAnalyzer;
                }
            }
            return new Wrapper(analyzer, filter);
        }

        private class Wrapper
        extends Analyzer {
            private final Analyzer wrappee;
            private final boolean useFilter;

            private Wrapper(Analyzer wrappee, boolean useFilter) {
                this.wrappee = wrappee;
                this.useFilter = useFilter;
            }

            public TokenStream tokenStream(String fieldName, Reader reader) {
                TokenStream stream = this.wrappee.tokenStream(fieldName, reader);
                return this.filterIfNeeded(stream);
            }

            public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
                TokenStream stream = this.wrappee.reusableTokenStream(fieldName, reader);
                return this.filterIfNeeded(stream);
            }

            private TokenStream filterIfNeeded(TokenStream stream) {
                return this.useFilter ? new ASCIIFoldingFilter(stream) : stream;
            }
        }
    }
}

