/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import javax.security.auth.Subject;
import org.apache.commons.collections.map.LRUMap;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AbstractAccessControlManager;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.JahiaJCRPathWrapperImpl;
import org.apache.jackrabbit.core.security.JahiaPrivilegeRegistry;
import org.apache.jackrabbit.core.security.JahiaSystemSession;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.namespace.SessionNamespaceResolver;
import org.jahia.jaas.JahiaPrincipal;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.security.AccessManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaAccessManager
extends AbstractAccessControlManager
implements AccessManager,
AccessControlManager {
    private static final Logger logger = LoggerFactory.getLogger(JahiaAccessManager.class);
    private static final Subject SYSTEM_SUBJECT = new Subject(true, new HashSet<SystemPrincipal>(Arrays.asList(new SystemPrincipal())), Collections.EMPTY_SET, Collections.EMPTY_SET);
    protected Subject subject;
    protected HierarchyManager hierMgr;
    protected NamePathResolver resolver;
    private JahiaPrivilegeRegistry privilegeRegistry;
    private boolean initialized = false;
    protected String workspaceName;
    protected JahiaPrincipal jahiaPrincipal = null;
    private JahiaSystemSession securitySession;
    private RepositoryContext repositoryContext;
    private WorkspaceConfig workspaceConfig;
    private Map<String, Boolean> pathPermissionCache = null;
    private Map<Object, AccessManagerUtils.CompiledAcl> compiledAcls = new HashMap<Object, AccessManagerUtils.CompiledAcl>();
    private boolean isAliased = false;
    private DefaultNamePathResolver pr;

    public static String getPrivilegeName(String privilegeName, String workspace) {
        return AccessManagerUtils.getPrivilegeName(privilegeName, workspace);
    }

    public static void setDeniedPaths(Collection<String> denied) {
        AccessManagerUtils.setDeniedPaths(denied);
    }

    public JahiaAccessManager() {
        AccessManagerUtils.initCaches();
    }

    public void init(AMContext amContext) throws AccessDeniedException, Exception {
        this.init(amContext, null, null, null, null);
    }

    public void init(AMContext amContext, AccessControlProvider acProvider, WorkspaceAccessManager wspAccessManager) throws AccessDeniedException, Exception {
        this.init(amContext, null, null, null, null);
    }

    public JahiaSystemSession getSecuritySession() throws RepositoryException {
        if (this.securitySession != null) {
            return this.securitySession;
        }
        this.securitySession = new JahiaSystemSession(this.repositoryContext, SYSTEM_SUBJECT, this.workspaceConfig);
        return this.securitySession;
    }

    public boolean isSystemPrincipal() {
        return AccessManagerUtils.isSystemPrincipal(this.jahiaPrincipal);
    }

    public void init(AMContext context, AccessControlProvider acProvider, WorkspaceAccessManager wspAccessManager, RepositoryContext repositoryContext, WorkspaceConfig workspaceConfig) throws AccessDeniedException, Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        this.pathPermissionCache = Collections.synchronizedMap(new LRUMap(SettingsBean.getInstance().getAccessManagerPathPermissionCacheMaxSize()));
        this.subject = context.getSubject();
        this.resolver = context.getNamePathResolver();
        this.hierMgr = context.getHierarchyManager();
        this.workspaceName = context.getWorkspaceName();
        this.repositoryContext = repositoryContext;
        this.workspaceConfig = workspaceConfig;
        this.privilegeRegistry = new JahiaPrivilegeRegistry(context.getSession().getWorkspace().getNamespaceRegistry());
        Set<JahiaPrincipal> principals = this.subject.getPrincipals(JahiaPrincipal.class);
        if (!principals.isEmpty()) {
            this.jahiaPrincipal = principals.iterator().next();
        }
        SessionNamespaceResolver nr = new SessionNamespaceResolver((Session)this.getSecuritySession());
        this.pr = new DefaultNamePathResolver((NamespaceResolver)nr, true);
        this.initialized = true;
    }

    public void close() throws Exception {
        if (this.securitySession != null) {
            this.securitySession.logout();
        }
    }

    public void checkPermission(ItemId id, int actions) throws AccessDeniedException, ItemNotFoundException, RepositoryException {
        if (!this.isGranted(id, actions)) {
            throw new AccessDeniedException("Not sufficient privileges for permissions : " + actions + " on " + id);
        }
    }

    public void checkPermission(Path path, int permissions) throws AccessDeniedException, RepositoryException {
        if (!this.isGranted(path, permissions)) {
            throw new AccessDeniedException("Not sufficient privileges for permissions : " + permissions + " on " + path + " [" + AccessManagerUtils.deniedPathes.get() + "]");
        }
    }

    protected void checkPermission(String absPath, int permission) throws AccessDeniedException, PathNotFoundException, RepositoryException {
        this.checkValidNodePath(absPath);
        this.checkPermission(this.resolver.getQPath(absPath), permission);
    }

    public boolean hasPrivileges(String absPath, Set<Principal> principals, Privilege[] privileges) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkValidNodePath(absPath);
        this.checkPermission(absPath, 32);
        if (privileges == null || privileges.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("No privileges passed -> allowed.");
            }
            return true;
        }
        int privs = PrivilegeRegistry.getBits((Privilege[])privileges);
        Path p = this.resolver.getQPath(absPath);
        return this.isGranted(p, privs);
    }

    protected void checkInitialized() throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
    }

    protected PrivilegeManager getPrivilegeManager() throws RepositoryException {
        return new PrivilegeManager(){

            public Privilege[] getRegisteredPrivileges() throws RepositoryException {
                return JahiaPrivilegeRegistry.getRegisteredPrivileges();
            }

            public Privilege getPrivilege(String privilegeName) throws AccessControlException, RepositoryException {
                return JahiaAccessManager.this.privilegeRegistry.getPrivilege(privilegeName, JahiaAccessManager.this.workspaceName);
            }

            public Privilege registerPrivilege(String privilegeName, boolean isAbstract, String[] declaredAggregateNames) throws AccessDeniedException, NamespaceException, RepositoryException {
                return null;
            }
        };
    }

    public void checkRepositoryPermission(int permissions) throws AccessDeniedException, RepositoryException {
        if (!this.isGranted(PathFactoryImpl.getInstance().getRootPath(), permissions)) {
            throw new AccessDeniedException("Access denied");
        }
    }

    protected void checkValidNodePath(String absPath) throws PathNotFoundException, RepositoryException {
        this.checkValidNodePath(this.resolver.getQPath(absPath));
    }

    protected void checkValidNodePath(Path p) throws RepositoryException {
        if (!p.isAbsolute()) {
            throw new RepositoryException("Absolute path expected.");
        }
        if (this.hierMgr.resolveNodePath(p) == null) {
            throw new PathNotFoundException("No such node " + p);
        }
    }

    public AccessControlPolicy[] getEffectivePolicies(Set<Principal> principals) throws AccessDeniedException, AccessControlException, UnsupportedRepositoryOperationException, RepositoryException {
        return new AccessControlPolicy[0];
    }

    public Privilege[] getPrivileges(String absPath, Set<Principal> principals) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        return new Privilege[0];
    }

    public boolean isGranted(ItemId id, int actions) throws ItemNotFoundException, RepositoryException {
        if (this.isSystemPrincipal() && AccessManagerUtils.deniedPathes.get() == null) {
            return true;
        }
        HashSet<String> perm = new HashSet<String>();
        if ((actions & 1) == 1) {
            perm.add(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}read", this.workspaceName));
        }
        if ((actions & 2) == 2) {
            if (id.denotesNode()) {
                perm.add(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}addChildNodes", this.workspaceName));
            } else {
                perm.add(JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", this.workspaceName));
            }
        }
        if ((actions & 4) == 4) {
            perm.add(id.denotesNode() ? JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}removeChildNodes", this.workspaceName) : JahiaAccessManager.getPrivilegeName("{http://www.jcp.org/jcr/1.0}removeNode", this.workspaceName));
        }
        Path path = this.hierMgr.getPath(id);
        return this.isGranted(path, perm);
    }

    public boolean isGranted(Path absPath, int permissions) throws RepositoryException {
        if (this.isSystemPrincipal() && AccessManagerUtils.deniedPathes.get() == null) {
            return true;
        }
        HashSet<String> privs = new HashSet<String>();
        if (permissions == 4 || permissions == 2 || permissions == 16) {
            String fullPath = this.pr.getJCRPath(absPath);
            if (permissions == 4 && (fullPath.contains("j:translation_") || fullPath.contains("j:referenceInField_"))) {
                permissions = 2;
            } else {
                absPath = absPath.getAncestor(1);
            }
        }
        for (Privilege privilege : this.privilegeRegistry.getPrivileges(permissions, this.workspaceName)) {
            privs.add(privilege.getName());
        }
        return this.isGranted(absPath, privs);
    }

    public boolean isGranted(Path absPath, Set<String> permissions) throws RepositoryException {
        JahiaJCRPathWrapperImpl pathImpl = new JahiaJCRPathWrapperImpl(absPath.getCanonicalPath(), this.pr, this.getSecuritySession());
        return AccessManagerUtils.isGranted(pathImpl, permissions, (Session)this.getSecuritySession(), this.jahiaPrincipal, this.workspaceName, this.isAliased, this.pathPermissionCache, this.compiledAcls, this.privilegeRegistry);
    }

    public boolean isGranted(Path parentPath, Name childName, int permissions) throws RepositoryException {
        Path p = PathFactoryImpl.getInstance().create(parentPath, childName, true);
        return this.isGranted(p, permissions);
    }

    public boolean canRead(Path path, ItemId itemId) throws RepositoryException {
        if (path != null) {
            return this.isGranted(path, 1);
        }
        if (itemId != null) {
            return this.isGranted(itemId, 1);
        }
        return false;
    }

    public boolean canAccess(String workspaceName) throws RepositoryException {
        return true;
    }

    public Set<Privilege> getPermissionsInRole(String role) throws RepositoryException {
        return AccessManagerUtils.getPermissionsInRole(role, this.privilegeRegistry);
    }

    public boolean matchPermission(Set<String> permissions, String role) throws RepositoryException {
        return AccessManagerUtils.matchPermission(permissions, role, this.isAliased, this.privilegeRegistry, this.workspaceName);
    }

    public boolean hasPrivileges(String absPath, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
        return this.hasPrivileges(this.resolver.getQPath(absPath), privileges);
    }

    public boolean hasPrivileges(Path absPath, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
        this.checkInitialized();
        this.checkValidNodePath(absPath);
        if (privileges == null || privileges.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("No privileges passed -> allowed.");
            }
            return true;
        }
        HashSet<String> privs = new HashSet<String>();
        for (Privilege privilege : privileges) {
            privs.add(privilege.getName());
        }
        return this.isGranted(absPath, privs);
    }

    public Privilege[] getPrivileges(String absPath) throws PathNotFoundException, RepositoryException {
        if (this.isAdmin(null)) {
            return this.getSupportedPrivileges(absPath);
        }
        return AccessManagerUtils.getPrivileges(absPath, this.workspaceName, this.jahiaPrincipal, this.privilegeRegistry);
    }

    public AccessControlPolicy[] getEffectivePolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        return new AccessControlPolicy[0];
    }

    public void setAliased(boolean aliased) {
        this.isAliased = aliased;
    }

    public boolean isAdmin(String siteKey) {
        return AccessManagerUtils.isAdmin(siteKey, this.jahiaPrincipal);
    }

    public Set<String> getRoles(String absPath) throws PathNotFoundException, RepositoryException {
        return AccessManagerUtils.getRoles(absPath, this.workspaceName, this.jahiaPrincipal);
    }

    public static void flushPrivilegesInRoles() {
        AccessManagerUtils.flushPrivilegesInRoles();
    }

    public static void flushMatchingPermissions() {
        AccessManagerUtils.flushMatchingPermissions();
    }
}

