/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.id.IdentifierGenerator;
import org.apache.commons.id.IdentifierGeneratorFactory;
import org.apache.jackrabbit.core.security.AnonymousPrincipal;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.authentication.CredentialsCallback;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.jahia.jaas.JahiaPrincipal;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaLoginModule
implements LoginModule {
    private static final Logger logger = LoggerFactory.getLogger(JahiaLoginModule.class);
    public static final String SYSTEM = " system ";
    public static final String GUEST = " guest ";
    public static final String REALM_ATTRIBUTE = "org.jahia.realm";
    private static IdentifierGenerator idGen = IdentifierGeneratorFactory.newInstance().sessionIdGenerator();
    private static Map<String, Token> systemPass = new ConcurrentHashMap<String, Token>();
    private Subject subject;
    private Set<Principal> principals = new HashSet<Principal>();
    private CallbackHandler callbackHandler;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        try {
            String name = null;
            char[] pass = null;
            String realm = null;
            String impersonatorName = null;
            char[] impersonatorPass = null;
            Callback[] callbacks = new Callback[]{new CredentialsCallback()};
            this.callbackHandler.handle(callbacks);
            Credentials credentials = ((CredentialsCallback)callbacks[0]).getCredentials();
            if (credentials instanceof SimpleCredentials) {
                SimpleCredentials simpleCredentials = (SimpleCredentials)credentials;
                name = simpleCredentials.getUserID();
                pass = simpleCredentials.getPassword();
                realm = (String)simpleCredentials.getAttribute(REALM_ATTRIBUTE);
                SimpleCredentials impersonatorCredentials = (SimpleCredentials)simpleCredentials.getAttribute("org.apache.jackrabbit.core.security.impersonator");
                if (impersonatorCredentials != null) {
                    impersonatorName = impersonatorCredentials.getUserID();
                    impersonatorPass = impersonatorCredentials.getPassword();
                }
            } else {
                callbacks = new Callback[]{new NameCallback("name?"), new PasswordCallback("pass?", false)};
                this.callbackHandler.handle(callbacks);
                name = ((NameCallback)callbacks[0]).getName();
                pass = ((PasswordCallback)callbacks[1]).getPassword();
            }
            if (name != null) {
                Token token;
                String key;
                if (SYSTEM.equals(name)) {
                    key = new String(pass);
                    token = JahiaLoginModule.removeToken(name, key);
                    if (token != null) {
                        this.principals.add((Principal)new JahiaPrincipal(SYSTEM, realm, true, false));
                        this.principals.add((Principal)new SystemPrincipal());
                    }
                } else if (name.startsWith(SYSTEM)) {
                    key = new String(pass);
                    token = JahiaLoginModule.removeToken(name, key);
                    if (token != null) {
                        this.principals.add((Principal)new JahiaPrincipal(name.substring(SYSTEM.length()), realm, true, false));
                        this.principals.add((Principal)new SystemPrincipal());
                    }
                } else if (GUEST.equals(name)) {
                    this.principals.add((Principal)new JahiaPrincipal(GUEST, null, false, true));
                    this.principals.add((Principal)new AnonymousPrincipal());
                } else {
                    key = new String(impersonatorPass != null ? impersonatorPass : pass);
                    String lookupUser = impersonatorName != null ? impersonatorName : name;
                    Token token2 = JahiaLoginModule.removeToken(lookupUser, key);
                    boolean ok = token2 != null;
                    JCRUserNode user = null;
                    if (!ok) {
                        user = JahiaUserManagerService.getInstance().lookupUser(lookupUser);
                        boolean bl = ok = user != null && user.verifyPassword(key);
                    }
                    if (ok && impersonatorName != null) {
                        if (user == null) {
                            user = JahiaUserManagerService.getInstance().lookupUser(lookupUser);
                        }
                        if (user == null || !user.isRoot()) {
                            throw new FailedLoginException("Only root user credentials can be used as an impersonator.");
                        }
                        if (!JahiaUserManagerService.getInstance().userExists(name)) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("User {} is not known, a the guest will be used instead", (Object)name, (Object)impersonatorName);
                            }
                            this.principals.add((Principal)new JahiaPrincipal(GUEST, null, false, true));
                            ok = false;
                        }
                    }
                    if (ok) {
                        this.principals.add((Principal)new JahiaPrincipal(name, realm, false, false));
                        if (realm == null && JahiaGroupManagerService.getInstance().isAdminMember(name, null, null)) {
                            this.principals.add((Principal)new AdminPrincipal(name));
                        }
                    }
                }
                if (this.principals.isEmpty()) {
                    throw new FailedLoginException();
                }
            }
        }
        catch (UnsupportedCallbackException name) {
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return !this.principals.isEmpty();
    }

    public static Token removeToken(String name, String key) {
        if (systemPass.get(key) != null && JahiaLoginModule.systemPass.get((Object)key).username.equals(name)) {
            return systemPass.remove(key);
        }
        return null;
    }

    public static Token getToken(String name, String key) {
        if (systemPass.get(key) != null && JahiaLoginModule.systemPass.get((Object)key).username.equals(name)) {
            return systemPass.get(key);
        }
        return null;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.principals.isEmpty()) {
            return false;
        }
        this.subject.getPrincipals().addAll(this.principals);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.principals.isEmpty()) {
            return false;
        }
        this.logout();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        return true;
    }

    private static String getSystemPass(String user, List<String> deniedPathes) {
        String p = idGen.nextIdentifier().toString();
        systemPass.put(p, new Token(user, deniedPathes));
        return p;
    }

    public static Credentials getSystemCredentials() {
        return JahiaLoginModule.getSystemCredentials(null, null, null);
    }

    @Deprecated
    public static Credentials getSystemCredentials(String username) {
        logger.warn("Getting system credentials with empty realm for " + username);
        return JahiaLoginModule.getSystemCredentials(username, null, null);
    }

    public static Credentials getSystemCredentials(String username, String realm) {
        return JahiaLoginModule.getSystemCredentials(username, realm, null);
    }

    @Deprecated
    public static Credentials getSystemCredentials(String username, List<String> deniedPathes) {
        logger.warn("Getting system credentials with empty realm for " + username);
        return JahiaLoginModule.getSystemCredentials(username, null, deniedPathes);
    }

    public static Credentials getSystemCredentials(String username, String realm, List<String> deniedPathes) {
        if (username == null) {
            return new SimpleCredentials(SYSTEM, JahiaLoginModule.getSystemPass(SYSTEM, deniedPathes).toCharArray());
        }
        String userID = SYSTEM + username;
        SimpleCredentials credentials = new SimpleCredentials(userID, JahiaLoginModule.getSystemPass(userID, deniedPathes).toCharArray());
        credentials.setAttribute(REALM_ATTRIBUTE, (Object)realm);
        return credentials;
    }

    public static Credentials getGuestCredentials() {
        return new SimpleCredentials(GUEST, new char[0]);
    }

    @Deprecated
    public static Credentials getCredentials(String username) {
        logger.warn("Getting credentials with empty realm for " + username);
        return JahiaLoginModule.getCredentials(username, null, null);
    }

    public static Credentials getCredentials(String username, String realm) {
        return JahiaLoginModule.getCredentials(username, realm, null);
    }

    @Deprecated
    public static Credentials getCredentials(String username, List<String> deniedPathes) {
        logger.warn("Getting credentials with empty realm for " + username);
        return JahiaLoginModule.getCredentials(username, null, deniedPathes);
    }

    public static Credentials getCredentials(String username, String realm, List<String> deniedPathes) {
        String userID = username;
        SimpleCredentials credentials = new SimpleCredentials(userID, JahiaLoginModule.getSystemPass(userID, deniedPathes).toCharArray());
        credentials.setAttribute(REALM_ATTRIBUTE, (Object)realm);
        return credentials;
    }

    public static class Token {
        public String username;
        public List<String> deniedPath;

        Token(String username, List<String> deniedPath) {
            this.username = username;
            this.deniedPath = deniedPath;
        }
    }
}

