/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.content.server;

import com.google.gwt.safehtml.shared.UriUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.LimitedInputStream;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.IOUtils;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.content.server.UploadedPendingFile;
import org.jahia.ajax.gwt.helper.VersioningHelper;
import org.jahia.ajax.gwt.helper.ZipHelper;
import org.jahia.bin.SessionNamedDataStorage;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRVersionService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GWTFileManagerUploadServlet
extends HttpServlet {
    private static final int OK = 0;
    private static final int EXISTS = 1;
    private static final int READONLY = 2;
    private static final int BAD_LOCATION = 3;
    private static final int UNKNOWN_ERROR = 9;
    private static final Logger logger = LoggerFactory.getLogger(GWTFileManagerUploadServlet.class);
    private static final long serialVersionUID = 1048509772346464862L;
    private volatile SessionNamedDataStorage<UploadedPendingFile> fileStorage;

    private static long getContentLength(FileItemHeaders pHeaders) {
        try {
            return Long.parseLong(pHeaders.getHeader("Content-length"));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Iterator i$;
        ArrayList<String> pathsToUnzip;
        JahiaUser user;
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        SettingsBean settingsBean = SettingsBean.getInstance();
        final long fileSizeLimit = settingsBean.getJahiaFileUploadMaxSize();
        upload.setHeaderEncoding("UTF-8");
        HashMap<String, FileItem> uploads = new HashMap<String, FileItem>();
        String location = null;
        String type = null;
        boolean unzip = false;
        response.setContentType("text/plain; charset=" + settingsBean.getCharacterEncoding());
        PrintWriter printWriter = response.getWriter();
        try {
            FileItemIterator itemIterator = upload.getItemIterator(request);
            FileUploadBase.FileSizeLimitExceededException sizeLimitExceededException = null;
            while (itemIterator.hasNext()) {
                String name;
                final FileItemStream item = itemIterator.next();
                if (sizeLimitExceededException != null) continue;
                FileItem fileItem = factory.createItem(item.getFieldName(), item.getContentType(), item.isFormField(), item.getName());
                long contentLength = GWTFileManagerUploadServlet.getContentLength(item.getHeaders());
                if (fileSizeLimit > 0L && contentLength != -1L && contentLength > fileSizeLimit) {
                    throw new FileUploadBase.FileSizeLimitExceededException("The field " + item.getFieldName() + " exceeds its maximum permitted size of " + fileSizeLimit + " bytes.", contentLength, fileSizeLimit);
                }
                InputStream itemStream = item.openStream();
                InputStream inputStream = null;
                try {
                    InputStream inputStream2 = fileSizeLimit > 0L ? new LimitedInputStream(itemStream, fileSizeLimit){

                        protected void raiseError(long pSizeMax, long pCount) throws IOException {
                            throw new FileUploadBase.FileUploadIOException((FileUploadException)new FileUploadBase.FileSizeLimitExceededException("The field " + item.getFieldName() + " exceeds its maximum permitted size of " + fileSizeLimit + " bytes.", pCount, pSizeMax));
                        }
                    } : itemStream;
                    Streams.copy((InputStream)inputStream2, (OutputStream)fileItem.getOutputStream(), (boolean)true);
                    IOUtils.closeQuietly((InputStream)inputStream2);
                }
                catch (FileUploadBase.FileUploadIOException e) {
                    if (!(e.getCause() instanceof FileUploadBase.FileSizeLimitExceededException)) throw e;
                    if (sizeLimitExceededException == null) {
                        sizeLimitExceededException = (FileUploadBase.FileSizeLimitExceededException)e.getCause();
                    }
                }
                finally {
                    IOUtils.closeQuietly(inputStream);
                }
                if ("unzip".equals(fileItem.getFieldName())) {
                    unzip = true;
                    continue;
                }
                if ("uploadLocation".equals(fileItem.getFieldName())) {
                    location = fileItem.getString("UTF-8");
                    continue;
                }
                if ("asyncupload".equals(fileItem.getFieldName())) {
                    name = fileItem.getName();
                    if (name.trim().length() > 0) {
                        uploads.put(this.extractFileName(name, uploads), fileItem);
                    }
                    type = "async";
                    continue;
                }
                if (fileItem.isFormField() || !fileItem.getFieldName().startsWith("uploadedFile")) continue;
                name = fileItem.getName();
                if (name.trim().length() > 0) {
                    uploads.put(this.extractFileName(name, uploads), fileItem);
                }
                type = "sync";
            }
            if (sizeLimitExceededException != null) {
                throw sizeLimitExceededException;
            }
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            printWriter.write("UPLOAD-SIZE-ISSUE: " + this.getSizeLimitErrorMessage(fileSizeLimit, e, request) + "\n");
            return;
        }
        catch (FileUploadBase.FileUploadIOException e) {
            if (e.getCause() != null && e.getCause() instanceof FileUploadBase.FileSizeLimitExceededException) {
                printWriter.write("UPLOAD-SIZE-ISSUE: " + this.getSizeLimitErrorMessage(fileSizeLimit, (FileUploadBase.FileSizeLimitExceededException)e.getCause(), request) + "\n");
                return;
            }
            logger.error("UPLOAD-ISSUE", (Throwable)e);
            printWriter.write("UPLOAD-ISSUE: " + e.getLocalizedMessage() + "\n");
            return;
        }
        catch (FileUploadException e) {
            logger.error("UPLOAD-ISSUE", (Throwable)e);
            printWriter.write("UPLOAD-ISSUE: " + e.getLocalizedMessage() + "\n");
            return;
        }
        if (type == null || type.equals("sync")) {
            response.setContentType("text/plain");
            user = (JahiaUser)request.getSession().getAttribute("org.jahia.usermanager.jahiauser");
            pathsToUnzip = new ArrayList<String>();
            i$ = uploads.keySet().iterator();
        } else {
            response.setContentType("text/html");
            Iterator i$2 = uploads.values().iterator();
            while (i$2.hasNext()) {
                FileItem fileItem = (FileItem)i$2.next();
                this.storeUploadedFile(request.getSession().getId(), fileItem);
                printWriter.write("<html><body>");
                printWriter.write("<div id=\"uploaded\" key=\"" + fileItem.getName() + "\" name=\"" + fileItem.getName() + "\"></div>\n");
                printWriter.write("</body></html>");
            }
            return;
        }
        block24: while (i$.hasNext()) {
            String fileName = (String)i$.next();
            FileItem fileItem = (FileItem)uploads.get(fileName);
            try {
                StringBuilder name = new StringBuilder(fileName);
                int saveResult = this.saveToJcr(user, fileItem, location, name);
                switch (saveResult) {
                    case 0: {
                        if (unzip && fileName.toLowerCase().endsWith(".zip")) {
                            pathsToUnzip.add(location + "/" + name.toString());
                        }
                        printWriter.write("OK: " + UriUtils.encode((String)name.toString()) + "\n");
                        continue block24;
                    }
                    case 1: {
                        this.storeUploadedFile(request.getSession().getId(), fileItem);
                        printWriter.write("EXISTS: " + UriUtils.encode((String)fileItem.getFieldName()) + " " + UriUtils.encode((String)fileItem.getName()) + " " + UriUtils.encode((String)fileName) + "\n");
                        continue block24;
                    }
                    case 2: {
                        printWriter.write("READONLY: " + UriUtils.encode((String)fileItem.getFieldName()) + "\n");
                        continue block24;
                    }
                }
                printWriter.write("UPLOAD-FAILED: " + UriUtils.encode((String)fileItem.getFieldName()) + "\n");
            }
            catch (IOException e) {
                logger.error("Upload failed for file \n", (Throwable)e);
            }
            finally {
                fileItem.delete();
            }
        }
        if (!unzip) return;
        if (pathsToUnzip.size() <= 0) return;
        try {
            ZipHelper zip = ZipHelper.getInstance();
            zip.unzip(pathsToUnzip, true, JCRSessionFactory.getInstance().getCurrentUserSession(), (Locale)request.getSession().getAttribute("org.jahia.services.multilang.uilocale"));
            return;
        }
        catch (RepositoryException e) {
            logger.error("Auto-unzipping failed", (Throwable)e);
            return;
        }
        catch (GWTJahiaServiceException e) {
            logger.error("Auto-unzipping failed", (Throwable)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeUploadedFile(String sessionID, final FileItem fileItem) {
        try (final BufferedInputStream contentStream = new BufferedInputStream(fileItem.getInputStream());){
            this.getFileStorage().put(sessionID, fileItem.getName(), new UploadedPendingFile(){

                @Override
                public String getContentType() {
                    return fileItem.getContentType();
                }

                @Override
                public InputStream getContentStream() {
                    return contentStream;
                }

                @Override
                public void close() {
                }
            });
        }
        catch (IOException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    private String getSizeLimitErrorMessage(long fileSizeLimit, FileUploadBase.FileSizeLimitExceededException e, HttpServletRequest request) {
        Locale locale = (Locale)request.getSession().getAttribute("org.jahia.services.multilang.uilocale");
        if (locale == null) {
            locale = (Locale)request.getSession().getAttribute("org.jahia.services.multilang.currentlocale");
        }
        if (logger.isDebugEnabled()) {
            logger.warn("File upload exceeding limit of " + fileSizeLimit + " bytes", (Throwable)e);
        } else {
            logger.warn("File upload exceeding limit of {} bytes", (Object)fileSizeLimit);
        }
        return Messages.getInternalWithArguments("fileSizeError.label", "File upload exceeding limit of {0} bytes", locale, fileSizeLimit);
    }

    private String extractFileName(String rawFileName, Map<String, FileItem> uploads) {
        int und;
        String basename = rawFileName.indexOf("\\") >= 0 ? rawFileName.substring(rawFileName.lastIndexOf("\\") + 1) : (rawFileName.indexOf("/") >= 0 ? rawFileName.substring(rawFileName.lastIndexOf("/") + 1) : rawFileName);
        int i = 1;
        String name = basename;
        int dot = basename.lastIndexOf(46);
        String ext = "";
        if (dot > 0) {
            ext = basename.substring(dot);
            basename = basename.substring(0, dot);
        }
        if ((und = basename.lastIndexOf(45)) > -1 && basename.substring(und + 1).matches("[0-9]+")) {
            basename = basename.substring(0, und);
        }
        while (uploads.containsKey(name)) {
            name = basename + "-" + i++ + ext;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int saveToJcr(JahiaUser user, FileItem item, String location, StringBuilder name) throws IOException {
        JCRNodeWrapper locationFolder;
        String filename = name.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("item : " + item);
            logger.debug("destination : " + location);
            logger.debug("filename : " + filename);
            logger.debug("size : " + item.getSize());
        }
        if (item == null || location == null || filename == null) {
            return 9;
        }
        try {
            locationFolder = JCRSessionFactory.getInstance().getCurrentUserSession().getNode(location);
        }
        catch (RepositoryException e) {
            logger.error(e.toString(), (Throwable)e);
            return 3;
        }
        if (!locationFolder.hasPermission("jcr:addChildNodes") || locationFolder.isLocked()) {
            logger.debug("destination is not writable for user " + user.getName());
            return 2;
        }
        try {
            if (locationFolder.hasNode(JCRContentUtils.escapeLocalNodeName(filename))) {
                return 1;
            }
            InputStream is = item.getInputStream();
            try {
                boolean versioningAvailable = false;
                if (locationFolder.getProvider().isVersioningAvailable()) {
                    versioningAvailable = true;
                }
                if (versioningAvailable) {
                    locationFolder.getSession().checkout(locationFolder);
                }
                JCRNodeWrapper node = locationFolder.uploadFile(filename, is, JCRContentUtils.getMimeType(filename, item.getContentType()));
                node.getSession().save();
                if (!node.getName().equals(filename)) {
                    name.delete(0, name.length());
                    name.append(node.getName());
                }
                if ((node = node.getSession().getNodeByIdentifier(node.getIdentifier())).getProvider().isVersioningAvailable()) {
                    node.checkpoint();
                    JCRVersionService.getInstance().addVersionLabel(node, VersioningHelper.getVersionLabel(node.getProperty("jcr:created").getDate().getTime().getTime()));
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
            locationFolder.saveSession();
        }
        catch (RepositoryException e) {
            logger.error("exception ", (Throwable)e);
            return 9;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionNamedDataStorage<UploadedPendingFile> getFileStorage() {
        if (this.fileStorage != null) {
            return this.fileStorage;
        }
        GWTFileManagerUploadServlet gWTFileManagerUploadServlet = this;
        synchronized (gWTFileManagerUploadServlet) {
            if (this.fileStorage != null) {
                return this.fileStorage;
            }
            WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            this.fileStorage = (SessionNamedDataStorage)context.getBean("UploadedPendingFileStorage");
            return this.fileStorage;
        }
    }
}

