/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import com.extjs.gxt.ui.client.data.ModelData;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeTypeIterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.value.BinaryValue;
import org.apache.jackrabbit.value.BooleanValue;
import org.apache.jackrabbit.value.DateValue;
import org.apache.jackrabbit.value.DoubleValue;
import org.apache.jackrabbit.value.LongValue;
import org.apache.jackrabbit.value.NameValue;
import org.apache.jackrabbit.value.PathValue;
import org.apache.jackrabbit.value.ReferenceValue;
import org.apache.jackrabbit.value.StringValue;
import org.apache.jackrabbit.value.WeakReferenceValue;
import org.jahia.ajax.gwt.client.data.GWTChoiceListInitializer;
import org.jahia.ajax.gwt.client.data.GWTJahiaValueDisplayBean;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeDefinition;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaPropertyDefinition;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.helper.NavigationHelper;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.JCRValueWrapperImpl;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedItemDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializerService;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentDefinitionHelper {
    private static final Logger logger = LoggerFactory.getLogger(ContentDefinitionHelper.class);
    private NavigationHelper navigation;
    private ChoiceListInitializerService choiceListInitializerService;
    private static final List<String> excludedItems = Arrays.asList("j:locktoken", "jcr:lockOwner", "jcr:lockIsDeep", "j:nodename", "j:fullpath", "j:applyAcl", "jcr:uuid", "j:fieldsinuse");
    private static final List<String> excludedTypes = Arrays.asList("nt:base", "mix:versionable", "jnt:workflow");

    public void setNavigation(NavigationHelper navigation) {
        this.navigation = navigation;
    }

    public void setChoiceListInitializerService(ChoiceListInitializerService choiceListInitializerService) {
        this.choiceListInitializerService = choiceListInitializerService;
    }

    public GWTJahiaNodeType getNodeType(String name, Locale uiLocale) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        ExtendedNodeType nodeType = null;
        try {
            nodeType = NodeTypeRegistry.getInstance().getNodeType(name);
        }
        catch (NoSuchNodeTypeException e) {
            return null;
        }
        GWTJahiaNodeType gwt = this.getGWTJahiaNodeType(nodeType, uiLocale);
        return gwt;
    }

    public List<GWTJahiaNodeType> getGWTNodeTypes(List<ExtendedNodeType> availableMixins, Locale uiLocale) {
        ArrayList<GWTJahiaNodeType> gwtMixin = new ArrayList<GWTJahiaNodeType>();
        for (ExtendedNodeType extendedNodeType : availableMixins) {
            gwtMixin.add(this.getGWTJahiaNodeType(extendedNodeType, uiLocale));
        }
        return gwtMixin;
    }

    public GWTJahiaNodeType getGWTJahiaNodeType(ExtendedNodeType nodeType, Locale uiLocale) {
        ExtendedNodeType[] nodeTypes;
        GWTJahiaNodeType gwt = new GWTJahiaNodeType();
        gwt.setName(nodeType.getName());
        gwt.setMixin(nodeType.isMixin());
        gwt.setAbstract(nodeType.isAbstract());
        gwt.setDescription(nodeType.getDescription(uiLocale));
        String label = nodeType.getLabel(uiLocale);
        gwt.setLabel(label);
        List<ExtendedItemDefinition> defs = nodeType.getItems();
        ArrayList<GWTJahiaNodeDefinition> items = new ArrayList<GWTJahiaNodeDefinition>();
        ArrayList<GWTJahiaNodeDefinition> inheritedItems = new ArrayList<GWTJahiaNodeDefinition>();
        Iterator<ExtendedItemDefinition> i$ = defs.iterator();
        while (i$.hasNext()) {
            GWTJahiaNodeDefinition item;
            ExtendedItemDefinition def;
            ExtendedItemDefinition overrideDef = def = i$.next();
            if (excludedTypes.contains(def.getDeclaringNodeType().getName()) || excludedItems.contains(def.getName())) continue;
            if (def.isNode()) {
                GWTJahiaNodeDefinition node = new GWTJahiaNodeDefinition();
                overrideDef = nodeType.getChildNodeDefinitionsAsMap().get(def.getName());
                if (overrideDef == null) {
                    overrideDef = def;
                }
                ExtendedNodeDefinition end = (ExtendedNodeDefinition)overrideDef;
                item = node;
                node.setRequiredPrimaryTypes(end.getRequiredPrimaryTypeNames());
                node.setDefaultPrimaryType(end.getDefaultPrimaryTypeName());
                node.setAllowsSameNameSiblings(end.allowsSameNameSiblings());
                node.setWorkflow(end.getWorkflow());
            } else {
                GWTJahiaPropertyDefinition prop = new GWTJahiaPropertyDefinition();
                overrideDef = nodeType.getPropertyDefinitionsAsMap().get(def.getName());
                if (overrideDef == null) {
                    overrideDef = def;
                }
                ExtendedPropertyDefinition epd = (ExtendedPropertyDefinition)overrideDef;
                prop.setInternationalized(epd.isInternationalized());
                prop.setRequiredType(epd.getRequiredType());
                prop.setMultiple(epd.isMultiple());
                String[] constr = epd.getValueConstraints();
                if (constr != null && constr.length > 0) {
                    prop.setConstrained(true);
                    prop.setValueConstraints(Arrays.asList(constr));
                    switch (prop.getRequiredType()) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 12: {
                            ContentDefinitionHelper.resolveNumericConstraint(prop);
                            break;
                        }
                        case 5: {
                            ContentDefinitionHelper.resolveDateConstraint(prop);
                            break;
                        }
                        case 1: {
                            if (prop.getValueConstraints().size() != 1 || 14 == def.getSelector()) break;
                            prop.setConstraintErrorMessage(epd.getMessage("constraint.error.message", uiLocale));
                        }
                    }
                }
                ArrayList<GWTJahiaNodePropertyValue> gwtValues = new ArrayList<GWTJahiaNodePropertyValue>();
                for (Value value : epd.getDefaultValues()) {
                    try {
                        GWTJahiaNodePropertyValue convertedValue = this.convertValue(value, epd);
                        if (convertedValue == null) continue;
                        gwtValues.add(convertedValue);
                    }
                    catch (RepositoryException e) {
                        logger.warn(e.getMessage(), (Throwable)e);
                    }
                }
                prop.setDefaultValues(gwtValues);
                item = prop;
            }
            item.setAutoCreated(overrideDef.isAutoCreated());
            item.setLabel(def.getLabel(uiLocale, nodeType));
            item.setMandatory(overrideDef.isMandatory());
            item.setHidden(overrideDef.isHidden());
            item.setName(overrideDef.getName());
            item.setProtected(overrideDef.isProtected());
            item.setDeclaringNodeType(def.getDeclaringNodeType().getName());
            item.setOverrideDeclaringNodeType(overrideDef.getDeclaringNodeType().getName());
            if ("jcr:description".equals(def.getName())) {
                item.setDeclaringNodeTypeLabel(def.getLabel(uiLocale));
            } else {
                item.setDeclaringNodeTypeLabel(def.getDeclaringNodeType().getLabel(uiLocale));
            }
            item.setSelector(overrideDef.getSelector());
            item.setSelectorOptions(new HashMap<String, String>(overrideDef.getSelectorOptions()));
            item.setDataType(overrideDef.getItemType());
            item.setTooltip(def.getTooltip(uiLocale, nodeType));
            if (def.getDeclaringNodeType().getName().equals(nodeType.getName())) {
                items.add(item);
                continue;
            }
            inheritedItems.add(item);
        }
        gwt.setItems(items);
        gwt.setInheritedItems(inheritedItems);
        ArrayList<String> supertypesNames = new ArrayList<String>();
        for (ExtendedNodeType type : nodeTypes = nodeType.getSupertypes()) {
            supertypesNames.add(type.getName());
        }
        gwt.setSuperTypes(supertypesNames);
        try {
            gwt.setIcon(JCRContentUtils.getIconWithContext(nodeType));
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return gwt;
    }

    public static void resolveNumericConstraint(GWTJahiaPropertyDefinition prop) {
        for (String valueConstraint : prop.getValueConstraints()) {
            boolean upperInclusive;
            boolean lowerInclusive;
            Double upperLimit;
            Double lowerLimit;
            block6: {
                String msg;
                lowerLimit = null;
                upperLimit = null;
                Pattern pattern = Pattern.compile("([\\(\\[]) *(\\-?\\d+\\.?\\d*)? *, *(\\-?\\d+\\.?\\d*)? *([\\)\\]])");
                Matcher matcher = pattern.matcher(valueConstraint);
                if (!matcher.matches()) continue;
                try {
                    String s = matcher.group(1);
                    lowerInclusive = s.equals("[");
                    s = matcher.group(2);
                    lowerLimit = s == null || s.length() == 0 ? null : Double.valueOf(matcher.group(2));
                    s = matcher.group(3);
                    upperLimit = s == null || s.length() == 0 ? null : Double.valueOf(matcher.group(3));
                    s = matcher.group(4);
                    upperInclusive = s.equals("]");
                    if (lowerLimit == null && upperLimit == null) {
                        msg = "'" + valueConstraint + "' is not a valid value constraint" + " format for numeric types: neither lower- nor upper-limit specified";
                        logger.debug(msg);
                        continue;
                    }
                    if (lowerLimit != null && upperLimit != null && lowerLimit > upperLimit) {
                        msg = "'" + valueConstraint + "' is not a valid value constraint format for numeric types: lower-limit exceeds upper-limit";
                        logger.debug(msg);
                    }
                    break block6;
                }
                catch (NumberFormatException nfe) {
                    msg = "'" + valueConstraint + "' is not a valid value constraint format for numeric types";
                    logger.debug(msg);
                }
                continue;
            }
            if (upperLimit != null) {
                prop.setMaxValue(Double.toString(upperInclusive ? upperLimit : (upperLimit = Double.valueOf(upperLimit - 1.0))));
            }
            if (lowerLimit == null) continue;
            prop.setMinValue(Double.toString(lowerInclusive ? lowerLimit : (lowerLimit = Double.valueOf(lowerLimit + 1.0))));
        }
    }

    public static void resolveDateConstraint(GWTJahiaPropertyDefinition prop) {
        for (String valueConstraint : prop.getValueConstraints()) {
            String msg;
            Pattern pattern = Pattern.compile("([\\(\\[]) *([0-9TZ\\.\\+-:]*)? *, *([0-9TZ\\.\\+-:]*)? *([\\)\\]])");
            Matcher matcher = pattern.matcher(valueConstraint);
            if (!matcher.matches()) continue;
            try {
                String s = matcher.group(1);
                boolean lowerInclusive = s.equals("[");
                s = matcher.group(2);
                Calendar lowerLimit = s == null || s.length() == 0 ? null : DateValue.valueOf((String)matcher.group(2)).getDate();
                s = matcher.group(3);
                Calendar upperLimit = s == null || s.length() == 0 ? null : DateValue.valueOf((String)matcher.group(3)).getDate();
                s = matcher.group(4);
                boolean upperInclusive = s.equals("]");
                if (lowerLimit == null && upperLimit == null) {
                    msg = "'" + valueConstraint + "' is not a valid value constraint format for dates: neither min- nor max-date specified";
                    logger.debug(msg);
                    continue;
                }
                if (lowerLimit != null && upperLimit != null && lowerLimit.after(upperLimit)) {
                    msg = "'" + valueConstraint + "' is not a valid value constraint format for dates: min-date > max-date";
                    logger.debug(msg);
                    continue;
                }
                if (upperLimit != null) {
                    prop.setMaxValue(String.valueOf(upperInclusive ? upperLimit.getTimeInMillis() : upperLimit.getTimeInMillis() - 1L));
                }
                if (lowerLimit == null) continue;
                prop.setMinValue(String.valueOf(lowerInclusive ? lowerLimit.getTimeInMillis() : lowerLimit.getTimeInMillis() + 1L));
            }
            catch (ValueFormatException vfe) {
                msg = "'" + valueConstraint + "' is not a valid value constraint format for dates";
                logger.debug(msg);
            }
            catch (RepositoryException re) {
                msg = "'" + valueConstraint + "' is not a valid value constraint format for dates";
                logger.debug(msg);
            }
        }
    }

    public List<GWTJahiaNodeType> getNodeTypes(List<String> names, Locale uiLocale) {
        try {
            ArrayList<GWTJahiaNodeType> list = new ArrayList<GWTJahiaNodeType>();
            for (String name : names) {
                GWTJahiaNodeType nodeType;
                if (StringUtils.isEmpty((String)name) || (nodeType = this.getNodeType(name, uiLocale)) == null) continue;
                list.add(nodeType);
            }
            return list;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<GWTJahiaNodeType> getSubNodeTypes(List<String> names, Locale uiLocale) {
        try {
            ArrayList<GWTJahiaNodeType> list = new ArrayList<GWTJahiaNodeType>();
            for (String name : names) {
                ExtendedNodeType t = NodeTypeRegistry.getInstance().getNodeType(name);
                NodeTypeIterator nti = t.getSubtypes();
                while (nti.hasNext()) {
                    ExtendedNodeType type = (ExtendedNodeType)nti.next();
                    GWTJahiaNodeType nodeType = this.getNodeType(type.getName(), uiLocale);
                    list.add(nodeType);
                }
            }
            return list;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Map<GWTJahiaNodeType, List<GWTJahiaNodeType>> getContentTypes(List<String> baseTypes, Map<String, Object> ctx, Locale uiLocale, boolean includeSubTypes, boolean displayStudioElement) {
        HashMap<GWTJahiaNodeType, List<GWTJahiaNodeType>> map = new HashMap<GWTJahiaNodeType, List<GWTJahiaNodeType>>();
        NodeTypeRegistry registry = NodeTypeRegistry.getInstance();
        try {
            ExtendedNodeType content = registry.getNodeType("jmix:droppableContent");
            NodeTypeIterator typeIterator = content.getDeclaredSubtypes();
            HashMap<String, ExtendedNodeType> contentTypes = new HashMap<String, ExtendedNodeType>();
            while (typeIterator.hasNext()) {
                ExtendedNodeType type = (ExtendedNodeType)typeIterator.next();
                contentTypes.put(type.getName(), type);
            }
            List<String> types = baseTypes == null ? new ArrayList<String>() : baseTypes;
            HashSet<ExtendedNodeType> nodeTypes = new HashSet<ExtendedNodeType>();
            if (baseTypes != null) {
                for (String type : types) {
                    this.recurseAdd(registry.getNodeType(type), types, contentTypes, nodeTypes, includeSubTypes);
                }
            } else {
                this.recurseAdd(content, types, contentTypes, nodeTypes, includeSubTypes);
            }
            typeIterator = content.getDeclaredSubtypes();
            while (typeIterator.hasNext()) {
                ExtendedNodeType mainType = (ExtendedNodeType)typeIterator.next();
                ArrayList<GWTJahiaNodeType> l = new ArrayList<GWTJahiaNodeType>();
                NodeTypeIterator subtypes = mainType.getDeclaredSubtypes();
                while (subtypes.hasNext()) {
                    ExtendedNodeType nodeType = (ExtendedNodeType)subtypes.next();
                    if (!nodeTypes.contains(nodeType)) continue;
                    GWTJahiaNodeType nt = this.getGWTJahiaNodeType(nodeType, uiLocale);
                    if (!displayStudioElement && !Arrays.asList(nodeType.getDeclaredSupertypeNames()).contains("jmix:studioOnly")) {
                        l.add(nt);
                    } else if (displayStudioElement) {
                        l.add(nt);
                    }
                    nodeTypes.remove(nodeType);
                }
                if (l.isEmpty()) continue;
                map.put(this.getGWTJahiaNodeType(mainType, uiLocale), l);
            }
            if (!nodeTypes.isEmpty()) {
                ArrayList<GWTJahiaNodeType> l = new ArrayList<GWTJahiaNodeType>();
                for (ExtendedNodeType nodeType : nodeTypes) {
                    if (displayStudioElement || Arrays.asList(nodeType.getDeclaredSupertypeNames()).contains("jmix:studioOnly")) continue;
                    GWTJahiaNodeType nt = this.getGWTJahiaNodeType(nodeType, uiLocale);
                    l.add(nt);
                }
                map.put(null, l);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    private void recurseAdd(ExtendedNodeType req, List<String> baseTypes, Map<String, ExtendedNodeType> contentTypes, Collection<ExtendedNodeType> result, boolean includeSubTypes) {
        boolean excludeNonDroppable = false;
        if (req.getName().equals("jmix:droppableContent") || contentTypes.keySet().contains(req.getName())) {
            excludeNonDroppable = true;
        }
        this.add(req, baseTypes, contentTypes, result, excludeNonDroppable);
        if (includeSubTypes) {
            NodeTypeIterator subtypes = req.getSubtypes();
            while (subtypes.hasNext()) {
                ExtendedNodeType subtype = (ExtendedNodeType)subtypes.next();
                this.add(subtype, baseTypes, contentTypes, result, excludeNonDroppable);
            }
        }
    }

    private void add(ExtendedNodeType type, List<String> baseTypes, Map<String, ExtendedNodeType> contentTypes, Collection<ExtendedNodeType> result, boolean excludeNonDroppable) {
        if (!(excludedTypes.contains(type.getName()) || type.isMixin() || type.isAbstract() || excludeNonDroppable && !CollectionUtils.containsAny(Arrays.asList(type.getDeclaredSupertypeNames()), contentTypes.keySet()))) {
            if (!baseTypes.isEmpty()) {
                for (String t : baseTypes) {
                    if (!type.isNodeType(t)) continue;
                    result.add(type);
                    return;
                }
            } else {
                result.add(type);
            }
        }
    }

    public List<ExtendedNodeType> getAvailableMixin(String type, JCRSiteNode site) throws NoSuchNodeTypeException {
        ArrayList<ExtendedNodeType> res = new ArrayList<ExtendedNodeType>();
        HashSet<String> foundTypes = new HashSet<String>();
        Set<String> installedModules = site != null && site.getPath().startsWith("/sites/") ? site.getInstalledModulesWithAllDependencies() : null;
        Map<ExtendedNodeType, Set<ExtendedNodeType>> m = NodeTypeRegistry.getInstance().getMixinExtensions();
        ExtendedNodeType realType = NodeTypeRegistry.getInstance().getNodeType(type);
        for (ExtendedNodeType nodeType : m.keySet()) {
            if (!realType.isNodeType(nodeType.getName())) continue;
            for (ExtendedNodeType extension : m.get(nodeType)) {
                if (installedModules != null && extension.getTemplatePackage() != null && !extension.getTemplatePackage().getModuleType().equalsIgnoreCase("system") && !installedModules.contains(extension.getTemplatePackage().getId())) continue;
                res.add(extension);
                foundTypes.add(extension.getName());
            }
        }
        return res;
    }

    public GWTJahiaNodePropertyValue convertValue(Value val, ExtendedPropertyDefinition def) throws RepositoryException {
        String theValue;
        int type;
        switch (def.getRequiredType()) {
            case 2: {
                type = 2;
                theValue = val.getString();
                break;
            }
            case 6: {
                type = 6;
                theValue = String.valueOf(val.getBoolean());
                break;
            }
            case 5: {
                type = 5;
                Calendar date = val.getDate();
                if (date == null) {
                    theValue = null;
                    break;
                }
                theValue = String.valueOf(date.getTimeInMillis());
                break;
            }
            case 4: {
                type = 4;
                theValue = String.valueOf(val.getDouble());
                break;
            }
            case 3: {
                type = 3;
                theValue = String.valueOf(val.getLong());
                break;
            }
            case 7: {
                type = 7;
                theValue = val.getString();
                break;
            }
            case 8: {
                type = 8;
                theValue = val.getString();
                break;
            }
            case 10: {
                GWTJahiaNodePropertyValue convertedValue = null;
                JCRNodeWrapper node = ((JCRValueWrapper)val).getNode();
                if (node != null) {
                    convertedValue = new GWTJahiaNodePropertyValue(this.navigation.getGWTJahiaNode(node), 10);
                }
                return convertedValue;
            }
            case 9: {
                return new GWTJahiaNodePropertyValue(this.navigation.getGWTJahiaNode(((JCRValueWrapper)val).getNode()), 9);
            }
            case 1: {
                JCRValueWrapper value;
                type = 1;
                theValue = val.getString();
                if (def.getSelector() != 9) break;
                JCRValueWrapper jCRValueWrapper = value = val instanceof JCRValueWrapper ? (JCRValueWrapper)val : new JCRValueWrapperImpl(val, def, JCRSessionFactory.getInstance().getCurrentUserSession());
                if (value.getNode() != null) {
                    return new GWTJahiaNodePropertyValue(theValue, this.navigation.getGWTJahiaNode(value.getNode()), type);
                }
                return null;
            }
            case 0: {
                type = 0;
                theValue = val.getString();
                break;
            }
            default: {
                type = 0;
                theValue = val.getString();
            }
        }
        return new GWTJahiaNodePropertyValue(theValue, type);
    }

    public Value convertValue(GWTJahiaNodePropertyValue val) throws RepositoryException {
        NameValue value;
        switch (val.getType()) {
            case 2: {
                value = new BinaryValue(val.getBinary());
                break;
            }
            case 6: {
                value = new BooleanValue(val.getBoolean());
                break;
            }
            case 5: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(val.getDate());
                value = new DateValue(cal);
                break;
            }
            case 4: {
                value = new DoubleValue(val.getDouble());
                break;
            }
            case 3: {
                value = new LongValue(val.getLong());
                break;
            }
            case 7: {
                value = NameValue.valueOf((String)val.getString());
                break;
            }
            case 8: {
                value = PathValue.valueOf((String)val.getString());
                break;
            }
            case 9: {
                value = ReferenceValue.valueOf((String)val.getString());
                break;
            }
            case 10: {
                value = WeakReferenceValue.valueOf((String)val.getString());
                break;
            }
            case 1: {
                value = new StringValue(val.getString());
                break;
            }
            case 0: {
                value = new StringValue(val.getString());
                break;
            }
            default: {
                value = new StringValue(val.getString());
            }
        }
        return value;
    }

    public Map<String, GWTChoiceListInitializer> getAllChoiceListInitializersValues(List<ExtendedNodeType> items, ExtendedNodeType contextType, JCRNodeWrapper contextNode, JCRNodeWrapper contextParent, Locale uiLocale) throws RepositoryException {
        HashMap<String, GWTChoiceListInitializer> results = new HashMap<String, GWTChoiceListInitializer>();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("contextType", contextType);
        context.put("contextNode", contextNode);
        context.put("contextParent", contextParent);
        for (Map.Entry<String, ExtendedPropertyDefinition> item : this.getChoiceListItems(items).entrySet()) {
            GWTChoiceListInitializer initializer = this.getChoiceListInitializerValues(item.getValue(), context, uiLocale);
            if (initializer == null) continue;
            results.put(item.getKey(), initializer);
        }
        return results;
    }

    public GWTChoiceListInitializer getInitializerValues(ExtendedPropertyDefinition epd, ExtendedNodeType contextType, JCRNodeWrapper contextNode, JCRNodeWrapper contextParent, Map<String, List<GWTJahiaNodePropertyValue>> dependentValues, Locale uiLocale) throws RepositoryException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("contextType", contextType);
        context.put("contextNode", contextNode);
        context.put("contextParent", contextParent);
        for (Map.Entry<String, List<GWTJahiaNodePropertyValue>> entry : dependentValues.entrySet()) {
            context.put(entry.getKey(), CollectionUtils.collect((Collection)entry.getValue(), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return input.toString();
                }
            }));
        }
        return this.getChoiceListInitializerValues(epd, context, uiLocale);
    }

    private GWTChoiceListInitializer getChoiceListInitializerValues(ExtendedPropertyDefinition epd, Map<String, Object> context, Locale uiLocale) {
        Map<String, String> map;
        GWTChoiceListInitializer initializer = null;
        if (!epd.isHidden() && (map = epd.getSelectorOptions()).size() > 0) {
            ArrayList<GWTJahiaValueDisplayBean> displayBeans = new ArrayList<GWTJahiaValueDisplayBean>(32);
            Map<String, ChoiceListInitializer> initializers = this.choiceListInitializerService.getInitializers();
            ArrayList dependentProperties = null;
            if (map.containsKey("dependentProperties")) {
                dependentProperties = Lists.newArrayList((Object[])StringUtils.split((String)map.get("dependentProperties"), (char)','));
                context.put("dependentProperties", dependentProperties);
            }
            List<ChoiceListValue> listValues = null;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!initializers.containsKey(entry.getKey())) continue;
                listValues = initializers.get(entry.getKey()).getChoiceListValues(epd, entry.getValue(), listValues, uiLocale, context);
            }
            if (listValues != null) {
                for (ChoiceListValue choiceListValue : listValues) {
                    try {
                        GWTJahiaValueDisplayBean displayBean = new GWTJahiaValueDisplayBean(choiceListValue.getValue().getString(), choiceListValue.getDisplayName());
                        Map<String, Object> props = choiceListValue.getProperties();
                        if (props != null) {
                            for (Map.Entry<String, Object> objectEntry : props.entrySet()) {
                                if (objectEntry.getKey() == null || objectEntry.getValue() == null) {
                                    logger.error("Null value : " + objectEntry.getKey() + " / " + objectEntry.getValue());
                                    continue;
                                }
                                displayBean.set(objectEntry.getKey(), objectEntry.getValue());
                            }
                        }
                        displayBeans.add(displayBean);
                    }
                    catch (RepositoryException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            initializer = new GWTChoiceListInitializer(displayBeans, (List)dependentProperties);
        }
        return initializer;
    }

    private Map<String, ExtendedPropertyDefinition> getChoiceListItems(List<ExtendedNodeType> allTypes) {
        HashMap<String, ExtendedPropertyDefinition> items = new HashMap<String, ExtendedPropertyDefinition>();
        for (ExtendedNodeType nodeType : allTypes) {
            Collection<ExtendedPropertyDefinition> c = nodeType.getPropertyDefinitionsAsMap().values();
            for (ExtendedPropertyDefinition definition : c) {
                if (definition.getSelector() != 14 || definition.getSelectorOptions().isEmpty()) continue;
                items.put(definition.getDeclaringNodeType().getName() + "." + definition.getName(), definition);
            }
        }
        return items;
    }

    public Map<String, Map<String, List<GWTJahiaNodePropertyValue>>> getAllDefaultValues(List<ExtendedNodeType> items, List<Locale> locales) throws RepositoryException {
        Set<Map.Entry<String, ExtendedPropertyDefinition>> entries = this.getInitializedItems(items).entrySet();
        HashMap<String, Map<String, List<GWTJahiaNodePropertyValue>>> results = new HashMap<String, Map<String, List<GWTJahiaNodePropertyValue>>>();
        for (Locale locale : locales) {
            HashMap defaultValues = new HashMap();
            for (Map.Entry<String, ExtendedPropertyDefinition> entry : entries) {
                ArrayList<GWTJahiaNodePropertyValue> propertyDefaultValues = new ArrayList<GWTJahiaNodePropertyValue>();
                for (Value value : entry.getValue().getDefaultValues(locale)) {
                    propertyDefaultValues.add(this.convertValue(value, entry.getValue()));
                }
                defaultValues.put(entry.getKey(), propertyDefaultValues);
            }
            results.put(locale.toString(), defaultValues);
        }
        return results;
    }

    private Map<String, ExtendedPropertyDefinition> getInitializedItems(List<ExtendedNodeType> allTypes) {
        HashMap<String, ExtendedPropertyDefinition> items = new HashMap<String, ExtendedPropertyDefinition>();
        for (ExtendedNodeType nodeType : allTypes) {
            for (ExtendedPropertyDefinition definition : nodeType.getPropertyDefinitionsAsMap().values()) {
                if (definition.getDefaultValues().length <= 0) continue;
                items.put(definition.getDeclaringNodeType().getName() + "." + definition.getName(), definition);
            }
        }
        return items;
    }

    public List<GWTJahiaNodeType> getContentTypesAsTree(List<String> nodeTypes, List<String> excludedNodeTypes, boolean includeSubTypes, JCRSiteNode site, Locale uiLocale, JCRSessionWrapper session) throws GWTJahiaServiceException {
        try {
            ArrayList<JahiaTemplatesPackage> packages = new ArrayList<JahiaTemplatesPackage>();
            if (site.isNodeType("jnt:module")) {
                packages.add(site.getTemplatePackage());
            } else {
                for (String s : site.getInstalledModules()) {
                    JahiaTemplatesPackage aPackage = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(s);
                    packages.add(aPackage);
                }
            }
            for (int i = 0; i < packages.size(); ++i) {
                JahiaTemplatesPackage aPackage = (JahiaTemplatesPackage)packages.get(i);
                if (aPackage == null) continue;
                for (JahiaTemplatesPackage dep : aPackage.getDependencies()) {
                    if (packages.contains(dep)) continue;
                    packages.add(dep);
                }
            }
            ArrayList<ExtendedNodeType> types = new ArrayList<ExtendedNodeType>();
            for (JahiaTemplatesPackage pkg : packages) {
                ExtendedNodeType extendedNodeType;
                if (pkg == null) continue;
                NodeTypeRegistry.JahiaNodeTypeIterator nti = NodeTypeRegistry.getInstance().getNodeTypes(pkg.getId());
                while (nti.hasNext()) {
                    extendedNodeType = (ExtendedNodeType)nti.nextNodeType();
                    if (!this.isValidNodeType(extendedNodeType, nodeTypes, excludedNodeTypes, includeSubTypes, site)) continue;
                    types.add(extendedNodeType);
                }
                if (!pkg.isDefault()) continue;
                nti = NodeTypeRegistry.getInstance().getNodeTypes("system-jahia");
                while (nti.hasNext()) {
                    extendedNodeType = (ExtendedNodeType)nti.nextNodeType();
                    if (!this.isValidNodeType(extendedNodeType, nodeTypes, excludedNodeTypes, includeSubTypes, site)) continue;
                    types.add(extendedNodeType);
                }
            }
            HashMap r = new HashMap();
            for (ExtendedNodeType nt : types) {
                if (nt.isMixin() || nt.isAbstract()) continue;
                ExtendedNodeType parent = this.findFolder(nt);
                if (!r.containsKey(parent)) {
                    r.put(parent, new ArrayList());
                }
                ((List)r.get(parent)).add(nt);
            }
            ArrayList<GWTJahiaNodeType> roots = new ArrayList<GWTJahiaNodeType>();
            for (Map.Entry entry : r.entrySet()) {
                GWTJahiaNodeType nt = this.getGWTJahiaNodeType(entry.getKey() != null ? (ExtendedNodeType)entry.getKey() : NodeTypeRegistry.getInstance().getNodeType("nt:base"), uiLocale);
                roots.add(nt);
                for (ExtendedNodeType type : (List)entry.getValue()) {
                    nt.add((ModelData)this.getGWTJahiaNodeType(type, uiLocale));
                }
            }
            if (roots.size() == 1 && (((GWTJahiaNodeType)roots.get(0)).isMixin() || ((GWTJahiaNodeType)roots.get(0)).getName().equals("nt:base"))) {
                List l = ((GWTJahiaNodeType)roots.get(0)).getChildren();
                roots.clear();
                for (ModelData o : l) {
                    roots.add((GWTJahiaNodeType)o);
                }
            }
            return roots;
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.translate", uiLocale, e.getLocalizedMessage()));
        }
    }

    private ExtendedNodeType findFolder(ExtendedNodeType nt) throws RepositoryException {
        if (!"jmix:droppableContent".equals(nt.getName()) && nt.isNodeType("jmix:droppableContent")) {
            if (logger.isDebugEnabled()) {
                logger.debug("Detected component type {}", (Object)nt.getName());
            }
            ExtendedNodeType[] supertypes = nt.getSupertypes();
            for (int i = supertypes.length - 1; i >= 0; --i) {
                ExtendedNodeType st = supertypes[i];
                if (!st.isMixin() || st.getName().equals("jmix:droppableContent") || !st.isNodeType("jmix:droppableContent")) continue;
                return st;
            }
        }
        return null;
    }

    private boolean isValidNodeType(ExtendedNodeType ent, List<String> nodeTypes, List<String> excludedNodeTypes, boolean includeSubTypes, JCRNodeWrapper node) throws RepositoryException {
        if (ent == null) {
            return false;
        }
        if (includeSubTypes) {
            if (this.isNodeType(nodeTypes, ent) && this.checkPermissionForType(ent, node)) {
                return excludedNodeTypes == null || !this.isNodeType(excludedNodeTypes, ent);
            }
        } else {
            for (String nodeType : nodeTypes) {
                if (!ent.getName().equals(nodeType) || !this.checkPermissionForType(ent, node)) continue;
                return excludedNodeTypes == null || !this.isNodeType(excludedNodeTypes, ent);
            }
        }
        return false;
    }

    public boolean checkPermissionForType(String typename, JCRNodeWrapper node) throws RepositoryException {
        ExtendedNodeType type = NodeTypeRegistry.getInstance().getNodeType(typename);
        return this.checkPermissionForType(type, node);
    }

    private boolean checkPermissionForType(ExtendedNodeType type, JCRNodeWrapper node) throws NoSuchNodeTypeException {
        NodeTypeRegistry.getInstance().getNodeType("jmix:accessControllableContent").getDeclaredSubtypes();
        List<ExtendedNodeType> superTypes = Arrays.asList(type.getSupertypes());
        NodeTypeIterator it = NodeTypeRegistry.getInstance().getNodeType("jmix:accessControllableContent").getDeclaredSubtypes();
        boolean allowed = true;
        while (it.hasNext()) {
            ExtendedNodeType next = (ExtendedNodeType)it.next();
            if (!superTypes.contains(next)) continue;
            allowed = node.hasPermission("component-" + next.getName().replace(":", "_"));
        }
        return allowed;
    }

    private boolean isNodeType(List<String> nodeTypes, ExtendedNodeType type) {
        if (nodeTypes != null) {
            for (String nodeType : nodeTypes) {
                if (!type.isNodeType(nodeType)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

