/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentHubHelper {
    private static Logger logger = LoggerFactory.getLogger(ContentHubHelper.class);
    private JCRSessionFactory sessionFactory;
    private JahiaUserManagerService userManagerService;

    public void setSessionFactory(JCRSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Map<String, String> getStoredPasswordsProviders(JahiaUser user) {
        HashMap<String, String> results = new HashMap<String, String>();
        results.put(null, user.getUsername());
        JCRUserNode userNode = this.userManagerService.lookupUserByPath(user.getLocalPath());
        if (userNode != null) {
            for (JCRStoreProvider provider : this.sessionFactory.getProviders().values()) {
                if (!"storedPasswords".equals(provider.getAuthenticationType())) continue;
                results.put(provider.getKey(), userNode.getPropertyAsString("storedUsername_" + provider.getKey()));
            }
        }
        return results;
    }

    public void storePasswordForProvider(JCRUserNode user, String providerKey, String username, String password) {
        try {
            if (username == null) {
                user.getProperty("storedUsername_" + providerKey).remove();
            } else {
                user.setProperty("storedUsername_" + providerKey, username);
            }
            if (password == null) {
                user.getProperty("storedPassword_" + providerKey).remove();
            } else {
                user.setProperty("storedPassword_" + providerKey, password);
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setUserManagerService(JahiaUserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }
}

