/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.jcr.RepositoryException;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACE;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACL;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNewPortletInstance;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaPortletDefinition;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.helper.ACLHelper;
import org.jahia.ajax.gwt.helper.ContentManagerHelper;
import org.jahia.ajax.gwt.helper.NavigationHelper;
import org.jahia.bin.Jahia;
import org.jahia.data.applications.ApplicationBean;
import org.jahia.data.applications.EntryPointDefinition;
import org.jahia.data.applications.PortletEntryPointDefinition;
import org.jahia.exceptions.JahiaException;
import org.jahia.services.applications.ApplicationsManagerService;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRPortletNode;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.utils.Patterns;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletHelper {
    private static Logger logger = LoggerFactory.getLogger(PortletHelper.class);
    private ApplicationsManagerService applicationsManager;
    private NavigationHelper navigation;
    private ACLHelper acl;
    private ContentManagerHelper contentManager;

    public void setApplicationsManager(ApplicationsManagerService applicationsManager) {
        this.applicationsManager = applicationsManager;
    }

    public void setNavigation(NavigationHelper navigation) {
        this.navigation = navigation;
    }

    public void setAcl(ACLHelper acl) {
        this.acl = acl;
    }

    public void setContentManager(ContentManagerHelper contentManager) {
        this.contentManager = contentManager;
    }

    public List<GWTJahiaPortletDefinition> searchPortlets(String match, Locale locale, JCRSessionWrapper session, Locale uiLocale) {
        ArrayList<GWTJahiaPortletDefinition> results = new ArrayList<GWTJahiaPortletDefinition>();
        try {
            LinkedList<ApplicationBean> appList = new LinkedList<ApplicationBean>();
            if (match != null) {
                ApplicationBean app = this.applicationsManager.getApplication(match);
                if (app != null) {
                    appList.add(app);
                } else {
                    logger.warn("Application not found for the UUID '" + match + "'");
                }
            } else {
                appList.addAll(this.applicationsManager.getApplications());
            }
            for (ApplicationBean appBean : appList) {
                if (!JCRContentUtils.hasPermission(session.getWorkspace().getName(), "jcr:read", appBean.getID())) continue;
                List<EntryPointDefinition> l = appBean.getEntryPointDefinitions();
                for (EntryPointDefinition aL : l) {
                    results.add(this.createGWTJahiaPortletDefinition(appBean, aL, locale, uiLocale));
                }
            }
        }
        catch (JahiaException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public GWTJahiaPortletDefinition createGWTJahiaPortletDefinition(ApplicationBean appBean, EntryPointDefinition entryPointDefinition, Locale locale, Locale uiLocale) throws JahiaException {
        String portletType = null;
        int expTime = 0;
        String cacheScope = null;
        if (entryPointDefinition instanceof PortletEntryPointDefinition) {
            PortletEntryPointDefinition portletEntryPointDefinition = (PortletEntryPointDefinition)entryPointDefinition;
            portletType = portletEntryPointDefinition.getInitParameter("portletType");
            expTime = portletEntryPointDefinition.getExpirationCache();
            cacheScope = portletEntryPointDefinition.getCacheScope();
        }
        if (portletType == null) {
            portletType = "jnt:portlet";
        }
        GWTJahiaNodeACL gwtJahiaNodeACL = new GWTJahiaNodeACL(new ArrayList());
        return new GWTJahiaPortletDefinition(appBean.getID(), appBean.getContext(), entryPointDefinition.getName(), entryPointDefinition.getDisplayName(locale), portletType, gwtJahiaNodeACL, entryPointDefinition.getDescription(locale), Integer.valueOf(expTime), cacheScope);
    }

    public GWTJahiaNode createPortletInstance(String parentPath, GWTJahiaNewPortletInstance gwtJahiaNewPortletInstance, JCRSessionWrapper currentUserSession, Locale uiLocale, String httpSessionID) throws GWTJahiaServiceException {
        try {
            String user;
            String name = gwtJahiaNewPortletInstance.getInstanceName();
            if (name == null) {
                name = Patterns.SLASH.matcher(gwtJahiaNewPortletInstance.getGwtJahiaPortletDefinition().getDefinitionName()).replaceAll("___") + Math.round(Math.random() * 1000000.0);
            }
            if (this.contentManager.checkExistence(parentPath + "/" + name, currentUserSession, uiLocale)) {
                throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.node.already.exists.with.name", uiLocale, name));
            }
            JCRNodeWrapper parentNode = currentUserSession.getNode(parentPath);
            if (!parentNode.isCheckedOut()) {
                parentNode.checkout();
            }
            JCRPortletNode node = (JCRPortletNode)this.contentManager.addNode(parentNode, name, gwtJahiaNewPortletInstance.getGwtJahiaPortletDefinition().getPortletType(), null, gwtJahiaNewPortletInstance.getProperties(), uiLocale, httpSessionID);
            node.setApplication(gwtJahiaNewPortletInstance.getGwtJahiaPortletDefinition().getApplicationId(), gwtJahiaNewPortletInstance.getGwtJahiaPortletDefinition().getDefinitionName());
            node.revokeAllRoles();
            if (gwtJahiaNewPortletInstance.getModes() != null) {
                for (GWTJahiaNodeACE ace : gwtJahiaNewPortletInstance.getModes().getAce()) {
                    user = ace.getPrincipalType() + ":" + ace.getPrincipal();
                    if (ace.isInherited()) continue;
                }
            }
            if (gwtJahiaNewPortletInstance.getRoles() != null) {
                for (GWTJahiaNodeACE ace : gwtJahiaNewPortletInstance.getRoles().getAce()) {
                    user = ace.getPrincipalType() + ":" + ace.getPrincipal();
                    if (ace.isInherited()) continue;
                }
            }
            try {
                parentNode.save();
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new GWTJahiaServiceException(Messages.getInternal("label.gwt.error.system.error.happened", uiLocale));
            }
            return this.navigation.getGWTJahiaNode(node);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternal("label.gwt.error", uiLocale));
        }
    }

    public GWTJahiaNode createPortletInstance(String parentPath, String instanceName, String appName, String entryPointName, List<GWTJahiaNodeProperty> gwtJahiaNodeProperties, JCRSiteNode site, JCRSessionWrapper currentUserSession, Locale uiLocale, String httpSessionID) throws GWTJahiaServiceException {
        try {
            ArrayList<GWTJahiaNodeACE> roleAces;
            ArrayList<GWTJahiaNodeACE> modeAces;
            GWTJahiaPortletDefinition gwtJahiaPortletDefinition = this.createJahiaGWTPortletDefinitionByName(appName, entryPointName, currentUserSession.getLocale(), currentUserSession.getUser(), currentUserSession.getWorkspace().getName(), uiLocale);
            if (gwtJahiaPortletDefinition == null) {
                throw new GWTJahiaServiceException("[" + appName + "," + entryPointName + "]" + " portlet defintion not found --> Aboard creating  portlet instance");
            }
            GWTJahiaNewPortletInstance gwtJahiaNewPortletInstance = new GWTJahiaNewPortletInstance();
            gwtJahiaNewPortletInstance.setGwtJahiaPortletDefinition(gwtJahiaPortletDefinition);
            gwtJahiaNewPortletInstance.getProperties().addAll(gwtJahiaNodeProperties);
            gwtJahiaNewPortletInstance.getProperties().add(new GWTJahiaNodeProperty("j:expirationTime", new GWTJahiaNodePropertyValue("0", 3)));
            GWTJahiaNodeACL acl = gwtJahiaPortletDefinition.getBaseAcl();
            GWTJahiaNodeACL modes = gwtJahiaNewPortletInstance.getModes();
            if (modes == null) {
                modes = new GWTJahiaNodeACL();
            }
            if ((modeAces = modes.getAce()) == null) {
                modeAces = new ArrayList<GWTJahiaNodeACE>();
            }
            if (acl != null && acl.getAvailableRoles() != null) {
                List modesPermissions = (List)acl.getAvailableRoles().get("modes");
                modeAces.add(this.acl.createUsersGroupACE(modesPermissions, true, site));
            }
            modes.setAce(modeAces);
            gwtJahiaNewPortletInstance.setModes(modes);
            GWTJahiaNodeACL roles = gwtJahiaNewPortletInstance.getRoles();
            if (roles == null) {
                roles = new GWTJahiaNodeACL();
            }
            if ((roleAces = roles.getAce()) == null) {
                roleAces = new ArrayList<GWTJahiaNodeACE>();
            }
            if (acl != null && acl.getAvailableRoles() != null) {
                List rolesPermissions = (List)acl.getAvailableRoles().get("roles");
                roleAces.add(this.acl.createUsersGroupACE(rolesPermissions, true, site));
            }
            roles.setAce(roleAces);
            gwtJahiaNewPortletInstance.setRoles(roles);
            gwtJahiaNewPortletInstance.setInstanceName(instanceName);
            return this.createPortletInstance(parentPath, gwtJahiaNewPortletInstance, currentUserSession, uiLocale, httpSessionID);
        }
        catch (GWTJahiaServiceException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to create an RSS portlet due to: ", (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.create.portlet.instance", uiLocale, e.getLocalizedMessage()));
        }
    }

    public GWTJahiaNode createRSSPortletInstance(String parentPath, String name, String url, JCRSiteNode site, JCRSessionWrapper currentUserSession, Locale uiLocale, String httpSessionID) throws GWTJahiaServiceException {
        GWTJahiaNewPortletInstance gwtJahiaNewPortletInstance = new GWTJahiaNewPortletInstance();
        String appName = Jahia.getContextPath().length() > 0 ? Jahia.getContextPath().substring(1) + "/rss" : "rss";
        GWTJahiaPortletDefinition gwtJahiaPortletDefinition = this.createJahiaGWTPortletDefinitionByName(appName, "JahiaRSSPortlet", currentUserSession.getLocale(), currentUserSession.getUser(), currentUserSession.getWorkspace().getName(), uiLocale);
        if (gwtJahiaPortletDefinition == null) {
            logger.error("RSS portlet defintion not found --> Abort creating RSS portlet instance");
        }
        gwtJahiaNewPortletInstance.setGwtJahiaPortletDefinition(gwtJahiaPortletDefinition);
        ArrayList<GWTJahiaNodeProperty> gwtJahiaNodeProperties = new ArrayList<GWTJahiaNodeProperty>();
        gwtJahiaNodeProperties.add(new GWTJahiaNodeProperty("jcr:title", new GWTJahiaNodePropertyValue(name, 1)));
        gwtJahiaNodeProperties.add(new GWTJahiaNodeProperty("jcr:description", new GWTJahiaNodePropertyValue(url, 1)));
        gwtJahiaNodeProperties.add(new GWTJahiaNodeProperty("j:expirationTime", new GWTJahiaNodePropertyValue("0", 3)));
        gwtJahiaNodeProperties.add(new GWTJahiaNodeProperty("url", new GWTJahiaNodePropertyValue(url, 1)));
        return this.createPortletInstance(parentPath, name, appName, "JahiaRSSPortlet", gwtJahiaNodeProperties, site, currentUserSession, uiLocale, httpSessionID);
    }

    public GWTJahiaNode createGoogleGadgetPortletInstance(String parentPath, String name, String script, JCRSiteNode site, JCRSessionWrapper currentUserSession, Locale uiLocale, String httpSessionID) throws GWTJahiaServiceException {
        GWTJahiaNewPortletInstance gwtJahiaNewPortletInstance = new GWTJahiaNewPortletInstance();
        String appName = Jahia.getContextPath().length() > 0 ? Jahia.getContextPath().substring(1) + "/googlegadget" : "googlegadget";
        GWTJahiaPortletDefinition gwtJahiaPortletDefinition = this.createJahiaGWTPortletDefinitionByName(appName, "JahiaGoogleGadget", currentUserSession.getLocale(), currentUserSession.getUser(), currentUserSession.getWorkspace().getName(), uiLocale);
        if (gwtJahiaPortletDefinition == null) {
            logger.error("Google gadget portlet defintion not found --> Abort creating Google Gadget portlet instance");
        }
        gwtJahiaNewPortletInstance.setGwtJahiaPortletDefinition(gwtJahiaPortletDefinition);
        ArrayList<GWTJahiaNodeProperty> gwtJahiaNodeProperties = new ArrayList<GWTJahiaNodeProperty>();
        gwtJahiaNodeProperties.add(new GWTJahiaNodeProperty("jcr:title", new GWTJahiaNodePropertyValue(name, 1)));
        gwtJahiaNodeProperties.add(new GWTJahiaNodeProperty("jcr:description", new GWTJahiaNodePropertyValue("", 1)));
        gwtJahiaNodeProperties.add(new GWTJahiaNodeProperty("j:expirationTime", new GWTJahiaNodePropertyValue("0", 3)));
        gwtJahiaNodeProperties.add(new GWTJahiaNodeProperty("code", new GWTJahiaNodePropertyValue(script, 1)));
        return this.createPortletInstance(parentPath, name, appName, "JahiaGoogleGadget", gwtJahiaNodeProperties, site, currentUserSession, uiLocale, httpSessionID);
    }

    public GWTJahiaPortletDefinition createJahiaGWTPortletDefinitionByName(String appName, String entryPointName, Locale locale, JahiaUser user, String workspaceName, Locale uiLocale) {
        if (appName != null && entryPointName != null) {
            try {
                List<ApplicationBean> appList = this.applicationsManager.getApplications();
                for (ApplicationBean anAppList : appList) {
                    if (!JCRContentUtils.hasPermission(workspaceName, "jcr:read", anAppList.getID())) continue;
                    List<EntryPointDefinition> l = anAppList.getEntryPointDefinitions();
                    for (EntryPointDefinition aL : l) {
                        boolean foundEntryPointDefinition = appName.equalsIgnoreCase(anAppList.getName()) && aL.getName().equalsIgnoreCase(entryPointName);
                        if (!foundEntryPointDefinition) continue;
                        return this.createGWTJahiaPortletDefinition(anAppList, aL, locale, uiLocale);
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        logger.error("Portlet definition not found: " + appName);
        return null;
    }
}

