/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import com.extjs.gxt.ui.client.data.RpcMap;
import java.io.IOException;
import java.io.InputStream;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.ajax.gwt.client.data.GWTJahiaValueDisplayBean;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaItemDefinition;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.helper.ContentDefinitionHelper;
import org.jahia.ajax.gwt.helper.TemplateHelper;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StubHelper {
    private static Logger logger = LoggerFactory.getLogger(StubHelper.class);
    private ContentDefinitionHelper contentDefinition;
    private Map<String, String> nodeTypeView;
    private List<String> propertiesSnippetTypes;
    private TemplateHelper template;

    private String detectNodeTypeName(String path, JCRSessionWrapper session) {
        String ntName = null;
        try {
            JCRNodeWrapper parent;
            JCRNodeWrapper node = session.getNode(path);
            JCRNodeWrapper jCRNodeWrapper = parent = node.isNodeType("jnt:nodeTypeFolder") ? node : JCRContentUtils.getParentOfType(node, "jnt:nodeTypeFolder");
            if (parent != null) {
                ntName = StringUtils.replaceOnce((String)parent.getName(), (String)"_", (String)":");
            }
        }
        catch (RepositoryException e) {
            logger.error("Error while trying to find the node type associated with this path " + path, (Throwable)e);
        }
        return ntName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getCodeSnippets(String fileType, String snippetType, String nodeTypeName) {
        LinkedHashMap<String, String> stub;
        block10: {
            stub = new LinkedHashMap<String, String>();
            InputStream is = null;
            try {
                ServletContext servletContext = JahiaContextLoaderListener.getServletContext();
                Set resources = servletContext.getResourcePaths("/WEB-INF/etc/snippets/" + fileType + "/" + snippetType + "/");
                ExtendedNodeType n = null;
                if (resources == null) break block10;
                for (String resource : resources) {
                    String resourceName = StringUtils.substringAfterLast((String)resource, (String)"/");
                    String viewNodeType = this.getResourceViewNodeType(resourceName);
                    if (nodeTypeName != null && viewNodeType != null) {
                        if (null == n) {
                            try {
                                n = NodeTypeRegistry.getInstance().getNodeType(nodeTypeName);
                            }
                            catch (NoSuchNodeTypeException noSuchNodeTypeException) {
                                // empty catch block
                            }
                        }
                        if (n != null && !n.isNodeType(viewNodeType)) continue;
                    }
                    is = servletContext.getResourceAsStream(resource);
                    try {
                        stub.put(viewNodeType != null ? resourceName + "/" + viewNodeType : resourceName, StringUtils.join((Collection)IOUtils.readLines((InputStream)is), (String)"\n"));
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)is);
                    }
                }
            }
            catch (IOException e) {
                logger.error("Failed to read code snippets from " + fileType + "/" + snippetType, (Throwable)e);
            }
        }
        return stub;
    }

    private String getLabelTemplate(String fileType, String snippetType, String fileName, Locale locale) {
        String fileNameWithoutExtension = StringUtils.substringBeforeLast((String)fileName, (String)".");
        return Messages.getInternal("label.codesnippets." + fileType + "." + snippetType + "." + fileNameWithoutExtension, locale, fileNameWithoutExtension);
    }

    private String getResourceViewNodeType(String resourceName) {
        int dotPosition = resourceName.indexOf(46);
        if (dotPosition == -1 || dotPosition >= resourceName.length() - 1 || resourceName.indexOf(46, dotPosition + 1) == -1) {
            return null;
        }
        String viewKey = StringUtils.substringAfter((String)StringUtils.substringBeforeLast((String)resourceName, (String)"."), (String)".");
        return this.nodeTypeView.get(viewKey);
    }

    public RpcMap initializeCodeEditor(String path, boolean isNew, String nodeTypeName, String fileType, String siteName, Locale uiLocale, JCRSessionWrapper session) throws GWTJahiaServiceException {
        Map<String, Set<String>> availableResources;
        List<GWTJahiaValueDisplayBean> snippetsByType;
        GWTJahiaNodeType nodeType;
        RpcMap r = new RpcMap();
        String ntName = nodeTypeName == null && path != null ? this.detectNodeTypeName(path, session) : nodeTypeName;
        r.put("stubs", this.getCodeSnippets(fileType, "stub", ntName));
        LinkedHashMap<String, List<GWTJahiaValueDisplayBean>> snippets = new LinkedHashMap<String, List<GWTJahiaValueDisplayBean>>();
        if (ntName != null && (nodeType = this.contentDefinition.getNodeType(ntName, uiLocale)) != null) {
            r.put("nodeType", (Object)nodeType);
            ArrayList items = new ArrayList(nodeType.getItems());
            items.addAll(nodeType.getInheritedItems());
            for (String snippetType : this.propertiesSnippetTypes) {
                snippetsByType = new ArrayList<GWTJahiaValueDisplayBean>();
                for (Map.Entry<String, String> propertySnippetEntry : this.getCodeSnippets(fileType, snippetType, null).entrySet()) {
                    Format labelTemplate = null;
                    for (GWTJahiaItemDefinition definition : items) {
                        String defName = definition.getName();
                        if ("*".equals(defName) || definition.isNode() || definition.isHidden()) continue;
                        String propertySnippet = StringUtils.replace((String)propertySnippetEntry.getValue(), (String)"__value__", (String)defName);
                        if (null == labelTemplate) {
                            labelTemplate = new MessageFormat(this.getLabelTemplate(fileType, snippetType, propertySnippetEntry.getKey(), uiLocale));
                        }
                        GWTJahiaValueDisplayBean displayBean = new GWTJahiaValueDisplayBean(propertySnippet, labelTemplate.format(new String[]{defName}));
                        displayBean.set("text", (Object)StringUtils.replace((String)StringUtils.replace((String)propertySnippet, (String)"<", (String)"&lt;"), (String)">", (String)"&gt;"));
                        snippetsByType.add(displayBean);
                    }
                }
                snippets.put(snippetType, snippetsByType);
            }
        }
        if (!(snippetsByType = this.fillResources(fileType, uiLocale, availableResources = this.template.getAvailableResources(siteName))).isEmpty() || !snippets.isEmpty()) {
            r.put("availableResources", availableResources);
            snippets.put("resources", snippetsByType);
            r.put("snippets", snippets);
        }
        HashMap<String, Set<String>> availableModuleResources = new HashMap<String, Set<String>>();
        availableModuleResources.put("css", this.template.getAvailableResources(siteName, "css", ".css", false));
        availableModuleResources.put("javascript", this.template.getAvailableResources(siteName, "javascript", ".js", false));
        snippetsByType = this.fillResources(fileType, uiLocale, availableModuleResources);
        if (!snippetsByType.isEmpty() || !snippets.isEmpty()) {
            r.put("availableModuleResources", availableModuleResources);
            snippets.put("moduleResources", snippetsByType);
            r.put("snippets", snippets);
        }
        return r;
    }

    private List<GWTJahiaValueDisplayBean> fillResources(String fileType, Locale uiLocale, Map<String, Set<String>> availableResources) {
        ArrayList<GWTJahiaValueDisplayBean> snippetsByType = new ArrayList<GWTJahiaValueDisplayBean>();
        for (Map.Entry<String, String> resourceSnippetEntry : this.getCodeSnippets(fileType, "resources", null).entrySet()) {
            MessageFormat labelTemplate = null;
            for (Map.Entry<String, Set<String>> resourcesEntry : availableResources.entrySet()) {
                for (String resource : resourcesEntry.getValue()) {
                    String resourceSnippet = StringUtils.replace((String)StringUtils.replace((String)resourceSnippetEntry.getValue(), (String)"__resource__", (String)resource), (String)"__resourceType__", (String)resourcesEntry.getKey());
                    if (null == labelTemplate) {
                        labelTemplate = new MessageFormat(this.getLabelTemplate(fileType, "resources", resourceSnippetEntry.getKey(), uiLocale));
                    }
                    snippetsByType.add(new GWTJahiaValueDisplayBean(resourceSnippet, labelTemplate.format(new String[]{resource})));
                }
            }
        }
        return snippetsByType;
    }

    public void setContentDefinition(ContentDefinitionHelper contentDefinition) {
        this.contentDefinition = contentDefinition;
    }

    public void setNodeTypeView(Map<String, String> nodeTypeView) {
        this.nodeTypeView = nodeTypeView;
    }

    public void setPropertiesSnippetTypes(List<String> propertiesSnippetTypes) {
        this.propertiesSnippetTypes = propertiesSnippetTypes;
    }

    public void setTemplate(TemplateHelper template) {
        this.template = template;
    }
}

