/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jahia.bin.JahiaMultiActionController;
import org.jahia.bin.errors.DefaultErrorHandler;
import org.jahia.exceptions.JahiaBadRequestException;
import org.jahia.exceptions.JahiaUnauthorizedException;
import org.jahia.services.cache.Cache;
import org.jahia.services.cache.CacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheController
extends JahiaMultiActionController {
    private static Logger logger = LoggerFactory.getLogger(CacheController.class);
    private CacheService cacheService;

    public void flushByName(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Cache cache;
            this.checkUserAuthorized();
            String name = CacheController.getParameter(request, "name");
            if (logger.isDebugEnabled()) {
                logger.debug("Request received for flushing cache '{}'", (Object)name);
            }
            if ((cache = this.cacheService.getCache(name)) == null) {
                throw new JahiaBadRequestException("Unable to find cache for name '" + name + "'");
            }
            cache.flush(Boolean.valueOf(CacheController.getParameter(request, "propagate", "true")));
            logger.info("Content of the cache '{}' successfully flushed.", (Object)name);
            response.setStatus(200);
        }
        catch (JahiaUnauthorizedException ue) {
            response.sendError(401, ue.getMessage());
        }
        catch (Exception e) {
            DefaultErrorHandler.getInstance().handle(e, request, response);
        }
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }
}

