/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jahia.bin.Jahia;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.data.templates.ModuleState;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.osgi.FrameworkService;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.settings.SettingsBean;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndInit
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(EndInit.class);
    private static final long serialVersionUID = -2221764992780224013L;
    private boolean initialized = false;

    private void appendModulesInfo(StringBuilder out) {
        JahiaTemplateManagerService templateService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
        out.append("  Modules:");
        for (ModuleState.State state : ModuleState.State.values()) {
            List<Bundle> modules = templateService.getModulesByState(state);
            if (modules.isEmpty()) continue;
            out.append("\n      ").append((Object)state).append(": ").append(modules.size());
        }
    }

    public void destroy() {
        super.destroy();
        logger.info("Digital Experience Manager is shutting down, please wait...");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.initialized) {
            resp.sendError(503);
        }
    }

    private void finishInit() {
        try {
            JahiaContextLoaderListener.endContextInitialized();
            ServicesRegistry.getInstance().getSchedulerService().startSchedulers();
        }
        catch (JahiaInitializationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new JahiaRuntimeException(e);
        }
    }

    public void init() throws ServletException {
        super.init();
        logger.info("Got into EndInit");
        this.waitForStartup();
        this.finishInit();
        this.printEndMessage();
        this.initialized = true;
    }

    private void printEndMessage() {
        long initializationTime = System.currentTimeMillis() - JahiaContextLoaderListener.getStartupTime();
        StringBuilder out = new StringBuilder(256);
        if (SettingsBean.getInstance().isDevelopmentMode()) {
            out.append("\n--------------------------------------------------------------------------------------------------\n  D E V E L O P M E N T   M O D E   A C T I V E\n\n  In development mode, Digital Experience Manager will allow JSPs to be modified, modules to be\n  re-deployed and other modifications to happen immediately, but these DO have a performance impact.\n  It is strongly recommended to switch to production mode when running performance tests or going live.\n  The setting to change modes is called operatingMode in the jahia.properties configuration file.");
        } else if (SettingsBean.getInstance().isDistantPublicationServerMode()) {
            out.append("\n--------------------------------------------------------------------------------------------------\n  D I S T A N T  P U B L I C A T I O N  S E R V E R  M O D E   A C T I V E");
        } else {
            out.append("\n--------------------------------------------------------------------------------------------------\n  P R O D U C T I O N   M O D E   A C T I V E");
        }
        out.append("\n--------------------------------------------------------------------------------------------------\n");
        this.appendModulesInfo(out);
        out.append("\n--------------------------------------------------------------------------------------------------\n  ").append(Jahia.getFullProductVersion()).append(" is now ready. Initialization completed in ").append(initializationTime / 1000L).append(" seconds");
        out.append("\n--------------------------------------------------------------------------------------------------");
        logger.info(out.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForStartup() {
        FrameworkService instance;
        boolean stopWaiting = false;
        FrameworkService frameworkService = instance = FrameworkService.getInstance();
        synchronized (frameworkService) {
            while (!stopWaiting && !instance.isStarted()) {
                try {
                    logger.info("Start waiting for OSGi framework startup");
                    instance.wait(600000L);
                    stopWaiting = true;
                    logger.info("Stopped waiting for OSGi framework startup");
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

