/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import com.ibm.icu.text.DateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.commons.Version;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Jahia {
    public static final String CODE_NAME = "Gaia";
    public static final String VENDOR_NAME = "Jahia Solutions Group SA";
    public static final String COPYRIGHT = "&copy; Copyright 2002-2016  <a href=\"http://www.jahia.com\" target=\"newJahia\">Jahia Solutions Group SA</a> -";
    public static final String COPYRIGHT_TXT = "2016 Jahia Solutions Group SA";
    private static final Version JAHIA_VERSION;
    public static final String VERSION;
    private static final String INIT_PARAM_SUPPORTED_JDK_VERSIONS = "supported_jdk_versions";
    private static final Logger logger;
    private static String jahiaServletPath;
    private static String jahiaContextPath;
    private static boolean maintenance;
    private static volatile int buildNumber;
    private static volatile int eeBuildNumber;
    private static volatile String edition;
    private static volatile String buildDate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getBuildNumber() {
        if (buildNumber != -1) return buildNumber;
        Class<Jahia> clazz = Jahia.class;
        synchronized (Jahia.class) {
            if (buildNumber != -1) return buildNumber;
            buildNumber = Jahia.getBuildNumber("/META-INF/jahia-impl-marker.txt");
            // ** MonitorExit[var0] (shouldn't be in output)
            return buildNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getBuildDate() {
        if (buildDate != null) return buildDate;
        Class<Jahia> clazz = Jahia.class;
        synchronized (Jahia.class) {
            if (buildDate != null) return buildDate;
            try {
                URL urlToVersionMarker = Jahia.class.getResource("/META-INF/jahia-impl-marker.txt");
                if (urlToVersionMarker != null) {
                    URLConnection conn = urlToVersionMarker.openConnection();
                    long lastModified = conn instanceof JarURLConnection ? ((JarURLConnection)conn).getJarEntry().getTime() : conn.getLastModified();
                    buildDate = DateFormat.getDateTimeInstance((int)1, (int)1, (Locale)Locale.ENGLISH).format(new Date(lastModified));
                } else {
                    buildDate = "";
                }
            }
            catch (IOException ioe) {
                logger.error(ioe.getMessage(), (Throwable)ioe);
                buildDate = "";
            }
            return buildDate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getEEBuildNumber() {
        if (eeBuildNumber != -1) return eeBuildNumber;
        Class<Jahia> clazz = Jahia.class;
        synchronized (Jahia.class) {
            if (eeBuildNumber != -1) return eeBuildNumber;
            eeBuildNumber = Jahia.getBuildNumber("/META-INF/jahia-ee-impl-marker.txt");
            // ** MonitorExit[var0] (shouldn't be in output)
            return eeBuildNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getBuildNumber(String markerFilePathName) {
        int buildNumber;
        block6: {
            buildNumber = 0;
            try {
                InputStream in = Jahia.class.getResourceAsStream(markerFilePathName);
                if (in == null) break block6;
                try {
                    String number = IOUtils.toString((InputStream)in);
                    buildNumber = Integer.parseInt(number);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (NumberFormatException nfe) {
                logger.warn(nfe.getMessage());
            }
        }
        return buildNumber;
    }

    public static String getReleaseNumber() {
        return JAHIA_VERSION.getMajorVersion() + "." + JAHIA_VERSION.getMinorVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLicenseText() {
        String txt;
        InputStream in = null;
        try {
            in = JahiaContextLoaderListener.getServletContext().getResourceAsStream("/LICENSE");
            txt = IOUtils.toString((InputStream)in);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            txt = "Unable to parse licence file";
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return txt;
    }

    public static int getPatchNumber() {
        return JAHIA_VERSION.getPatchVersion();
    }

    public static int getServicePackNumber() {
        return JAHIA_VERSION.getServicePackVersion();
    }

    public static void verifyJavaVersion(String supportedJDKVersions) throws JahiaInitializationException {
        if (supportedJDKVersions != null) {
            try {
                Version currentJDKVersion = new Version(System.getProperty("java.version"));
                if (!Jahia.isSupportedJDKVersion(currentJDKVersion, supportedJDKVersions)) {
                    StringBuilder jemsg = new StringBuilder(256);
                    jemsg.append("WARNING\n\n");
                    jemsg.append("You are using an unsupported JDK version\n");
                    jemsg.append("or have an invalid ").append(INIT_PARAM_SUPPORTED_JDK_VERSIONS).append(" parameter string in \n");
                    jemsg.append("the deployment descriptor file web.xml.\n");
                    jemsg.append("\n\nHere is the range specified in the web.xml file : ").append(supportedJDKVersions).append(".\n");
                    jemsg.append("\nIf you want to disable this warning, remove the ");
                    jemsg.append(INIT_PARAM_SUPPORTED_JDK_VERSIONS);
                    jemsg.append("\n");
                    jemsg.append("\ninitialization parameter in the WEB-INF/web.xml\n\n");
                    jemsg.append("\n\nPlease note that if you deactivate this check or use unsupported versions\n\n");
                    jemsg.append("\nYou might run into serious problems and we cannot offer support for these.\n\n");
                    jemsg.append("\nYou may download a supported JDK from Oracle site: http://www.oracle.com/technetwork/java/javase/downloads/index.html");
                    jemsg.append("\n\n&nbsp;\n");
                    JahiaInitializationException e = new JahiaInitializationException(jemsg.toString());
                    logger.error("Invalid JDK version", (Throwable)e);
                    throw e;
                }
            }
            catch (NumberFormatException nfe) {
                logger.warn("Couldn't convert JDK version to internal version testing system, ignoring JDK version test...", (Throwable)nfe);
            }
        }
    }

    public static String getServletPath() {
        return jahiaServletPath;
    }

    public static String getContextPath() {
        return jahiaContextPath;
    }

    public static void setContextPath(String contextPath) {
        jahiaContextPath = contextPath;
    }

    @Deprecated
    public static SettingsBean getSettings() {
        return SettingsBean.getInstance();
    }

    public static boolean isMaintenance() {
        return maintenance;
    }

    public static void setMaintenance(boolean maintenance) {
        Jahia.maintenance = maintenance;
    }

    private static boolean isSupportedJDKVersion(Version currentJDKVersion, String supportedJDKString) {
        Version upperVersion;
        String rightVersionStr;
        Version lowerVersion;
        String leftVersionStr;
        if (supportedJDKString == null) {
            return true;
        }
        String workString = supportedJDKString.toLowerCase();
        int xPos = workString.indexOf("x");
        if (xPos == -1) {
            logger.debug("Invalid supported_jdk_versions initialization  parameter in web.xml, it MUST be in the  following format : 1.2 < x <= 1.3 (the 'x' character is mandatory and was missing in this case : [" + supportedJDKString + "] )");
            return false;
        }
        String leftArg = workString.substring(0, xPos).trim();
        String rightArg = workString.substring(xPos + 1).trim();
        if (leftArg.endsWith("<=")) {
            leftVersionStr = leftArg.substring(0, leftArg.length() - 2).trim();
            try {
                lowerVersion = new Version(leftVersionStr);
            }
            catch (NumberFormatException nfe) {
                logger.error("Error in lower version number conversion", (Throwable)nfe);
                return false;
            }
            if (lowerVersion.compareTo(currentJDKVersion) > 0) {
                return false;
            }
        } else if (leftArg.endsWith("<")) {
            leftVersionStr = leftArg.substring(0, leftArg.length() - 1).trim();
            try {
                lowerVersion = new Version(leftVersionStr);
            }
            catch (NumberFormatException nfe) {
                logger.error("Error in lower number conversion", (Throwable)nfe);
                return false;
            }
            if (lowerVersion.compareTo(currentJDKVersion) >= 0) {
                return false;
            }
        } else {
            logger.error("Invalid supported_jdk_versions initialization  parameter in web.xml, it MUST be in the  following format : 1.2 < x <= 1.3. Current string : [" + supportedJDKString + "] )");
            return false;
        }
        if (rightArg.startsWith("<=")) {
            rightVersionStr = rightArg.substring(2).trim();
            try {
                upperVersion = new Version(rightVersionStr);
            }
            catch (NumberFormatException nfe) {
                logger.error("Error in upper number conversion", (Throwable)nfe);
                return false;
            }
            if (upperVersion.compareTo(currentJDKVersion) < 0) {
                return false;
            }
        } else if (rightArg.startsWith("<")) {
            rightVersionStr = rightArg.substring(1).trim();
            try {
                upperVersion = new Version(rightVersionStr);
            }
            catch (NumberFormatException nfe) {
                logger.error("Error in upper number conversion", (Throwable)nfe);
                return false;
            }
            if (upperVersion.compareTo(currentJDKVersion) <= 0) {
                return false;
            }
        } else {
            logger.error("Invalid supported_jdk_versions initialization  parameter in web.xml, it MUST be in the  following format : 1.2 < x <= 1.3. Current string : [" + supportedJDKString + "] )");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getEdition() {
        if (edition != null) return edition;
        Class<Jahia> clazz = Jahia.class;
        synchronized (Jahia.class) {
            if (edition != null) return edition;
            edition = Jahia.class.getResource("/META-INF/jahia-ee-impl-marker.txt") != null ? "EE" : "CE";
            // ** MonitorExit[var0] (shouldn't be in output)
            return edition;
        }
    }

    public static boolean isEnterpriseEdition() {
        return "EE".equals(Jahia.getEdition());
    }

    public static String getFullProductVersion() {
        StringBuilder version = new StringBuilder();
        version.append("Digital Experience Manager ").append(VERSION).append(" [Gaia] - ").append(Jahia.isEnterpriseEdition() ? "Enterprise" : "Community").append(" Distribution - Build ").append(Jahia.getBuildNumber());
        if (Jahia.isEnterpriseEdition()) {
            version.append(".").append(Jahia.getEEBuildNumber());
        }
        return version.toString();
    }

    static {
        Version v = null;
        try {
            v = new Version("7.2.0.0");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        JAHIA_VERSION = v != null ? v : new Version("7.2.0.0");
        VERSION = JAHIA_VERSION.getMajorVersion() + "." + JAHIA_VERSION.getMinorVersion() + "." + JAHIA_VERSION.getServicePackVersion() + "." + JAHIA_VERSION.getPatchVersion();
        logger = LoggerFactory.getLogger(Jahia.class);
        maintenance = false;
        buildNumber = -1;
        eeBuildNumber = -1;
    }
}

