/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import javax.jcr.RepositoryException;
import org.jahia.bin.Action;
import org.jahia.security.license.LicenseChangedListener;
import org.jahia.security.license.LicenseCheckerService;
import org.jahia.services.content.JCRNodeWrapper;
import org.springframework.beans.factory.InitializingBean;

public abstract class LicensedAction
extends Action
implements InitializingBean,
LicenseChangedListener {
    private boolean allowedByLicense;
    private String licenseFeature;

    public void afterPropertiesSet() throws Exception {
        this.evaluateLicenseFeature();
    }

    private void evaluateLicenseFeature() {
        this.allowedByLicense = this.licenseFeature == null || LicenseCheckerService.Stub.isAllowed(this.licenseFeature);
    }

    public String getLicenseFeature() {
        return this.licenseFeature;
    }

    public boolean isAllowedByLicense() {
        return this.allowedByLicense;
    }

    @Override
    public boolean isPermitted(JCRNodeWrapper node) throws RepositoryException {
        return this.allowedByLicense && super.isPermitted(node);
    }

    public final void setLicenseFeature(String licenseFeature) {
        this.licenseFeature = licenseFeature;
    }

    @Override
    public void onLicenseChanged() {
        this.evaluateLicenseFeature();
    }
}

