/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.util.Locale;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jahia.bin.JahiaController;
import org.jahia.bin.Render;
import org.jahia.exceptions.JahiaBadRequestException;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.render.RenderContext;
import org.jahia.services.search.LinkGenerator;
import org.jahia.services.search.MatchInfo;
import org.jahia.services.seo.urlrewrite.UrlRewriteService;
import org.jahia.services.usermanager.JahiaUser;
import org.springframework.web.servlet.ModelAndView;

public class TemplateResolverServlet
extends JahiaController {
    private JCRSessionFactory sessionFactory;
    private UrlRewriteService urlService;

    public ModelAndView handleRequest(final HttpServletRequest req, HttpServletResponse resp) throws Exception {
        JahiaUser currentUser = this.sessionFactory.getCurrentUser();
        final RenderContext context = new RenderContext(req, resp, currentUser);
        String pathInfo = req.getPathInfo();
        int index = pathInfo.indexOf(47, 1);
        if (index == -1 || index == pathInfo.length() - 1) {
            throw new JahiaBadRequestException("Invalid path");
        }
        String resolve = pathInfo.substring(0, index);
        context.setServletPath(req.getServletPath() + resolve);
        try {
            final MatchInfo info = LinkGenerator.decomposeLink(pathInfo);
            final String workspace = info.getWorkspace();
            final String lang = info.getLang();
            Locale locale = Locale.forLanguageTag(lang);
            String redirect = JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(currentUser, workspace, locale, new JCRCallback<String>(){

                @Override
                public String doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRNodeWrapper node = session.getNodeByIdentifier(info.getId());
                    JCRNodeWrapper displayableNode = JCRContentUtils.findDisplayableNode(node, context);
                    if (displayableNode != null) {
                        return req.getContextPath() + Render.getRenderServletPath() + '/' + workspace + '/' + lang + displayableNode.getPath() + ".html";
                    }
                    return null;
                }
            });
            if (redirect != null) {
                if ("live".equals(workspace)) {
                    redirect = this.urlService.rewriteOutbound(redirect, req, resp);
                }
                resp.sendRedirect(redirect);
            } else {
                resp.sendError(404);
            }
        }
        catch (Exception e) {
            resp.sendError(404);
        }
        return null;
    }

    public void setJcrSessionFactory(JCRSessionFactory jcrSessionFactory) {
        this.sessionFactory = jcrSessionFactory;
    }

    public void setUrlService(UrlRewriteService urlService) {
        this.urlService = urlService;
    }
}

