/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.services.workflow.WorkflowService;
import org.jahia.services.workflow.WorklowTypeRegistration;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class WorkflowImageController
implements Controller {
    private WorkflowService workflowService;

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String wfKey = request.getParameter("workflowKey");
        String basePath = "/" + StringUtils.substringBefore((String)wfKey, (String)":").replaceAll("\\.", "/") + "/";
        wfKey = StringUtils.substringAfter((String)wfKey, (String)":");
        WorklowTypeRegistration workflowRegistration = this.workflowService.getWorkflowRegistration(wfKey);
        JahiaTemplatesPackage module = workflowRegistration.getModule();
        String language = request.getParameter("language");
        Resource resource = module.getResource(basePath + wfKey + "_" + language + ".png");
        if (resource == null) {
            resource = module.getResource(basePath + wfKey + ".png");
        }
        if (resource != null) {
            response.setContentType("image/png");
            ServletOutputStream out = response.getOutputStream();
            IOUtils.copy((InputStream)resource.getInputStream(), (OutputStream)out);
            out.flush();
        }
        response.setStatus(200);
        return null;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }
}

