/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.errors;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorEventFilter
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(ErrorEventFilter.class);
    private int minimalErrorCode = 500;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        Boolean alreadyForwarded = (Boolean)request.getAttribute("org.jahia.exception.forwarded");
        if (alreadyForwarded == null || !alreadyForwarded.booleanValue()) {
            this.handle((HttpServletRequest)request, (HttpServletResponse)response);
        }
        filterChain.doFilter(request, response);
    }

    protected Throwable getException(HttpServletRequest request) {
        Throwable ex = (Throwable)request.getAttribute("javax.servlet.error.exception");
        ex = ex != null ? ex : (Throwable)request.getAttribute("org.jahia.exception");
        return ex;
    }

    protected void handle(HttpServletRequest request, HttpServletResponse response) {
        int code = (Integer)request.getAttribute("javax.servlet.error.status_code");
        int n = code = code != 0 ? code : 500;
        if (code >= this.minimalErrorCode) {
            Throwable ex = this.getException(request);
            if (logger.isDebugEnabled()) {
                logger.debug("firing errorOccurred event with error code '" + code + "'", ex);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("The error code '" + code + "' is less than the minimal required to fire an event (" + this.minimalErrorCode + ")." + " Adjust the 'minimalErrorCode' filter init parameter to change this handling.");
        }
    }

    public void init(FilterConfig cfg) throws ServletException {
        this.minimalErrorCode = cfg.getInitParameter("minimalErrorCode") != null ? Integer.parseInt(cfg.getInitParameter("minimalErrorCode")) : 500;
    }
}

