/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.errors;

import java.io.IOException;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.jahia.bin.errors.ErrorFileDumper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionAppender
extends AppenderSkeleton {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionAppender.class);
    private boolean alreadyDumping = false;

    public ExceptionAppender() {
        if (ErrorFileDumper.isShutdown()) {
            ErrorFileDumper.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(LoggingEvent event) {
        if (this.alreadyDumping) {
            return;
        }
        if (event.getThrowableInformation() != null) {
            try {
                this.alreadyDumping = true;
                if (!ErrorFileDumper.isShutdown()) {
                    ErrorFileDumper.dumpToFile(event.getThrowableInformation().getThrowable(), null);
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.alreadyDumping = false;
            }
        }
    }

    public void close() {
        ErrorFileDumper.shutdown();
    }

    public boolean requiresLayout() {
        return false;
    }
}

