/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.filters;

import javax.servlet.Filter;
import javax.servlet.ServletException;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.services.SpringContextSingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;

public class ModuleDelegatingFilterProxy
extends DelegatingFilterProxy {
    private static final Logger logger = LoggerFactory.getLogger(ModuleDelegatingFilterProxy.class);

    protected Filter initDelegate(WebApplicationContext wac) throws ServletException {
        Filter delegate = null;
        String targetBeanName = this.getTargetBeanName();
        try {
            delegate = (Filter)SpringContextSingleton.getBeanInModulesContext(targetBeanName);
            logger.info("Found filter delegate for {}: {}", (Object)targetBeanName, (Object)delegate);
            if (this.isTargetFilterLifecycle()) {
                delegate.init(this.getFilterConfig());
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            if (JahiaContextLoaderListener.isContextInitialized()) {
                throw e;
            }
            logger.info("Deferring filter delegate lookup {} as context has not been fully initialized yet", (Object)targetBeanName);
        }
        return delegate;
    }
}

