/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.filters;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jahia.bin.filters.AbstractServletFilter;
import org.springframework.beans.factory.BeanNameAware;

public class ServletWrappingFilter
extends AbstractServletFilter
implements BeanNameAware {
    private String beanName;
    private FilterConfig filterConfig;
    private Map<String, String> initParameters = Collections.emptyMap();
    private Class<?> servletClass;
    private Servlet servletInstance;
    private String servletName;

    @Override
    public void destroy() {
        if (this.servletInstance != null) {
            this.servletInstance.destroy();
        }
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.servletInstance.service(servletRequest, servletResponse);
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        if (this.servletClass == null) {
            throw new IllegalArgumentException("servletClass is required");
        }
        if (!Servlet.class.isAssignableFrom(this.servletClass)) {
            throw new IllegalArgumentException("servletClass [" + this.servletClass.getName() + "] needs to implement interface [javax.servlet.Servlet]");
        }
        if (this.servletName == null) {
            this.servletName = this.beanName;
        }
        try {
            this.servletInstance = (Servlet)this.servletClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServletException((Throwable)e);
        }
        this.servletInstance.init((ServletConfig)new DelegatingServletConfig());
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setInitParameters(Map<String, String> initParameters) {
        this.initParameters = initParameters != null ? initParameters : Collections.emptyMap();
    }

    public void setServletClass(Class<?> servletClass) {
        this.servletClass = servletClass;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    private class DelegatingServletConfig
    implements ServletConfig {
        private DelegatingServletConfig() {
        }

        public String getInitParameter(String paramName) {
            return (String)ServletWrappingFilter.this.initParameters.get(paramName);
        }

        public Enumeration<String> getInitParameterNames() {
            return Iterators.asEnumeration(ServletWrappingFilter.this.initParameters.keySet().iterator());
        }

        public ServletContext getServletContext() {
            return ServletWrappingFilter.this.filterConfig.getServletContext();
        }

        public String getServletName() {
            return ServletWrappingFilter.this.servletName;
        }
    }
}

