/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.data.beans;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jahia.content.JahiaObject;
import org.jahia.data.beans.AbstractJahiaObjectBean;
import org.jahia.services.categories.Category;
import org.jahia.services.content.JCRSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryBean
extends AbstractJahiaObjectBean {
    private static final Logger logger = LoggerFactory.getLogger(CategoryBean.class);
    private Category category;

    public CategoryBean() {
    }

    public CategoryBean(Category category) {
        this.category = category;
    }

    public static AbstractJahiaObjectBean getChildInstance(JahiaObject jahiaObject) {
        return new CategoryBean((Category)jahiaObject);
    }

    public Category getCategory() {
        return this.category;
    }

    public String getTitle() {
        String title = this.category.getTitle(JCRSessionFactory.getInstance().getCurrentLocale());
        if (title != null) {
            return title;
        }
        return this.category.getKey();
    }

    public Properties getProperties() {
        return this.category.getProperties();
    }

    public static Set<CategoryBean> getCategoryBeans(Set<Category> categories) {
        HashSet<CategoryBean> result = new HashSet<CategoryBean>();
        for (Category cat : categories) {
            result.add(new CategoryBean(cat));
        }
        return result;
    }

    public String getKey() {
        return this.category.getKey();
    }

    static {
        CategoryBean.registerType(Category.class.getName(), CategoryBean.class.getName());
    }
}

