/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.data.templates;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.TopologicalSorter;
import org.jahia.commons.Version;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.services.modulemanager.Constants;

public class ModulesPackage {
    private Map<String, PackagedModule> modules = new LinkedHashMap<String, PackagedModule>();
    private String name;
    private String description;
    private Version version;

    public static ModulesPackage create(JarFile jarFile) throws IOException {
        return new ModulesPackage(jarFile);
    }

    private static Set<String> parseDependencies(Attributes manifestAttributes) {
        Set<String> dependencies = Collections.emptySet();
        String dependsValue = manifestAttributes.getValue(Constants.ATTR_NAME_JAHIA_DEPENDS);
        if (dependsValue != null && dependsValue.length() > 0) {
            dependencies = new LinkedHashSet<String>();
            dependencies.addAll(Arrays.asList(StringUtils.split((String)dependsValue, (String)", ")));
        }
        return dependencies;
    }

    private static void sortByDependencies(Map<String, PackagedModule> modules) throws CycleDetectedException {
        if (modules.size() <= 1) {
            return;
        }
        LinkedHashMap<String, PackagedModule> copy = new LinkedHashMap<String, PackagedModule>(modules);
        DAG dag = new DAG();
        for (PackagedModule m : modules.values()) {
            dag.addVertex(m.getName());
            for (String dep : m.getDepends()) {
                if (!modules.containsKey(dep)) continue;
                dag.addEdge(m.getName(), dep);
            }
        }
        List vertexes = TopologicalSorter.sort((DAG)dag);
        modules.clear();
        for (String v : vertexes) {
            modules.put(v, (PackagedModule)copy.get(v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModulesPackage(JarFile jarFile) throws IOException {
        Attributes manifestAttributes = jarFile.getManifest().getMainAttributes();
        this.version = new Version(manifestAttributes.getValue(Constants.ATTR_NAME_JAHIA_PACKAGE_VERSION));
        this.name = manifestAttributes.getValue(Constants.ATTR_NAME_JAHIA_PACKAGE_NAME);
        this.description = manifestAttributes.getValue(Constants.ATTR_NAME_JAHIA_PACKAGE_DESCRIPTION);
        Enumeration<JarEntry> jars = jarFile.entries();
        while (jars.hasMoreElements()) {
            JarEntry jar = jars.nextElement();
            ZipFile moduleJarFile = null;
            FileOutputStream output = null;
            if (!StringUtils.endsWith((String)jar.getName(), (String)".jar")) continue;
            try {
                InputStream input = jarFile.getInputStream(jar);
                File moduleFile = File.createTempFile(jar.getName(), "");
                output = new FileOutputStream(moduleFile);
                int read = 0;
                byte[] bytes = new byte[1024];
                while ((read = input.read(bytes)) != -1) {
                    ((OutputStream)output).write(bytes, 0, read);
                }
                moduleJarFile = new JarFile(moduleFile);
                Attributes moduleManifestAttributes = ((JarFile)moduleJarFile).getManifest().getMainAttributes();
                String bundleName = moduleManifestAttributes.getValue(Constants.ATTR_NAME_BUNDLE_SYMBOLIC_NAME);
                String jahiaGroupId = moduleManifestAttributes.getValue(Constants.ATTR_NAME_GROUP_ID);
                if (bundleName == null || jahiaGroupId == null) {
                    throw new IOException("Jar file " + jar.getName() + " in package does not seems to be a DX bundle.");
                }
                this.modules.put(bundleName, new PackagedModule(bundleName, moduleManifestAttributes, moduleFile));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(output);
                if (moduleJarFile != null) {
                    moduleJarFile.close();
                }
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)output);
            if (moduleJarFile == null) continue;
            moduleJarFile.close();
        }
        try {
            ModulesPackage.sortByDependencies(this.modules);
        }
        catch (CycleDetectedException e) {
            throw new JahiaRuntimeException("A cyclic dependency detected in the modules of the supplied package", e);
        }
    }

    public String getName() {
        return this.name;
    }

    public Map<String, PackagedModule> getModules() {
        return this.modules;
    }

    public String getDescription() {
        return this.description;
    }

    public Version getVersion() {
        return this.version;
    }

    public class PackagedModule {
        private final Attributes manifestAttributes;
        private final File moduleFile;
        private final String name;
        private final Set<String> depends;

        public PackagedModule(String name, Attributes manifestAttributes, File moduleFile) {
            this.name = name;
            this.manifestAttributes = manifestAttributes;
            this.moduleFile = moduleFile;
            this.depends = ModulesPackage.parseDependencies(manifestAttributes);
        }

        public Attributes getManifestAttributes() {
            return this.manifestAttributes;
        }

        public File getModuleFile() {
            return this.moduleFile;
        }

        public String getName() {
            return this.name;
        }

        public Set<String> getDepends() {
            return this.depends;
        }
    }
}

