/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.osgi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.jahia.osgi.BundleStarter;
import org.jahia.osgi.FrameworkService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.FrameworkWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BundleLifecycleUtils {
    private static final Logger logger = LoggerFactory.getLogger(BundleLifecycleUtils.class);

    private static Set<Bundle> findBundlesWithOptionalPackagesToRefresh(Collection<Bundle> bundles) {
        List importsList;
        HashSet<Bundle> targets = new HashSet<Bundle>(Arrays.asList(BundleLifecycleUtils.getAllBundles()));
        targets.removeAll(bundles);
        if (targets.isEmpty()) {
            return Collections.emptySet();
        }
        HashMap<Bundle, List> imports = new HashMap<Bundle, List>();
        Iterator it = targets.iterator();
        while (it.hasNext()) {
            Bundle b = (Bundle)it.next();
            String importsStr = (String)b.getHeaders().get("Import-Package");
            importsList = BundleLifecycleUtils.getOptionalImports(importsStr);
            if (importsList.isEmpty()) {
                it.remove();
                continue;
            }
            imports.put(b, importsList);
        }
        if (targets.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<Clause> exports = new ArrayList<Clause>();
        for (Bundle b : bundles) {
            String exportsStr;
            if (b.getState() == 1 || (exportsStr = (String)b.getHeaders().get("Export-Package")) == null) continue;
            Clause[] exportsList = Parser.parseHeader((String)exportsStr);
            exports.addAll(Arrays.asList(exportsList));
        }
        Iterator it2 = targets.iterator();
        while (it2.hasNext()) {
            Bundle b;
            b = (Bundle)it2.next();
            importsList = (List)imports.get(b);
            Iterator itpi = importsList.iterator();
            while (itpi.hasNext()) {
                Clause pi = (Clause)itpi.next();
                boolean matching = false;
                for (Clause pe : exports) {
                    Version exported;
                    if (!pi.getName().equals(pe.getName())) continue;
                    String evStr = pe.getAttribute("version");
                    String ivStr = pi.getAttribute("version");
                    VersionRange imported = ivStr != null ? VersionRange.parseVersionRange((String)ivStr) : VersionRange.ANY_VERSION;
                    if (!imported.contains(exported = evStr != null ? Version.parseVersion((String)evStr) : Version.emptyVersion)) continue;
                    matching = true;
                    break;
                }
                if (matching) continue;
                itpi.remove();
            }
            if (!importsList.isEmpty()) continue;
            it2.remove();
        }
        return targets;
    }

    private static Set<Bundle> findFragmentsForBundles(Collection<Bundle> bundles) {
        HashSet<Bundle> fragments = new HashSet<Bundle>();
        for (Bundle b : BundleLifecycleUtils.getAllBundles()) {
            if (b.getState() == 1) continue;
            fragments.addAll(BundleLifecycleUtils.findBundlesForClause(b, bundles));
        }
        return fragments;
    }

    public static Set<Bundle> getHostsFragment(Bundle fragment) {
        HashSet<Bundle> hosts = new HashSet<Bundle>();
        hosts.addAll(BundleLifecycleUtils.findBundlesForClause(fragment, Arrays.asList(BundleLifecycleUtils.getAllBundles())));
        return hosts;
    }

    private static List<Bundle> findBundlesForClause(Bundle fragment, Collection<Bundle> bundles) {
        Clause[] clauses;
        ArrayList<Bundle> foundBundles = new ArrayList<Bundle>();
        String hostHeader = (String)fragment.getHeaders().get("Fragment-Host");
        if (hostHeader != null && (clauses = Parser.parseHeader((String)hostHeader)) != null && clauses.length > 0) {
            Clause path = clauses[0];
            for (Bundle bundle : bundles) {
                if (bundle.getSymbolicName() == null || !bundle.getSymbolicName().equals(path.getName())) continue;
                String ver = path.getAttribute("bundle-version");
                if (ver != null) {
                    VersionRange v = VersionRange.parseVersionRange((String)ver);
                    if (!v.contains(VersionTable.getVersion((String)((String)bundle.getHeaders().get("Bundle-Version"))))) continue;
                    foundBundles.add(bundle);
                    continue;
                }
                foundBundles.add(bundle);
            }
        }
        return foundBundles;
    }

    private static Bundle[] getAllBundles() {
        return FrameworkService.getBundleContext().getBundles();
    }

    public static int getBundleStartLevel(Bundle bundle) {
        return ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
    }

    public static int getFrameworkStartLevel() {
        return ((FrameworkStartLevel)BundleLifecycleUtils.getSystemBundle().adapt(FrameworkStartLevel.class)).getStartLevel();
    }

    public static FrameworkWiring getFrameworkWiring() {
        return (FrameworkWiring)BundleLifecycleUtils.getSystemBundle().adapt(FrameworkWiring.class);
    }

    private static List<Clause> getOptionalImports(String importsStr) {
        Clause[] imports = Parser.parseHeader((String)importsStr);
        LinkedList<Clause> result = new LinkedList<Clause>();
        for (Clause anImport : imports) {
            String resolution = anImport.getDirective("resolution");
            if (!"optional".equals(resolution)) continue;
            result.add(anImport);
        }
        return result;
    }

    private static Bundle getSystemBundle() {
        return FrameworkService.getBundleContext().getBundle(0L);
    }

    private static boolean isFragment(Bundle bundle) {
        BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
        return (rev.getTypes() & 1) != 0;
    }

    public static void refreshBundle(Bundle bundle) {
        BundleLifecycleUtils.refreshBundles(Collections.singleton(bundle), true, true);
    }

    private static void refreshBundles(Collection<Bundle> bundlesToRefresh) {
        final CountDownLatch latch = new CountDownLatch(1);
        FrameworkWiring wiring = BundleLifecycleUtils.getFrameworkWiring();
        wiring.refreshBundles(bundlesToRefresh, new FrameworkListener[]{new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                latch.countDown();
            }
        }});
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            logger.warn("Waiting for refresh of bundles was interrupted", (Throwable)e);
        }
    }

    public static void refreshBundles(Collection<Bundle> bundlesToRefresh, boolean considerFragments, boolean considerBundlesWithOptionalPackages) {
        Set<Bundle> bundlesWithOptionalPackages;
        Set<Bundle> fragments;
        logger.info("Requested refresh for the following {} bundle(s): {}", (Object)bundlesToRefresh.size(), bundlesToRefresh);
        HashSet<Bundle> fullBundleList = bundlesToRefresh;
        if (considerFragments && !(fragments = BundleLifecycleUtils.findFragmentsForBundles(bundlesToRefresh)).isEmpty()) {
            fullBundleList = new HashSet<Bundle>(bundlesToRefresh);
            fullBundleList.addAll(fragments);
        }
        if (considerBundlesWithOptionalPackages && !(bundlesWithOptionalPackages = BundleLifecycleUtils.findBundlesWithOptionalPackagesToRefresh(bundlesToRefresh)).isEmpty()) {
            fullBundleList = fullBundleList == bundlesToRefresh ? new HashSet<Bundle>(bundlesToRefresh) : fullBundleList;
            fullBundleList.addAll(bundlesWithOptionalPackages);
        }
        if (fullBundleList != bundlesToRefresh) {
            logger.info("Triggering refresh for the following {} bundle(s): {}", (Object)fullBundleList.size(), fullBundleList);
        }
        BundleLifecycleUtils.refreshBundles(fullBundleList);
    }

    public static boolean resolveBundle(Bundle bundle) {
        return BundleLifecycleUtils.resolveBundles(Collections.singleton(bundle));
    }

    public static boolean resolveBundles(Collection<Bundle> bundlesToResolve) {
        if (bundlesToResolve != null) {
            logger.info("Requested resolve for the following {} bundle(s): {}", (Object)bundlesToResolve.size(), bundlesToResolve);
        } else {
            logger.info("Requested resolve for all bundles");
        }
        return BundleLifecycleUtils.getFrameworkWiring().resolveBundles(bundlesToResolve);
    }

    private static void startBundles(Collection<Bundle> bundlesToStart) {
        for (Bundle bundle : bundlesToStart) {
            int frameworkStartLevel = BundleLifecycleUtils.getFrameworkStartLevel();
            if (bundle.getState() == 1 || BundleLifecycleUtils.isFragment(bundle) || frameworkStartLevel < BundleLifecycleUtils.getBundleStartLevel(bundle)) continue;
            try {
                logger.info("Starting bundle: {}", (Object)bundle);
                bundle.start(2);
            }
            catch (BundleException e) {
                if (4 == e.getType()) {
                    logger.debug("Error while starting bundle " + bundle + ". Cause: " + e.getMessage(), (Throwable)e);
                    logger.info("Bundle {} has unresolved dependencies and won't be started", (Object)bundle);
                    continue;
                }
                logger.warn("Error while starting bundle " + bundle + ". Cause: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void startBundlesPendingDependencies() {
        Bundle[] allBundles;
        int frameworkStartLevel = BundleLifecycleUtils.getFrameworkStartLevel();
        ArrayList<Bundle> bundlesToStart = new ArrayList<Bundle>();
        for (Bundle bundle : allBundles = BundleLifecycleUtils.getAllBundles()) {
            if (bundle == null || bundle.getState() == 8 || bundle.getState() == 32 || !((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).isPersistentlyStarted() || frameworkStartLevel < BundleLifecycleUtils.getBundleStartLevel(bundle)) continue;
            bundlesToStart.add(bundle);
        }
        BundleLifecycleUtils.startBundles(bundlesToStart);
    }

    public static void startModules(List<Bundle> moduleBundles, boolean useModuleManagerApi) {
        BundleStarter.startModules(moduleBundles, useModuleManagerApi);
    }
}

