/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.ArrayUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class SpringContextSingleton
implements ApplicationContextAware,
ApplicationListener<JahiaTemplateManagerService.TemplatePackageRedeployedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(SpringContextSingleton.class);
    private static final String[] APPLICATION_CONTEXT_INITIALIZATION_IN_PROGRESS_INDICATORS = new String[]{"org.jahia.test.osgi.SpringContextSingletonTest$GetBeanThread", "org.jahia.bundles.blueprint.extender.config.JahiaOsgiBundleXmlApplicationContext"};
    private static SpringContextSingleton ourInstance = new SpringContextSingleton();
    private ApplicationContext context;
    private boolean initialized;
    private Map<String, Resource[]> resourcesCache = new HashMap<String, Resource[]>(2);

    public static Object getBean(String beanId) {
        try {
            return SpringContextSingleton.getInstance().getContext().getBean(beanId);
        }
        catch (BeansException e) {
            return SpringContextSingleton.getBeanInModulesContext(beanId);
        }
    }

    public static Object getBeanInModulesContext(String beanId) {
        return SpringContextSingleton.getBeanInModulesContext(beanId, SettingsBean.getInstance().getModuleSpringBeansWaitingTimeout());
    }

    private static Object getBeanInModulesContext(final String beanId, long waitTimeout) {
        for (JahiaTemplatesPackage aPackage : ServicesRegistry.getInstance().getJahiaTemplateManagerService().getAvailableTemplatePackages()) {
            if (aPackage.getContext() == null || !aPackage.getContext().containsBean(beanId)) continue;
            return aPackage.getContext().getBean(beanId);
        }
        if (waitTimeout > 0L && SpringContextSingleton.isApplicationContextInitializationInProgress()) {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<Object> future = executor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    while (true) {
                        Thread.sleep(100L);
                        try {
                            return SpringContextSingleton.getBeanInModulesContext(beanId, 0L);
                        }
                        catch (NoSuchBeanDefinitionException e) {
                            logger.debug("Bean '{}' not found by the task loop, will retry in 100 ms", (Object)beanId);
                            continue;
                        }
                        break;
                    }
                }
            });
            if (SettingsBean.getInstance().isDevelopmentMode()) {
                logger.warn("Detected call to SpringContextSingleton.getBeanInModulesContext(...) for bean '{}' during module startup.Since 7.2.0.0 modules spring contexts are started independently, and beans may not be available.We recommend to use OSGI services instead of spring beans to communicate between modules.", (Object)beanId);
            }
            logger.info("Bean '{}' not found yet, will wait for its availability max {} seconds...", (Object)beanId, (Object)waitTimeout);
            try {
                Object object = future.get(waitTimeout, TimeUnit.SECONDS);
                return object;
            }
            catch (TimeoutException e) {
                future.cancel(true);
                logger.debug("Waiting for bean '{}' timed out", (Object)beanId);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new JahiaRuntimeException(e);
            }
            finally {
                executor.shutdownNow();
            }
            logger.info("Bean '{}' not found in module contexts", (Object)beanId);
        }
        throw new NoSuchBeanDefinitionException(beanId);
    }

    private static boolean isApplicationContextInitializationInProgress() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            for (String className : APPLICATION_CONTEXT_INITIALIZATION_IN_PROGRESS_INDICATORS) {
                if (!element.getClassName().equals(className)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> type) throws BeansException {
        LinkedHashMap found = new LinkedHashMap();
        found.putAll(SpringContextSingleton.getInstance().getContext().getBeansOfType(type));
        for (JahiaTemplatesPackage aPackage : ServicesRegistry.getInstance().getJahiaTemplateManagerService().getAvailableTemplatePackages()) {
            if (aPackage.getContext() == null) continue;
            found.putAll(aPackage.getContext().getBeansOfType(type));
        }
        return found;
    }

    public static SpringContextSingleton getInstance() {
        return ourInstance;
    }

    private SpringContextSingleton() {
    }

    public ApplicationContext getContext() {
        if (!this.initialized) {
            logger.warn("Trying to access Spring context before it is available ! Please refactor code to avoid this !");
        }
        return this.context;
    }

    public void publishEvent(ApplicationEvent event) {
        this.publishEvent(event, true);
    }

    public void publishEvent(ApplicationEvent event, boolean propagateToModules) {
        this.getContext().publishEvent(event);
        for (JahiaTemplatesPackage aPackage : ServicesRegistry.getInstance().getJahiaTemplateManagerService().getAvailableTemplatePackages()) {
            if (aPackage.getContext() == null) continue;
            this.multicastEvent(event, aPackage.getContext());
        }
    }

    private void multicastEvent(ApplicationEvent event, AbstractApplicationContext ctx) {
        if (!ctx.isActive()) {
            return;
        }
        if (ctx.containsBean("applicationEventMulticaster")) {
            ((ApplicationEventMulticaster)ctx.getBean("applicationEventMulticaster")).multicastEvent(event);
        } else {
            ctx.publishEvent(event);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void onApplicationEvent(JahiaTemplateManagerService.TemplatePackageRedeployedEvent event) {
        this.resourcesCache.clear();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        this.initialized = true;
    }

    public Resource[] getResources(String locationPatterns) throws IOException {
        return this.getResources(locationPatterns, true);
    }

    public Resource[] getResources(String locationPatterns, boolean useCache) throws IOException {
        Object[] allResources;
        Object[] objectArray = allResources = useCache ? this.resourcesCache.get(locationPatterns) : null;
        if (allResources == null) {
            allResources = new Resource[]{};
            for (String location : StringUtils.tokenizeToStringArray((String)locationPatterns, (String)",; \t\n")) {
                try {
                    allResources = (Resource[])ArrayUtils.addAll((Object[])allResources, (Object[])this.context.getResources(location.trim()));
                }
                catch (FileNotFoundException e) {
                    logger.debug("Cannot find resources", (Throwable)e);
                }
            }
            if (useCache) {
                this.resourcesCache.put(locationPatterns, (Resource[])allResources);
            }
        }
        return allResources;
    }
}

