/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.cache.ehcache;

import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListenerAdapter;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependenciesCacheEventListener
extends CacheEventListenerAdapter {
    private static Logger logger = LoggerFactory.getLogger(DependenciesCacheEventListener.class);

    public void notifyElementEvicted(Ehcache cache, Element element) {
        if (logger.isDebugEnabled()) {
            logger.debug("EHCache has evicted: " + element.getObjectKey() + " from cache " + cache.getName());
        }
        this.removeDependentElements(cache, element);
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
        if (logger.isDebugEnabled()) {
            logger.debug("EHCache has expired: " + element.getObjectKey() + " from cache " + cache.getName());
        }
        this.removeDependentElements(cache, element);
    }

    private void removeDependentElements(Ehcache cache, Element element) {
        ModuleCacheProvider cacheProvider = ModuleCacheProvider.getInstance();
        Cache htmlCache = cacheProvider.getCache();
        String cacheName = cache.getName();
        if (cacheName.equals(cacheProvider.getDependenciesCache().getName()) || cacheName.equals(cacheProvider.getRegexpDependenciesCache().getName())) {
            Set deps = (Set)element.getObjectValue();
            if (logger.isDebugEnabled()) {
                logger.debug("Evicting/Expiring " + deps.size() + " dependencies related to " + element.getObjectKey() + ".");
            }
            if (deps.contains("ALL")) {
                htmlCache.removeAll(true);
            } else {
                this.invalidateDependencies(deps, htmlCache);
            }
        }
    }

    private void invalidateDependencies(Set<String> deps, Cache cache) {
        cache.removeAll(deps);
    }
}

