/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.categories;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jahia.content.CategoryKey;
import org.jahia.content.JahiaObject;
import org.jahia.content.ObjectKey;
import org.jahia.exceptions.JahiaException;
import org.jahia.services.categories.CategoryBean;
import org.jahia.services.categories.CategoryService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Category
extends JahiaObject {
    private static final long serialVersionUID = 3389053914999712807L;
    public static final String PATH_DELIMITER = "/";
    private static Logger logger = LoggerFactory.getLogger(Category.class);
    private CategoryBean categoryBean = null;
    protected static CategoryService categoryService;

    public Category(CategoryBean categoryBean) {
        super(new CategoryKey(categoryBean.getId()));
        this.categoryBean = categoryBean;
    }

    public static Category createCategory(String key, Category parentCategory) throws JahiaException {
        Category category = categoryService.addCategory(key, parentCategory);
        return category;
    }

    public static Node getCategoriesRoot() throws JahiaException {
        return Category.getCategoriesRoot(JCRSessionFactory.getInstance().getCurrentUser());
    }

    public static Node getCategoriesRoot(JahiaUser p) throws JahiaException {
        Node categoriesRoot = categoryService.getCategoriesRoot();
        try {
            categoriesRoot.getUUID();
        }
        catch (RepositoryException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return categoriesRoot;
    }

    public static List<Category> getRootCategories(JahiaUser p) throws JahiaException {
        List<Category> rootCategories = categoryService.getRootCategories(p);
        return rootCategories;
    }

    public static Category getCategory(String key, JahiaUser p) throws JahiaException {
        Category category = null;
        List<Category> catList = categoryService.getCategory(key);
        if (catList.size() > 0) {
            category = catList.get(0);
        }
        return category;
    }

    public static Category getCategory(String key) throws JahiaException {
        return Category.getCategory(key, JCRSessionFactory.getInstance().getCurrentUser());
    }

    public static List<Category> getCategoriesWithKeyPrefix(String keyPrefix, String rootCategoryKey, JahiaUser p) throws JahiaException {
        ArrayList<Category> validCategories;
        List<Category> tmp = categoryService.getCategoryStartingByKeyPrefix(keyPrefix);
        if (rootCategoryKey == null) {
            validCategories = null;
        } else {
            validCategories = new ArrayList<Category>();
            Category.getAllChildrenCategoriesFrom(Category.getCategory(rootCategoryKey), p, validCategories);
        }
        ArrayList<Category> result = new ArrayList<Category>();
        if (tmp == null) {
            return result;
        }
        for (Category cat : tmp) {
            if (p != null || rootCategoryKey != null && !validCategories.contains(cat)) continue;
            result.add(cat);
        }
        return result;
    }

    public static List<Category> getCategoriesWithtitlePrefix(String titlePrefix, String rootCategoryKey, String languageCode, JahiaUser p) throws JahiaException {
        ArrayList<Category> validCategories;
        List<Category> tmp = categoryService.getCategoryStartingByTitlePrefix(titlePrefix, languageCode);
        if (rootCategoryKey == null) {
            validCategories = null;
        } else {
            validCategories = new ArrayList<Category>();
            Category.getAllChildrenCategoriesFrom(Category.getCategory(rootCategoryKey), p, validCategories);
        }
        ArrayList<Category> result = new ArrayList<Category>();
        if (tmp == null) {
            return result;
        }
        for (Category cat : tmp) {
            if (p != null || rootCategoryKey != null && !validCategories.contains(cat)) continue;
            result.add(cat);
        }
        return result;
    }

    public static List<Category> getCategoriesContainingStringInTitle(String string, String rootCategoryKey, String languageCode, JahiaUser p) throws JahiaException {
        ArrayList<Category> validCategories;
        List<Category> tmp = categoryService.getCategoriesContainingStringInTitle(string, languageCode);
        if (rootCategoryKey == null) {
            validCategories = null;
        } else {
            validCategories = new ArrayList<Category>();
            Category.getAllChildrenCategoriesFrom(Category.getCategory(rootCategoryKey), p, validCategories);
        }
        ArrayList<Category> result = new ArrayList<Category>();
        if (tmp == null) {
            return result;
        }
        for (Category cat : tmp) {
            if (p != null || rootCategoryKey != null && !validCategories.contains(cat)) continue;
            result.add(cat);
        }
        return result;
    }

    public static void getAllChildrenCategoriesFrom(Category startCategory, JahiaUser p, List<Category> result) throws JahiaException {
        List<Category> childCategories = startCategory.getChildCategories(p);
        for (Category curChildCategory : childCategories) {
            result.add(curChildCategory);
            Category.getAllChildrenCategoriesFrom(curChildCategory, p, result);
        }
    }

    public static Category getCategoryByUUID(String categoryUUID, JahiaUser p) throws JahiaException {
        Category category = categoryService.getCategoryByUUID(categoryUUID);
        if (p == null) {
            return category;
        }
        return category;
    }

    public static Category getCategoryByUUID(String categoryUUID) throws JahiaException {
        return Category.getCategoryByUUID(categoryUUID, JCRSessionFactory.getInstance().getCurrentUser());
    }

    public static Category getCategoryByPath(String categoryPath, JahiaUser p) throws JahiaException {
        Category category = categoryService.getCategoryByPath(categoryPath);
        if (p == null) {
            return category;
        }
        return category;
    }

    public static JahiaObject getChildInstance(ObjectKey objectKey, JahiaUser p) {
        try {
            Category category = categoryService.getCategoryByUUID(objectKey.getIDInType());
            if (p == null) {
                return category;
            }
            return category;
        }
        catch (JahiaException je) {
            logger.error("Error while trying to load category from object key " + objectKey.toString(), (Throwable)je);
            return null;
        }
    }

    public static JahiaObject getChildInstance(ObjectKey objectKey) {
        return Category.getChildInstance(objectKey, JCRSessionFactory.getInstance().getCurrentUser());
    }

    public static Set<Category> getObjectCategories(ObjectKey objectKey) throws JahiaException {
        return categoryService.getObjectCategories(objectKey);
    }

    public static List<Category> findCategoriesByPropNameAndValue(String propName, String propValue, JahiaUser p) {
        List<Category> foundCategories = categoryService.findCategoriesByPropNameAndValue(propName, propValue, p);
        return foundCategories;
    }

    public static Category getChildInstance(String IDInType, JahiaUser p) {
        try {
            return Category.getCategoryByUUID(IDInType, p);
        }
        catch (JahiaException je) {
            logger.debug("Error retrieving container instance for id : " + IDInType, (Throwable)je);
            return null;
        }
    }

    public static Category getChildInstance(String IDInType) {
        return Category.getChildInstance(IDInType, JCRSessionFactory.getInstance().getCurrentUser());
    }

    public String getKey() {
        if (this.categoryBean == null) {
            return null;
        }
        return this.categoryBean.getKey();
    }

    public String getID() {
        if (this.categoryBean == null) {
            return null;
        }
        return this.categoryBean.getId();
    }

    protected CategoryBean getCategoryBean() {
        return this.categoryBean;
    }

    @Override
    public ObjectKey getObjectKey() {
        if (this.categoryBean == null) {
            return null;
        }
        if (this.categoryBean.getId() == null || this.categoryBean.getId().length() == 0) {
            return null;
        }
        return new CategoryKey(this.categoryBean.getId());
    }

    public List<Category> getChildCategories(JahiaUser p) throws JahiaException {
        return categoryService.getCategoryChildCategories(this, p);
    }

    public List<Category> getChildCategories() throws JahiaException {
        return this.getChildCategories(JCRSessionFactory.getInstance().getCurrentUser());
    }

    public List<Category> getParentCategories(JahiaUser p) throws JahiaException {
        List<ObjectKey> parentKeys = this.getParentObjectKeys();
        ArrayList<Category> parentCategories = new ArrayList<Category>();
        Iterator<ObjectKey> parentKeyIter = parentKeys.iterator();
        while (parentKeyIter.hasNext()) {
            ObjectKey curKey = parentKeyIter.next();
            if (!(curKey instanceof CategoryKey)) continue;
            Category curParentCategory = (Category)Category.getChildInstance(curKey, p);
            parentCategories.add(0, curParentCategory);
            parentKeys = curParentCategory.getParentObjectKeys();
            parentKeyIter = parentKeys.iterator();
        }
        return parentCategories;
    }

    public List<Category> getParentCategories() throws JahiaException {
        return this.getParentCategories(JCRSessionFactory.getInstance().getCurrentUser());
    }

    public List<ObjectKey> getChildObjectKeys() throws JahiaException {
        return categoryService.getCategoryChildKeys(this);
    }

    public List<Category> getChildCategories(boolean recursive) throws JahiaException {
        List<Category> childs = categoryService.getCategoryChildCategories(this, JCRSessionFactory.getInstance().getCurrentUser());
        if (!recursive) {
            return childs;
        }
        ArrayList<Category> keysList = new ArrayList<Category>();
        for (Category cat : childs) {
            List<Category> subChilds = cat.getChildCategories(recursive);
            keysList.addAll(subChilds);
        }
        childs.addAll(keysList);
        return childs;
    }

    public List<ObjectKey> getParentObjectKeys() throws JahiaException {
        return categoryService.getCategoryParentKeys(this);
    }

    public String getTitle(Locale locale) {
        try {
            return categoryService.getTitleForCategory(this, locale);
        }
        catch (JahiaException je) {
            logger.error("Error while trying to retrieve title for category " + this.getObjectKey().toString(), (Throwable)je);
            return null;
        }
    }

    public String getTitle(Locale locale, String defaultValue) {
        String result = null;
        try {
            result = categoryService.getTitleForCategory(this, locale);
        }
        catch (JahiaException je) {
            logger.error("Error while trying to retrieve title for category " + this.getObjectKey().toString(), (Throwable)je);
        }
        if (result == null || "".equals(result.trim())) {
            return defaultValue;
        }
        return result;
    }

    public void setTitle(Locale locale, String title) {
        try {
            categoryService.setTitleForCategory(this, locale, title);
        }
        catch (JahiaException je) {
            logger.error("Error while trying to set title " + title + " for category " + this.getObjectKey().toString(), (Throwable)je);
        }
    }

    public void removeTitle(Locale locale) {
        try {
            categoryService.removeTitleForCategory(this, locale);
        }
        catch (JahiaException je) {
            logger.error("Error while trying to remove title for category " + this.getObjectKey().toString(), (Throwable)je);
        }
    }

    public void delete() throws JahiaException {
        categoryService.removeCategory(this);
    }

    public Properties getProperties() {
        return categoryService.getProperties(this.categoryBean.getId());
    }

    public void setProperties(Properties newProperties) {
        categoryService.setProperties(this.categoryBean.getId(), newProperties);
    }

    public String getProperty(String propertyName) {
        if (this.getProperties() != null) {
            return this.getProperties().getProperty(propertyName);
        }
        return null;
    }

    public void setProperty(String propertyName, String propertyValue) {
        if (this.getProperties() != null) {
            this.getProperties().setProperty(propertyName, propertyValue);
            this.setProperties(this.getProperties());
        } else {
            Properties properties = new Properties();
            properties.setProperty(propertyName, propertyValue);
            this.setProperties(properties);
        }
    }

    public void removeProperty(String propertyName) {
        if (this.getProperties() != null) {
            this.getProperties().remove(propertyName);
            this.setProperties(this.getProperties());
        }
    }

    public CategoryBean getJahiaCategory() {
        return this.categoryBean;
    }

    public String getCategoryPath() throws JahiaException {
        return this.categoryBean.getPath();
    }

    public static Category getLastCategoryNode(String path) throws JahiaException {
        if (path == null || "".equals(path.trim()) || !path.startsWith(PATH_DELIMITER)) {
            return null;
        }
        if (path.endsWith("/*")) {
            path = path.substring(0, path.length() - 2);
        } else if (path.endsWith(PATH_DELIMITER)) {
            path = path.substring(0, path.length() - 1);
        }
        int pos = path.lastIndexOf(PATH_DELIMITER);
        if (pos == -1) {
            return null;
        }
        String catKey = path.substring(pos + 1);
        return Category.getCategory(catKey);
    }

    public static String getCategoryKey(String categoryPath) {
        return StringUtils.substringAfterLast((String)categoryPath, (String)PATH_DELIMITER);
    }

    public static String getCategoryPath(String categoryKey) throws JahiaException {
        return Category.getCategory(categoryKey).getCategoryPath();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        return this.getID() != null ? this.getID().hashCode() : 0;
    }

    public boolean equals(Object category) {
        if (this == category) {
            return true;
        }
        return category != null && this.getClass() == category.getClass() && this.getID() != null && this.getID().equals(((Category)category).getID());
    }
}

