/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.Set;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.NameGenerationHelper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.utils.LanguageCodeConverters;

public class DefaultNameGenerationHelperImpl
implements NameGenerationHelper {
    private Set<String> randomizedNames;

    @Override
    public String generatNodeName(JCRNodeWrapper parent, String nodeType) {
        String defaultName = nodeType.substring(nodeType.lastIndexOf(":") + 1);
        if (this.getRandomizedNames() != null && this.getRandomizedNames().contains(nodeType)) {
            defaultName = defaultName + Math.round(Math.random() * 1000000.0);
        }
        return JCRContentUtils.findAvailableNodeName(parent, defaultName);
    }

    @Override
    public String generatNodeName(JCRNodeWrapper parent, String defaultLanguage, ExtendedNodeType nodeType, String targetName) {
        String defaultName = JCRContentUtils.generateNodeName(nodeType.getLabel(LanguageCodeConverters.languageCodeToLocale(defaultLanguage)));
        if (targetName != null && !"*".equals(targetName)) {
            defaultName = targetName;
        }
        if (this.getRandomizedNames() != null && this.getRandomizedNames().contains(nodeType.getName())) {
            defaultName = defaultName + Math.round(Math.random() * 1000000.0);
        }
        return JCRContentUtils.findAvailableNodeName(parent, defaultName);
    }

    public void setRandomizedNames(Set<String> randomizedNames) {
        this.randomizedNames = randomizedNames;
    }

    public Set<String> getRandomizedNames() {
        return this.randomizedNames;
    }
}

