/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRItemWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;

public class JCRItemWrapperImpl
implements JCRItemWrapper {
    protected JCRStoreProvider provider;
    protected Item item;
    protected String localPath;
    protected String localPathInProvider;
    protected JCRSessionWrapper session;

    protected JCRItemWrapperImpl(JCRSessionWrapper session, JCRStoreProvider provider) {
        this.session = session;
        this.provider = provider;
    }

    protected void setItem(Item item) {
        this.item = item;
    }

    public String getPath() {
        if ("/".equals(this.provider.getMountPoint())) {
            return this.localPath;
        }
        if ("/".equals(this.localPath)) {
            return this.provider.getMountPoint();
        }
        if (this.localPath.contains("@/")) {
            return this.localPath;
        }
        return this.provider.getMountPoint() + this.localPath.substring(this.provider.getRelativeRoot().length());
    }

    @Override
    public String getCanonicalPath() {
        if ("/".equals(this.provider.getMountPoint())) {
            return this.localPathInProvider;
        }
        if ("/".equals(this.localPathInProvider)) {
            return this.provider.getMountPoint();
        }
        return this.provider.getMountPoint() + this.localPathInProvider.substring(this.provider.getRelativeRoot().length());
    }

    public String getName() throws RepositoryException {
        return this.item.getName();
    }

    @Override
    public JCRItemWrapper getAncestor(int i) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        if (i >= this.provider.getDepth()) {
            return this.provider.getNodeWrapper((Node)this.item.getAncestor(i - this.provider.getDepth()), this.getSession());
        }
        if (i < 0) {
            throw new ItemNotFoundException();
        }
        return this.session.getItem(StringUtils.substringBeforeLast((String)this.provider.getMountPoint(), (String)"/")).getAncestor(i);
    }

    @Override
    public JCRNodeWrapper getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public int getDepth() throws RepositoryException {
        return this.provider.getDepth() + this.item.getDepth();
    }

    @Override
    public JCRSessionWrapper getSession() {
        return this.session;
    }

    public boolean isNode() {
        return this.item.isNode();
    }

    public boolean isNew() {
        return this.item.isNew();
    }

    public boolean isModified() {
        return this.item.isModified();
    }

    public boolean isSame(Item otherItem) throws RepositoryException {
        return otherItem.isSame(this.item);
    }

    public void accept(ItemVisitor itemVisitor) throws RepositoryException {
        this.item.accept(itemVisitor);
    }

    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.getSession().save();
    }

    @Override
    public void saveSession() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.getSession().save();
    }

    public void refresh(boolean b) throws InvalidItemStateException, RepositoryException {
        this.item.refresh(b);
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.getSession().removeFromCache(this);
        this.item.remove();
    }

    public String toString() {
        return this.item.toString();
    }
}

