/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.apache.commons.lang.StringUtils;
import org.jahia.api.Constants;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.JahiaService;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.VersionInfo;
import org.jahia.services.content.VersionIteratorImpl;
import org.jahia.services.content.decorator.JCRFrozenNodeAsRegular;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.utils.comparator.NumericStringComparator;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRVersionService
extends JahiaService {
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy_MM_dd_HH_mm_ss");
    private static JCRVersionService instance;
    private static transient Logger logger;
    private Set<String> mixinsToRemoveOnDestination = new HashSet<String>(Arrays.asList("jmix:referencesInField"));
    private Set<String> nodetypesToSkipWhenSynchronizing = new HashSet<String>(Arrays.asList("jnt:referenceInField"));

    public static synchronized JCRVersionService getInstance() {
        if (instance == null) {
            instance = new JCRVersionService();
        }
        return instance;
    }

    @Override
    public void start() throws JahiaInitializationException {
    }

    @Override
    public void stop() throws JahiaException {
    }

    public List<VersionInfo> getVersionInfos(Session session, JCRNodeWrapper node) throws RepositoryException {
        VersionHistory versionHistory = session.getWorkspace().getVersionManager().getVersionHistory(node.getPath());
        VersionIterator versions = versionHistory.getAllVersions();
        return this.getVersionsInfos(versionHistory, versions);
    }

    public List<VersionInfo> getLinearVersionInfos(Session session, JCRNodeWrapper node) throws RepositoryException {
        VersionHistory versionHistory = session.getWorkspace().getVersionManager().getVersionHistory(node.getPath());
        VersionIterator versions = versionHistory.getAllLinearVersions();
        return this.getVersionsInfos(versionHistory, versions);
    }

    private List<VersionInfo> getVersionsInfos(VersionHistory versionHistory, VersionIterator versions) throws RepositoryException {
        if (versions.hasNext()) {
            versions.nextVersion();
        }
        ArrayList<VersionInfo> versionList = new ArrayList<VersionInfo>();
        while (versions.hasNext()) {
            Version v = versions.nextVersion();
            String[] versionLabels = versionHistory.getVersionLabels(v);
            if (versionLabels == null || versionLabels.length <= 0) continue;
            for (String string : versionLabels) {
                VersionInfo versionInfo = new VersionInfo(v, string, 0);
                versionList.add(versionInfo);
            }
        }
        Collections.sort(versionList, new NumericStringComparator(((JCRSessionWrapper)versionHistory.getSession()).getLocale()));
        return versionList;
    }

    public static Version findClosestVersion(VersionHistory vh, Date versionDate) throws RepositoryException {
        VersionIterator vi;
        block22: {
            vi = null;
            try {
                vi = vh.getAllLinearVersions();
            }
            catch (ItemNotFoundException e) {
                String[] labels;
                for (String label : labels = vh.getVersionLabels()) {
                    if (!label.startsWith(vh.getSession().getWorkspace().getName() + "_removed")) continue;
                    try {
                        Date removedAt = DATE_FORMAT.parseDateTime(StringUtils.substringAfter((String)label, (String)(vh.getSession().getWorkspace().getName() + "_removed_at_"))).toDate();
                        if (removedAt.before(versionDate)) {
                            return null;
                        }
                    }
                    catch (IllegalArgumentException e1) {
                        logger.error("Cannot parse deletion date for label " + label, (Throwable)e1);
                        return null;
                    }
                    Version base = vh.getVersionByLabel(label);
                    LinkedList<Version> versions = new LinkedList<Version>();
                    while (base != null) {
                        versions.addFirst(base);
                        Version[] preds = base.getPredecessors();
                        if (preds.length == 0) {
                            base = null;
                            continue;
                        }
                        base = preds[0];
                    }
                    vi = new VersionIteratorImpl(versions.iterator(), (long)versions.size());
                    break;
                }
                if (vi != null) break block22;
                return null;
            }
        }
        if (vi.getSize() <= 1L) {
            return null;
        }
        Version lastVersion = null;
        Version closestVersion = null;
        if (vi.hasNext()) {
            vi.nextVersion();
        }
        String nodeTitle = null;
        StringBuilder propertyString = null;
        while (vi.hasNext()) {
            Version v = vi.nextVersion();
            if (logger.isDebugEnabled()) {
                try {
                    Node frozenNode = v.getFrozenNode();
                    propertyString = new StringBuilder();
                    PropertyIterator propertyIterator = frozenNode.getProperties();
                    while (propertyIterator.hasNext()) {
                        Property property = propertyIterator.nextProperty();
                        propertyString.append("  ");
                        propertyString.append(property.getName());
                        propertyString.append("=");
                        if (property.isMultiple()) {
                            for (Value value : property.getValues()) {
                                propertyString.append(value.getString());
                                propertyString.append(",");
                            }
                        } else {
                            propertyString.append(property.getValue().getString());
                        }
                        propertyString.append("\n");
                    }
                }
                catch (IllegalStateException e) {
                    propertyString.append(e.getMessage()).append("\n");
                }
            }
            Object checkinDate = null;
            boolean checkinDateAvailable = false;
            if (v.getCreated().getTime().compareTo(versionDate) > 0) {
                closestVersion = lastVersion;
                break;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Version " + v.getName() + " checkinDateAvailable=" + checkinDateAvailable + " checkinDate=" + checkinDate + " created=" + v.getCreated().getTime() + " properties:" + propertyString.toString());
            }
            lastVersion = v;
        }
        if (closestVersion == null && lastVersion != null && lastVersion.getCreated().getTime().compareTo(versionDate) <= 0) {
            closestVersion = lastVersion;
        }
        if (closestVersion != null && logger.isDebugEnabled()) {
            logger.debug("Resolved date " + versionDate + " for node title " + nodeTitle + " to closest version " + closestVersion.getName() + " createdTime=" + closestVersion.getCreated().getTime());
        }
        return closestVersion;
    }

    public void restoreVersionLabel(final JCRNodeWrapper node, final Date versionDate, final String label, final boolean allSubTree) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, node.getSession().getWorkspace().getName(), null, new JCRCallback<Object>(){

            @Override
            public Object doInJCR(final JCRSessionWrapper session) throws RepositoryException {
                String workspace = label != null ? StringUtils.substringBefore((String)label, (String)"_") : "live";
                JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, workspace, null, new JCRCallback<Object>(){

                    @Override
                    public Object doInJCR(JCRSessionWrapper frozensession) throws RepositoryException {
                        String path;
                        JCRNodeWrapper destinationNode = session.getNodeByUUID(node.getIdentifier());
                        VersionManager versionManager = session.getWorkspace().getVersionManager();
                        if (!versionManager.isCheckedOut(path = destinationNode.getPath())) {
                            versionManager.checkout(path);
                        }
                        frozensession.setVersionLabel(label);
                        frozensession.setVersionDate(versionDate);
                        JCRNodeWrapper frozenVersionAsRegular = frozensession.getNodeByUUID(destinationNode.getIdentifier());
                        if (frozenVersionAsRegular == null) {
                            throw new RepositoryException("label version " + label + " could not be found on node " + destinationNode.getPath());
                        }
                        JCRVersionService.this.synchronizeNode(frozenVersionAsRegular, destinationNode, session, allSubTree);
                        session.save();
                        return null;
                    }
                });
                return null;
            }
        });
    }

    private void synchronizeNode(JCRNodeWrapper frozenNode, JCRNodeWrapper destinationNode, JCRSessionWrapper session, boolean allSubTree) throws RepositoryException {
        ExtendedNodeType[] mixin;
        session.checkout(destinationNode);
        for (ExtendedNodeType aMixin : mixin = destinationNode.getMixinNodeTypes()) {
            String mixinName = aMixin.getName();
            if (!this.mixinsToRemoveOnDestination.contains(mixinName)) continue;
            logger.info("Removing mixin " + mixinName + " on node " + destinationNode.getPath());
            destinationNode.removeMixin(mixinName);
        }
        for (ExtendedNodeType aMixin : mixin = frozenNode.getMixinNodeTypes()) {
            if (Constants.forbiddenMixinToCopy.contains(aMixin.getName())) continue;
            logger.info("Adding mixin " + aMixin.getName() + " on node " + destinationNode.getPath());
            destinationNode.addMixin(aMixin.getName());
        }
        if (frozenNode.hasProperty("jcr:language")) {
            destinationNode.setProperty("jcr:language", frozenNode.getProperty("jcr:language").getString());
        }
        PropertyIterator props = frozenNode.getProperties();
        ArrayList<String> names = new ArrayList<String>();
        while (props.hasNext()) {
            Property property = props.nextProperty();
            String propertyName = property.getName();
            names.add(propertyName);
            logger.info("Checking property for updating " + propertyName + " from source node " + destinationNode.getPath());
            try {
                if (property.getDefinition().isProtected() || Constants.forbiddenPropertiesToCopy.contains(propertyName)) continue;
                logger.info("Setting property " + propertyName + " on node " + destinationNode.getPath());
                if (property.getDefinition().isMultiple() && property.isMultiple()) {
                    destinationNode.setProperty(propertyName, property.getValues());
                    continue;
                }
                destinationNode.setProperty(propertyName, property.getValue());
            }
            catch (Exception e) {
                logger.warn("Unable to copy property '" + propertyName + "'. Skipping.", (Throwable)e);
            }
        }
        PropertyIterator pi = destinationNode.getProperties();
        while (pi.hasNext()) {
            JCRPropertyWrapper oldChild = (JCRPropertyWrapper)pi.next();
            logger.info("Checking property for removal " + oldChild.getName() + " from destination node " + destinationNode.getPath());
            if (oldChild.getDefinition().isProtected() || names.contains(oldChild.getName())) continue;
            logger.info("Removing property " + oldChild.getName() + " on node " + destinationNode.getPath());
            oldChild.remove();
        }
        for (ExtendedNodeType aMixin : mixin = destinationNode.getMixinNodeTypes()) {
            if (frozenNode.isNodeType(aMixin.getName()) || Constants.forbiddenMixinToCopy.contains(aMixin.getName())) continue;
            logger.info("Removing mixin " + aMixin.getName() + " on node " + destinationNode.getPath());
            destinationNode.removeMixin(aMixin.getName());
        }
        HashMap<String, JCRNodeWrapper> destinationNodes = new HashMap<String, JCRNodeWrapper>();
        JCRNodeIteratorWrapper ni = destinationNode.getNodes();
        while (ni.hasNext()) {
            JCRNodeWrapper n = (JCRNodeWrapper)ni.nextNode();
            destinationNodes.put(n.getIdentifier(), n);
        }
        names.clear();
        ni = frozenNode.getNodes();
        while (ni.hasNext()) {
            VersionHistory history;
            JCRNodeWrapper child = (JCRNodeWrapper)ni.next();
            if (child.getName().equals("j:acl")) continue;
            names.add(child.getName());
            if (destinationNodes.containsKey(child.getIdentifier())) {
                JCRNodeWrapper node = (JCRNodeWrapper)destinationNodes.remove(child.getIdentifier());
                this.synchronizeNode(child, node, session, allSubTree);
                continue;
            }
            if (child.getRealNode().getParent().isNodeType("nt:frozenNode")) {
                String primaryNodeType = child.getPrimaryNodeType().getName();
                if (this.nodetypesToSkipWhenSynchronizing.contains(primaryNodeType)) continue;
                JCRNodeWrapper node = destinationNode.addNode(child.getName(), primaryNodeType);
                this.synchronizeNode(child, node, session, allSubTree);
                continue;
            }
            try {
                history = (VersionHistory)child.getRealNode().getProperty("jcr:versionHistory").getNode();
            }
            catch (RepositoryException e) {
                history = (VersionHistory)child.getRealNode().getParent().getParent();
            }
            Version version = JCRVersionService.findVersionByLabel(history, ((JCRFrozenNodeAsRegular)child).getVersionLabel());
            if (version == null) {
                version = JCRVersionService.findClosestVersion(history, ((JCRFrozenNodeAsRegular)child).getVersionDate());
            }
            if (version == null) continue;
            session.save();
            logger.info("Restoring node " + child.getPath() + " on parent " + destinationNode.getPath());
            session.getWorkspace().getVersionManager().restore(child.getPath(), version, false);
            JCRNodeWrapper node = session.getNode(child.getPath(), false);
            this.synchronizeNode(child, node, session, allSubTree);
        }
        for (JCRNodeWrapper oldChild : destinationNodes.values()) {
            if (names.contains(oldChild.getName()) || oldChild.isNodeType("jmix:publication") && !allSubTree || oldChild.isNodeType("jnt:translation")) continue;
            logger.info("Removing node " + oldChild.getName() + " on node " + destinationNode.getPath());
            oldChild.remove();
        }
        if (destinationNode.getPrimaryNodeType().hasOrderableChildNodes()) {
            Collections.reverse(names);
            String previous = null;
            for (String name : names) {
                destinationNode.orderBefore(name, previous);
                previous = name;
            }
        }
        if (destinationNode.isNodeType("mix:lastModified")) {
            destinationNode.setProperty("jcr:lastModified", GregorianCalendar.getInstance());
        }
    }

    public static Version findVersionByLabel(VersionHistory vh, String label) throws RepositoryException {
        if (label != null && !"".equals(label.trim()) && vh.hasVersionLabel(label.trim())) {
            VersionIterator allVersions = vh.getAllVersions();
            while (allVersions.hasNext()) {
                Version version = allVersions.nextVersion();
                if (!Arrays.asList(vh.getVersionLabels(version)).contains(label.trim())) continue;
                return version;
            }
        }
        return null;
    }

    public void addVersionLabel(final JCRNodeWrapper node, final String label) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, node.getSession().getWorkspace().getName(), null, new JCRCallback<Object>(){

            @Override
            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                String labelWithWs;
                JCRNodeWrapper nodeWrapper = session.getNodeByUUID(node.getIdentifier());
                VersionManager versionManager = session.getWorkspace().getVersionManager();
                VersionHistory versionHistory = versionManager.getVersionHistory(node.getPath());
                if (!versionHistory.hasVersionLabel(labelWithWs = node.getSession().getWorkspace().getName() + "_" + label)) {
                    Version version = versionManager.getBaseVersion(node.getPath());
                    if (logger.isDebugEnabled()) {
                        logger.debug("Add version label " + labelWithWs + " on " + node.getPath() + " for version " + version.getName());
                    }
                    if (nodeWrapper.isVersioned()) {
                        versionHistory.addVersionLabel(version.getName(), labelWithWs, true);
                    }
                }
                return null;
            }
        });
    }

    public void addVersionLabel(final List<String> allUuids, final String label, final String workspace) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, workspace, null, new JCRCallback<Object>(){

            @Override
            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                VersionManager versionManager = session.getWorkspace().getVersionManager();
                for (String allUuid : allUuids) {
                    try {
                        String labelWithWs;
                        JCRNodeWrapper nodeWrapper = session.getNodeByUUID(allUuid);
                        VersionHistory versionHistory = versionManager.getVersionHistory(nodeWrapper.getPath());
                        if (versionHistory.hasVersionLabel(labelWithWs = workspace + "_" + label)) continue;
                        Version version = versionManager.getBaseVersion(nodeWrapper.getPath());
                        if (logger.isDebugEnabled()) {
                            logger.debug("Add version label " + labelWithWs + " on " + nodeWrapper.getPath() + " for version " + version.getName());
                        }
                        if (!nodeWrapper.isVersioned()) continue;
                        versionHistory.addVersionLabel(version.getName(), labelWithWs, true);
                    }
                    catch (RepositoryException e) {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                }
                return null;
            }
        });
    }

    public void setMixinsToRemoveOnDestination(Set<String> mixinsToRemoveOnDestination) {
        this.mixinsToRemoveOnDestination = mixinsToRemoveOnDestination;
    }

    static {
        logger = LoggerFactory.getLogger(JCRVersionService.class);
    }
}

