/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidLifecycleTransitionException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.mutable.MutableInt;
import org.jahia.services.content.JCRItemWrapper;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRNodeWrapperImpl;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRPropertyWrapperImpl;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.LazyPropertyIterator;
import org.jahia.services.content.VersionInfo;
import org.jahia.services.content.decorator.JCRFileContent;
import org.jahia.services.content.decorator.JCRPlaceholderNode;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRNodeDecorator
implements JCRNodeWrapper {
    private static final Logger logger = LoggerFactory.getLogger(JCRNodeDecorator.class);
    protected JCRNodeWrapper node;

    public JCRNodeDecorator(JCRNodeWrapper node) {
        if (node instanceof JCRNodeDecorator) {
            logger.warn("An already decorated node shouldn't be decorated");
            Thread.dumpStack();
        }
        this.node = node;
    }

    @Override
    public Node getRealNode() {
        return this.node.getRealNode();
    }

    @Override
    public JCRUserNode getUser() {
        return this.node.getUser();
    }

    @Override
    public boolean hasTranslations() throws RepositoryException {
        return this.node.hasTranslations();
    }

    @Override
    public boolean checkI18nAndMandatoryPropertiesForLocale(Locale locale) throws RepositoryException {
        return this.node.checkI18nAndMandatoryPropertiesForLocale(locale);
    }

    @Override
    public Map<String, List<String[]>> getAclEntries() {
        return this.node.getAclEntries();
    }

    @Override
    public Map<String, Map<String, String>> getActualAclEntries() {
        return this.node.getActualAclEntries();
    }

    @Override
    public Map<String, List<JCRNodeWrapper>> getAvailableRoles() throws RepositoryException {
        return this.node.getAvailableRoles();
    }

    @Override
    public boolean hasPermission(String perm) {
        return this.node.hasPermission(perm);
    }

    @Override
    public Set<String> getPermissions() {
        return this.node.getPermissions();
    }

    @Override
    public BitSet getPermissionsAsBitSet() {
        return this.node.getPermissionsAsBitSet();
    }

    @Override
    public boolean grantRoles(String principalKey, Set<String> roles) throws RepositoryException {
        return this.node.grantRoles(principalKey, roles);
    }

    @Override
    public boolean denyRoles(String principalKey, Set<String> roles) throws RepositoryException {
        return this.node.denyRoles(principalKey, roles);
    }

    @Override
    public boolean changeRoles(String principalKey, Map<String, String> perm) throws RepositoryException {
        return this.node.changeRoles(principalKey, perm);
    }

    @Override
    public boolean revokeRolesForPrincipal(String principalKey) throws RepositoryException {
        return this.node.revokeRolesForPrincipal(principalKey);
    }

    @Override
    public boolean revokeAllRoles() throws RepositoryException {
        return this.node.revokeAllRoles();
    }

    @Override
    public boolean getAclInheritanceBreak() throws RepositoryException {
        return this.node.getAclInheritanceBreak();
    }

    @Override
    public boolean setAclInheritanceBreak(boolean breakAclInheritance) throws RepositoryException {
        return this.node.setAclInheritanceBreak(breakAclInheritance);
    }

    @Override
    public JCRNodeWrapper uploadFile(String name, InputStream is, String contentType) throws RepositoryException {
        return this.node.uploadFile(name, is, contentType);
    }

    @Override
    public JCRNodeWrapper createCollection(String name) throws RepositoryException {
        return this.node.createCollection(name);
    }

    @Override
    public String getAbsoluteUrl(ServletRequest request) {
        return this.node.getAbsoluteUrl(request);
    }

    @Override
    public String getUrl() {
        return this.node.getUrl();
    }

    @Override
    public String getAbsoluteWebdavUrl(HttpServletRequest request) {
        return this.node.getAbsoluteWebdavUrl(request);
    }

    @Override
    public String getWebdavUrl() {
        return this.node.getWebdavUrl();
    }

    @Override
    public List<String> getThumbnails() {
        return this.node.getThumbnails();
    }

    @Override
    public String getThumbnailUrl(String name) {
        return this.node.getThumbnailUrl(name);
    }

    @Override
    public Map<String, String> getThumbnailUrls() {
        return this.node.getThumbnailUrls();
    }

    @Override
    public Map<String, String> getPropertiesAsString() throws RepositoryException {
        return this.node.getPropertiesAsString();
    }

    @Override
    public String getPrimaryNodeTypeName() throws RepositoryException {
        return this.node.getPrimaryNodeTypeName();
    }

    @Override
    public List<String> getNodeTypes() throws RepositoryException {
        return this.node.getNodeTypes();
    }

    @Override
    public boolean isCollection() {
        return this.node.isCollection();
    }

    @Override
    public boolean isFile() {
        return this.node.isFile();
    }

    @Override
    public boolean isPortlet() {
        return this.node.isPortlet();
    }

    @Override
    public Date getLastModifiedAsDate() {
        return this.node.getLastModifiedAsDate();
    }

    @Override
    public Date getLastPublishedAsDate() {
        return this.node.getLastPublishedAsDate();
    }

    @Override
    public Date getContentLastModifiedAsDate() {
        return this.node.getContentLastModifiedAsDate();
    }

    @Override
    public Date getContentLastPublishedAsDate() {
        return this.node.getContentLastPublishedAsDate();
    }

    @Override
    public Date getCreationDateAsDate() {
        return this.node.getCreationDateAsDate();
    }

    @Override
    public String getCreationUser() {
        return this.node.getCreationUser();
    }

    @Override
    public String getModificationUser() {
        return this.node.getModificationUser();
    }

    @Override
    public String getPublicationUser() {
        return this.node.getPublicationUser();
    }

    @Override
    public String getLanguage() {
        return this.node.getLanguage();
    }

    @Override
    public String getPropertyAsString(String name) {
        return this.node.getPropertyAsString(name);
    }

    @Override
    public JCRPropertyWrapper setProperty(String namespace, String name, String value) throws RepositoryException {
        return this.decorateProperty(this.node.setProperty(namespace, name, value));
    }

    @Override
    public List<JCRItemWrapper> getAncestors() throws RepositoryException {
        return this.node.getAncestors();
    }

    @Override
    public boolean rename(String newName) throws RepositoryException {
        return this.node.rename(newName);
    }

    @Override
    public boolean copy(String dest) throws RepositoryException {
        return this.node.copy(dest);
    }

    @Override
    public boolean copy(String dest, String name) throws RepositoryException {
        return this.node.copy(dest, name);
    }

    @Override
    public boolean copy(JCRNodeWrapper dest, String name, boolean allowsExternalSharedNodes) throws RepositoryException {
        return this.node.copy(dest, name, allowsExternalSharedNodes);
    }

    @Override
    public boolean copy(JCRNodeWrapper dest, String name, boolean allowsExternalSharedNodes, Map<String, List<String>> references) throws RepositoryException {
        return this.node.copy(dest, name, allowsExternalSharedNodes, references);
    }

    @Override
    public boolean copy(JCRNodeWrapper dest, String name, boolean allowsExternalSharedNodes, List<String> ignoreNodeTypes, int maxBatch) throws RepositoryException {
        return this.node.copy(dest, name, allowsExternalSharedNodes, ignoreNodeTypes, maxBatch);
    }

    @Override
    public boolean copy(JCRNodeWrapper dest, String name, boolean allowsExternalSharedNodes, Map<String, List<String>> references, List<String> ignoreNodeTypes, int maxBatch, MutableInt batch) throws RepositoryException {
        return this.internalCopy(dest, name, allowsExternalSharedNodes, references, ignoreNodeTypes, maxBatch, batch, true);
    }

    public boolean internalCopy(JCRNodeWrapper dest, String name, boolean allowsExternalSharedNodes, Map<String, List<String>> references, List<String> ignoreNodeTypes, int maxBatch, MutableInt batch, boolean isTopObject) throws RepositoryException {
        if (!isTopObject && this.node instanceof JCRNodeWrapperImpl) {
            return ((JCRNodeWrapperImpl)this.node).internalCopy(dest, name, allowsExternalSharedNodes, references, ignoreNodeTypes, maxBatch, batch, isTopObject);
        }
        return this.node.copy(dest, name, allowsExternalSharedNodes, references, ignoreNodeTypes, maxBatch, batch);
    }

    @Override
    public void copyProperties(JCRNodeWrapper destinationNode, Map<String, List<String>> references) throws RepositoryException {
        this.node.copyProperties(destinationNode, references);
    }

    @Override
    public boolean lockAndStoreToken(String type, String userID) throws RepositoryException {
        return this.node.lockAndStoreToken(type, userID);
    }

    @Override
    public boolean lockAndStoreToken(String type) throws RepositoryException {
        return this.node.lockAndStoreToken(type);
    }

    @Override
    public String getLockOwner() throws RepositoryException {
        return this.node.getLockOwner();
    }

    @Override
    public Map<String, List<String>> getLockInfos() throws RepositoryException {
        return this.node.getLockInfos();
    }

    @Override
    public void versionFile() {
        this.node.versionFile();
    }

    @Override
    public boolean isVersioned() {
        return this.node.isVersioned();
    }

    @Override
    public void checkpoint() {
        this.node.checkpoint();
    }

    @Override
    public List<String> getVersions() {
        return this.node.getVersions();
    }

    @Override
    public JCRStoreProvider getJCRProvider() {
        return this.node.getJCRProvider();
    }

    @Override
    public JCRStoreProvider getProvider() {
        return this.node.getProvider();
    }

    @Override
    public JCRFileContent getFileContent() {
        return this.node.getFileContent();
    }

    @Override
    public ExtendedPropertyDefinition getApplicablePropertyDefinition(String propertyName) throws RepositoryException {
        return this.node.getApplicablePropertyDefinition(propertyName);
    }

    @Override
    public ExtendedPropertyDefinition getApplicablePropertyDefinition(String propertyName, int requiredPropertyType, boolean isMultiple) throws RepositoryException {
        return this.node.getApplicablePropertyDefinition(propertyName, requiredPropertyType, isMultiple);
    }

    @Override
    public List<ExtendedPropertyDefinition> getReferenceProperties() throws RepositoryException {
        return this.node.getReferenceProperties();
    }

    @Override
    public ExtendedNodeDefinition getApplicableChildNodeDefinition(String childName, String nodeType) throws ConstraintViolationException, RepositoryException {
        return this.node.getApplicableChildNodeDefinition(childName, nodeType);
    }

    @Override
    public JCRNodeWrapper addNode(String s) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        return this.node.addNode(s);
    }

    @Override
    public JCRNodeWrapper addNode(String s, String s1) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        return this.node.addNode(s, s1);
    }

    @Override
    public JCRNodeWrapper addNode(String relPath, String primaryNodeTypeName, String identifier, Calendar created, String createdBy, Calendar lastModified, String lastModifiedBy) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        return this.node.addNode(relPath, primaryNodeTypeName, identifier, created, createdBy, lastModified, lastModifiedBy);
    }

    @Override
    public JCRPlaceholderNode getPlaceholder() throws RepositoryException {
        return new JCRPlaceholderNode(this.node);
    }

    public void orderBefore(String s, String s1) throws UnsupportedRepositoryOperationException, VersionException, ConstraintViolationException, ItemNotFoundException, LockException, RepositoryException {
        this.node.orderBefore(s, s1);
    }

    @Override
    public JCRPropertyWrapper setProperty(String s, Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.decorateProperty(this.node.setProperty(s, value));
    }

    @Override
    public JCRPropertyWrapper setProperty(String s, Value value, int i) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.decorateProperty(this.node.setProperty(s, value, i));
    }

    @Override
    public JCRPropertyWrapper setProperty(String s, Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.decorateProperty(this.node.setProperty(s, values));
    }

    @Override
    public JCRPropertyWrapper setProperty(String s, Value[] values, int i) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.decorateProperty(this.node.setProperty(s, values, i));
    }

    @Override
    public JCRPropertyWrapper setProperty(String s, String[] strings) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.decorateProperty(this.node.setProperty(s, strings));
    }

    @Override
    public JCRPropertyWrapper setProperty(String s, String[] strings, int i) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.decorateProperty(this.node.setProperty(s, strings, i));
    }

    @Override
    public JCRPropertyWrapper setProperty(String s, String s1) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.decorateProperty(this.node.setProperty(s, s1));
    }

    @Override
    public JCRPropertyWrapper setProperty(String s, String s1, int i) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.decorateProperty(this.node.setProperty(s, s1, i));
    }

    @Override
    public JCRPropertyWrapper setProperty(String s, InputStream inputStream) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.decorateProperty(this.node.setProperty(s, inputStream));
    }

    @Override
    public JCRPropertyWrapper setProperty(String name, Binary value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.decorateProperty(this.node.setProperty(name, value));
    }

    @Override
    public JCRPropertyWrapper setProperty(String s, boolean b) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.decorateProperty(this.node.setProperty(s, b));
    }

    @Override
    public JCRPropertyWrapper setProperty(String s, double v) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.decorateProperty(this.node.setProperty(s, v));
    }

    @Override
    public JCRPropertyWrapper setProperty(String name, BigDecimal value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.decorateProperty(this.node.setProperty(name, value));
    }

    @Override
    public JCRPropertyWrapper setProperty(String s, long l) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.decorateProperty(this.node.setProperty(s, l));
    }

    @Override
    public JCRPropertyWrapper setProperty(String s, Calendar calendar) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.decorateProperty(this.node.setProperty(s, calendar));
    }

    @Override
    public JCRPropertyWrapper setProperty(String s, Node node) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.decorateProperty(this.node.setProperty(s, node));
    }

    @Override
    public JCRNodeWrapper getNode(String s) throws PathNotFoundException, RepositoryException {
        return this.node.getNode(s);
    }

    @Override
    public JCRNodeIteratorWrapper getNodes() throws RepositoryException {
        return this.node.getNodes();
    }

    @Override
    public JCRNodeIteratorWrapper getNodes(String s) throws RepositoryException {
        return this.node.getNodes(s);
    }

    @Override
    public JCRNodeIteratorWrapper getNodes(String[] nameGlobs) throws RepositoryException {
        return this.node.getNodes(nameGlobs);
    }

    @Override
    public JCRPropertyWrapper getProperty(String s) throws PathNotFoundException, RepositoryException {
        return this.decorateProperty(this.node.getProperty(s));
    }

    public PropertyIterator getProperties() throws RepositoryException {
        Locale locale = this.getSession().getLocale();
        if (locale != null) {
            return new LazyPropertyIterator(this, locale);
        }
        return new LazyPropertyIterator(this, null);
    }

    public PropertyIterator getProperties(String s) throws RepositoryException {
        Locale locale = this.getSession().getLocale();
        if (locale != null) {
            return new LazyPropertyIterator((JCRNodeWrapper)this, locale, s);
        }
        return new LazyPropertyIterator((JCRNodeWrapper)this, null, s);
    }

    public PropertyIterator getProperties(String[] strings) throws RepositoryException {
        Locale locale = this.getSession().getLocale();
        if (locale != null) {
            return new LazyPropertyIterator((JCRNodeWrapper)this, locale, strings);
        }
        return new LazyPropertyIterator((JCRNodeWrapper)this, null, strings);
    }

    @Override
    public JCRItemWrapper getPrimaryItem() throws ItemNotFoundException, RepositoryException {
        return this.node.getPrimaryItem();
    }

    public String getUUID() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.node.getUUID();
    }

    public String getIdentifier() throws RepositoryException {
        return this.node.getIdentifier();
    }

    public int getIndex() throws RepositoryException {
        return this.node.getIndex();
    }

    public PropertyIterator getReferences() throws RepositoryException {
        return this.node.getReferences();
    }

    public PropertyIterator getReferences(String name) throws RepositoryException {
        return this.node.getReferences(name);
    }

    public PropertyIterator getWeakReferences() throws RepositoryException {
        return this.node.getWeakReferences();
    }

    public PropertyIterator getWeakReferences(String name) throws RepositoryException {
        return this.node.getWeakReferences(name);
    }

    public boolean hasNode(String s) throws RepositoryException {
        return this.node.hasNode(s);
    }

    public boolean hasProperty(String s) throws RepositoryException {
        return this.node.hasProperty(s);
    }

    public boolean hasNodes() throws RepositoryException {
        return this.node.hasNodes();
    }

    public boolean hasProperties() throws RepositoryException {
        return this.node.hasProperties();
    }

    @Override
    public ExtendedNodeType getPrimaryNodeType() throws RepositoryException {
        return this.node.getPrimaryNodeType();
    }

    @Override
    public ExtendedNodeType[] getMixinNodeTypes() throws RepositoryException {
        return this.node.getMixinNodeTypes();
    }

    public boolean isNodeType(String s) throws RepositoryException {
        return this.node.isNodeType(s);
    }

    public void setPrimaryType(String nodeTypeName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.node.setPrimaryType(nodeTypeName);
    }

    public void addMixin(String s) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.node.addMixin(s);
    }

    public void removeMixin(String s) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.node.removeMixin(s);
    }

    public boolean canAddMixin(String s) throws NoSuchNodeTypeException, RepositoryException {
        return this.node.canAddMixin(s);
    }

    @Override
    public ExtendedNodeDefinition getDefinition() throws RepositoryException {
        return this.node.getDefinition();
    }

    public Version checkin() throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        return this.node.checkin();
    }

    public void checkout() throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        this.node.checkout();
    }

    public void doneMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        this.node.doneMerge(version);
    }

    public void cancelMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        this.node.cancelMerge(version);
    }

    public void update(String s) throws NoSuchWorkspaceException, AccessDeniedException, LockException, InvalidItemStateException, RepositoryException {
        this.node.update(s);
    }

    @Override
    public JCRNodeIteratorWrapper merge(String s, boolean b) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        return this.node.merge(s, b);
    }

    public String getCorrespondingNodePath(String s) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        return this.node.getCorrespondingNodePath(s);
    }

    @Override
    public JCRNodeIteratorWrapper getSharedSet() throws RepositoryException {
        return this.node.getSharedSet();
    }

    public void removeSharedSet() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.node.removeSharedSet();
    }

    public void removeShare() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.node.removeShare();
    }

    public boolean isCheckedOut() throws RepositoryException {
        return this.node.isCheckedOut();
    }

    public void restore(String s, boolean b) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.node.restore(s, b);
    }

    public void restore(Version version, boolean b) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
        this.node.restore(version, b);
    }

    public void restore(Version version, String s, boolean b) throws PathNotFoundException, ItemExistsException, VersionException, ConstraintViolationException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.node.restore(version, s, b);
    }

    public void restoreByLabel(String s, boolean b) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.node.restoreByLabel(s, b);
    }

    public VersionHistory getVersionHistory() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.node.getVersionHistory();
    }

    public Version getBaseVersion() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.node.getBaseVersion();
    }

    @Override
    public Lock lock(boolean b, boolean b1) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        return this.node.lock(b, b1);
    }

    @Override
    public Lock getLock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        return this.node.getLock();
    }

    @Override
    public void unlock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        this.node.unlock();
    }

    @Override
    public void unlock(String type) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        this.node.unlock(type);
    }

    @Override
    public void unlock(String type, String userID) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        this.node.unlock(type, userID);
    }

    @Override
    public void clearAllLocks() throws RepositoryException {
        this.node.clearAllLocks();
    }

    @Override
    public void checkLock() throws RepositoryException {
        this.node.checkLock();
    }

    @Override
    public boolean holdsLock() throws RepositoryException {
        return this.node.holdsLock();
    }

    public void followLifecycleTransition(String transition) throws UnsupportedRepositoryOperationException, InvalidLifecycleTransitionException, RepositoryException {
        this.node.followLifecycleTransition(transition);
    }

    public String[] getAllowedLifecycleTransistions() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.node.getAllowedLifecycleTransistions();
    }

    @Override
    public boolean isLocked() {
        return this.node.isLocked();
    }

    @Override
    public boolean isLockable() {
        return this.node.isLockable();
    }

    @Override
    public List<Locale> getLockedLocales() throws RepositoryException {
        return this.node.getLockedLocales();
    }

    @Override
    public String getPath() {
        return this.node.getPath();
    }

    @Override
    public String getName() {
        return this.node.getName();
    }

    @Override
    public JCRItemWrapper getAncestor(int i) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.node.getAncestor(i);
    }

    @Override
    public JCRNodeWrapper getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.node.getParent();
    }

    public int getDepth() throws RepositoryException {
        return this.node.getDepth();
    }

    @Override
    public JCRSessionWrapper getSession() throws RepositoryException {
        return this.node.getSession();
    }

    public boolean isNode() {
        return this.node.isNode();
    }

    public boolean isNew() {
        return this.node.isNew();
    }

    public boolean isModified() {
        return this.node.isModified();
    }

    public boolean isSame(Item item) throws RepositoryException {
        return this.node.isSame(item);
    }

    public void accept(ItemVisitor itemVisitor) throws RepositoryException {
        this.node.accept(itemVisitor);
    }

    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.node.save();
    }

    @Override
    public void saveSession() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.node.saveSession();
    }

    public void refresh(boolean b) throws InvalidItemStateException, RepositoryException {
        this.node.refresh(b);
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.node.remove();
    }

    @Override
    public List<Locale> getExistingLocales() throws RepositoryException {
        return this.node.getExistingLocales();
    }

    @Override
    public NodeIterator getI18Ns() throws RepositoryException {
        return this.node.getI18Ns();
    }

    @Override
    public Node getI18N(Locale locale) throws RepositoryException {
        return this.node.getI18N(locale);
    }

    @Override
    public Node getI18N(Locale locale, boolean fallback) throws RepositoryException {
        return this.node.getI18N(locale, fallback);
    }

    @Override
    public boolean hasI18N(Locale locale) throws RepositoryException {
        return this.node.hasI18N(locale);
    }

    @Override
    public boolean hasI18N(Locale locale, boolean fallback) throws RepositoryException {
        return this.node.hasI18N(locale, fallback);
    }

    @Override
    public Node getOrCreateI18N(Locale locale) throws RepositoryException {
        return this.node.getOrCreateI18N(locale);
    }

    @Override
    public Node getOrCreateI18N(Locale locale, Calendar created, String createdBy, Calendar lastModified, String lastModifiedBy) throws RepositoryException {
        return this.node.getOrCreateI18N(locale, created, createdBy, lastModified, lastModifiedBy);
    }

    @Override
    public JCRNodeWrapper clone(JCRNodeWrapper sharedNode, String name) throws ItemExistsException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        return this.node.clone(sharedNode, name);
    }

    @Override
    public boolean checkValidity() {
        return this.node.checkValidity();
    }

    @Override
    public boolean checkLanguageValidity(Set<String> languages) {
        return this.node.checkLanguageValidity(languages);
    }

    @Override
    public JCRSiteNode getResolveSite() throws RepositoryException {
        return this.node.getResolveSite();
    }

    @Override
    public List<VersionInfo> getVersionInfos() throws RepositoryException {
        return this.node.getVersionInfos();
    }

    @Override
    public List<VersionInfo> getLinearVersionInfos() throws RepositoryException {
        return this.node.getLinearVersionInfos();
    }

    @Override
    public List<Version> getVersionsAsVersion() {
        return this.node.getVersionsAsVersion();
    }

    @Override
    public String getDisplayableName() {
        return this.node.getDisplayableName();
    }

    @Override
    public String getUnescapedName() {
        return this.node.getUnescapedName();
    }

    @Override
    public AccessControlManager getAccessControlManager() throws RepositoryException {
        return this.node.getAccessControlManager();
    }

    @Override
    public boolean canMarkForDeletion() throws RepositoryException {
        return this.node.canMarkForDeletion();
    }

    @Override
    public boolean isMarkedForDeletion() throws RepositoryException {
        return this.node.isMarkedForDeletion();
    }

    @Override
    public void markForDeletion(String comment) throws RepositoryException {
        this.node.markForDeletion(comment);
    }

    @Override
    public void unmarkForDeletion() throws RepositoryException {
        this.node.unmarkForDeletion();
    }

    public String toString() {
        return this.node.toString();
    }

    @Override
    public String getCanonicalPath() {
        return this.node.getCanonicalPath();
    }

    public boolean equals(Object o) {
        if (o != null && this.getClass() == o.getClass()) {
            return this.node.equals(((JCRNodeDecorator)o).node);
        }
        return false;
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public JCRNodeWrapper getDecoratedNode() {
        return this.node;
    }

    public JCRPropertyWrapper decorateProperty(Property property) throws RepositoryException {
        if (property == null) {
            return null;
        }
        Property decoratedProperty = property;
        ExtendedPropertyDefinition extendedPropertyDefinition = null;
        while (decoratedProperty instanceof JCRPropertyWrapper) {
            JCRPropertyWrapper jcrPropertyWrapper = (JCRPropertyWrapper)decoratedProperty;
            if ((decoratedProperty = jcrPropertyWrapper.getRealProperty()) == null) {
                return null;
            }
            extendedPropertyDefinition = (ExtendedPropertyDefinition)jcrPropertyWrapper.getDefinition();
        }
        if (extendedPropertyDefinition != null) {
            return new JCRPropertyWrapperImpl(this, decoratedProperty, this.getSession(), this.getProvider(), extendedPropertyDefinition);
        }
        throw new ConstraintViolationException("Couldn't find definition for property " + property.getPath());
    }
}

